/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.GroupModelProvider;
import com.jidesoft.grid.GroupTableHeader;
import com.jidesoft.grid.NestedTableHeader;
import com.jidesoft.grid.TableHeaderPopupMenuCustomizer;
import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;

public class TableHeaderPopupMenuInstaller
extends MouseAdapter
implements PropertyChangeListener {
    private JTable \u0101;
    public static final String CLIENT_PROPERTY_POPUP_MENU_INSTALLER = "TableHeaderPopupMenuInstaller";
    List<TableHeaderPopupMenuCustomizer> \u0102;

    public TableHeaderPopupMenuInstaller(JTable jTable) {
        this.\u0101 = jTable;
        this.installListeners();
    }

    public void addTableHeaderPopupMenuCustomizer(TableHeaderPopupMenuCustomizer tableHeaderPopupMenuCustomizer) {
        if (this.\u0102 == null) {
            this.\u0102 = new ArrayList<TableHeaderPopupMenuCustomizer>();
        }
        this.\u0102.add(tableHeaderPopupMenuCustomizer);
    }

    public void removeTableHeaderPopupMenuCustomizer(TableHeaderPopupMenuCustomizer tableHeaderPopupMenuCustomizer) {
        if (this.\u0102 != null) {
            this.\u0102.remove(tableHeaderPopupMenuCustomizer);
        }
    }

    public TableHeaderPopupMenuCustomizer[] getTableHeaderPopupMenuCustomizers() {
        return this.\u0102 != null ? this.\u0102.toArray(new TableHeaderPopupMenuCustomizer[this.\u0102.size()]) : new TableHeaderPopupMenuCustomizer[]{};
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.\u0101(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.\u0101(mouseEvent);
    }

    private void \u0101(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        JTableHeader jTableHeader = (JTableHeader)mouseEvent.getComponent();
        jTableHeader.setDraggedColumn(null);
        if (jTableHeader instanceof NestedTableHeader && !((NestedTableHeader)jTableHeader).isMouseOnOriginalTableHeader(mouseEvent.getPoint())) {
            return;
        }
        JPopupMenu jPopupMenu = this.createPopupMenu();
        int n2 = TableHeaderPopupMenuInstaller.\u0101(jTableHeader, mouseEvent.getPoint());
        this.customizeMenuItems(jTableHeader, jPopupMenu, n2);
        if (jPopupMenu.getComponentCount() > 0) {
            JideSwingUtilities.showPopupMenu(jPopupMenu, jTableHeader, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    protected JPopupMenu createPopupMenu() {
        return new JidePopupMenu();
    }

    protected void customizeMenuItems(JTableHeader jTableHeader, JPopupMenu jPopupMenu, int n2) {
        TableHeaderPopupMenuCustomizer[] tableHeaderPopupMenuCustomizerArray;
        for (TableHeaderPopupMenuCustomizer tableHeaderPopupMenuCustomizer : tableHeaderPopupMenuCustomizerArray = this.getTableHeaderPopupMenuCustomizers()) {
            TableHeaderPopupMenuInstaller.addSeparatorIfNecessary(jPopupMenu);
            tableHeaderPopupMenuCustomizer.customizePopupMenu(jTableHeader, jPopupMenu, n2);
        }
    }

    public static void addSeparatorIfNecessary(JPopupMenu jPopupMenu) {
        int n2 = jPopupMenu.getComponentCount();
        if (n2 > 0 && !(jPopupMenu.getComponent(n2 - 1) instanceof JSeparator)) {
            jPopupMenu.addSeparator();
        }
    }

    public void installListeners() {
        JTableHeader jTableHeader = this.\u0101.getTableHeader();
        if (jTableHeader != null) {
            jTableHeader.addMouseListener(this);
        }
        this.\u0101.addPropertyChangeListener("tableHeader", this);
        this.\u0101(this.\u0101, this);
    }

    public void uninstallListeners() {
        JTableHeader jTableHeader = this.\u0101.getTableHeader();
        if (jTableHeader != null) {
            jTableHeader.removeMouseListener(this);
        }
        this.\u0101.removePropertyChangeListener("tableHeader", this);
        this.\u0101(this.\u0101, null);
    }

    public static TableHeaderPopupMenuInstaller getTableHeaderPopupMenuInstaller(JTable jTable) {
        Object object = jTable.getClientProperty(CLIENT_PROPERTY_POPUP_MENU_INSTALLER);
        if (object instanceof TableHeaderPopupMenuInstaller) {
            return (TableHeaderPopupMenuInstaller)object;
        }
        return null;
    }

    private void \u0101(JTable jTable, TableHeaderPopupMenuInstaller tableHeaderPopupMenuInstaller) {
        if (jTable != null) {
            Object object = jTable.getClientProperty(CLIENT_PROPERTY_POPUP_MENU_INSTALLER);
            if (object instanceof TableHeaderPopupMenuInstaller && object != this) {
                ((TableHeaderPopupMenuInstaller)object).uninstallListeners();
            }
            jTable.putClientProperty(CLIENT_PROPERTY_POPUP_MENU_INSTALLER, tableHeaderPopupMenuInstaller);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("tableHeader".equals(propertyChangeEvent.getPropertyName())) {
            JTableHeader jTableHeader;
            if (propertyChangeEvent.getOldValue() instanceof JTableHeader) {
                jTableHeader = (JTableHeader)propertyChangeEvent.getOldValue();
                jTableHeader.removeMouseListener(this);
            }
            if (propertyChangeEvent.getNewValue() instanceof JTableHeader) {
                jTableHeader = (JTableHeader)propertyChangeEvent.getNewValue();
                jTableHeader.addMouseListener(this);
            }
        }
    }

    private static int \u0101(JTableHeader jTableHeader, Point point) {
        GroupModelProvider groupModelProvider;
        for (int i2 = 0; i2 < jTableHeader.getColumnModel().getColumnCount(); ++i2) {
            Rectangle rectangle = jTableHeader.getHeaderRect(i2);
            if (!rectangle.contains(point)) continue;
            return i2;
        }
        if (jTableHeader instanceof GroupTableHeader && (groupModelProvider = ((GroupTableHeader)jTableHeader).\u037a()) != null) {
            int n2 = groupModelProvider.getGroupColumnCount();
            for (int i3 = 0; i3 < n2; ++i3) {
                Rectangle rectangle = ((GroupTableHeader)jTableHeader).getGroupedHeaderRect(i3);
                if (!rectangle.contains(point)) continue;
                return -2 - i3;
            }
        }
        return -1;
    }
}

