/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gauge;

import com.jidesoft.chart.Drawable;
import com.jidesoft.chart.Orientation;
import com.jidesoft.gauge.Bullet;
import com.jidesoft.gauge.BulletAxis;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class BulletPointMarker
implements Drawable {
    private Bullet \u01a7;
    private double \u01a9;
    private Paint \u01aa = Color.GRAY;
    private double \u01a8 = 0.75;
    private double \u01a6 = 0.1;

    public BulletPointMarker(Bullet bullet, double d2) {
        this(bullet, Color.GRAY, d2);
    }

    public BulletPointMarker(Bullet bullet, Paint paint, double d2) {
        this.\u01a7 = bullet;
        this.setFill(paint);
        this.\u01a9 = d2;
    }

    public double getBreadthProportion() {
        return this.\u01a8;
    }

    public void setBreadthProportion(double d2) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("The breadth proportion should be a value in the range [0,1]");
        }
        this.\u01a8 = d2;
    }

    public Paint getFill() {
        return this.\u01aa;
    }

    public void setFill(Paint paint) {
        this.\u01aa = paint;
    }

    @Override
    public void draw(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        BulletAxis bulletAxis = this.\u01a7.getAxis();
        Point2D point2D = this.\u01a7.calculatePixelPoint2D(bulletAxis, this.\u01a9);
        if (point2D != null) {
            double d2 = this.\u01a8 * this.\u01a7.getBulletBreadth();
            double d3 = d2 * this.\u01a6;
            Orientation orientation = this.\u01a7.getOrientation();
            double d4 = orientation == Orientation.horizontal ? point2D.getX() - d3 / 2.0 : point2D.getX() - d2 / 2.0;
            double d5 = orientation == Orientation.horizontal ? point2D.getY() - d2 / 2.0 : point2D.getY() - d3 / 2.0;
            double d6 = orientation == Orientation.horizontal ? d3 : d2;
            double d7 = orientation == Orientation.horizontal ? d2 : d3;
            Rectangle2D.Double double_ = new Rectangle2D.Double(d4, d5, d6, d7);
            graphics2D.setPaint(this.\u01aa);
            graphics2D.fill(double_);
        }
        graphics2D.dispose();
    }
}

