/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gauge;

import com.jidesoft.chart.ZOrder;
import com.jidesoft.chart.render.NumberLabeler;
import com.jidesoft.chart.util.ChartUtils;
import com.jidesoft.gauge.AbstractGauge;
import com.jidesoft.gauge.IndicatorRenderer;
import com.jidesoft.gauge.IndicatorStyle;
import com.jidesoft.swing.ShadowFactory;
import com.jidesoft.swing.ShadowRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;

public abstract class AbstractIndicatorRenderer<GaugeType extends AbstractGauge<?>>
implements IndicatorRenderer<GaugeType>,
ZOrder {
    private NumberLabeler<Double> \u0118 = null;
    private String \u0117 = null;
    protected Font labelFont = null;
    protected Color labelColor = Color.BLACK;
    protected boolean labelVisible = true;
    private ShadowRenderer \u011a;
    private BufferedImage \u0116 = null;
    private int \u0119 = 100;

    protected AbstractIndicatorRenderer() {
        ShadowFactory shadowFactory = new ShadowFactory();
        shadowFactory.setRenderingHint("blur_quality", "fast");
        this.setShadowRenderer(shadowFactory);
    }

    public ShadowRenderer getShadowRenderer() {
        return this.\u011a;
    }

    public void setShadowRenderer(ShadowRenderer shadowRenderer) {
        if (shadowRenderer == null) {
            throw new NullPointerException("Cannot set shadow renderer to be null");
        }
        this.\u011a = shadowRenderer;
    }

    public NumberLabeler<Double> getLabeler() {
        return this.\u0118;
    }

    public void setLabeler(NumberLabeler<Double> numberLabeler) {
        this.\u0118 = numberLabeler;
    }

    public String getLabelText() {
        return this.\u0117;
    }

    public void setLabelText(String string) {
        this.\u0117 = string;
    }

    protected String generateLabel(Double d2) {
        String string = null;
        if (this.getLabeler() != null) {
            string = this.getLabeler().getDisplayText(d2);
        } else if (this.getLabelText() != null) {
            string = this.getLabelText();
        }
        return string;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        this.labelFont = font;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color color) {
        this.labelColor = color;
    }

    public boolean isLabelVisible() {
        return this.labelVisible;
    }

    public void setLabelVisible(boolean bl) {
        this.labelVisible = bl;
    }

    @Override
    public int getZOrder() {
        return this.\u0119;
    }

    @Override
    public void setZOrder(int n2) {
        this.\u0119 = n2;
    }

    @Override
    public Shape paintIndicator(Graphics2D graphics2D, GaugeType GaugeType, Double d2, IndicatorStyle indicatorStyle) {
        Dimension dimension = ((Component)GaugeType).getSize();
        if (dimension == null || dimension.width == 0 || dimension.height == 0 || d2 == null) {
            return null;
        }
        Shape shape = this.calculateShape(GaugeType, d2);
        if (shape == null) {
            return null;
        }
        Rectangle rectangle = shape.getBounds();
        if (((AbstractGauge)GaugeType).isShadowVisible()) {
            BufferedImage bufferedImage;
            if (this.\u0116 != null && this.\u0116.getWidth() > rectangle.width && this.\u0116.getHeight() > rectangle.height) {
                bufferedImage = this.\u0116.getSubimage(0, 0, rectangle.width + 1, rectangle.height + 1);
                ChartUtils.clearBufferedImage(bufferedImage, Color.black);
            } else {
                bufferedImage = this.\u0116 = new BufferedImage(rectangle.width + 1, rectangle.height + 1, 2);
            }
            Graphics2D graphics2D2 = bufferedImage.createGraphics();
            graphics2D2.translate(-rectangle.getX(), -rectangle.getY());
            graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.drawIndicator(graphics2D2, GaugeType, shape, indicatorStyle);
            BufferedImage bufferedImage2 = this.getShadowRenderer().createShadow(bufferedImage);
            graphics2D.translate(rectangle.getX(), rectangle.getY());
            graphics2D.drawImage((Image)bufferedImage2, 0, 0, (ImageObserver)GaugeType);
            graphics2D.drawImage((Image)bufferedImage, 0, 0, (ImageObserver)GaugeType);
            graphics2D.translate(-rectangle.getX(), -rectangle.getY());
            graphics2D2.dispose();
        } else {
            this.drawIndicator(graphics2D, GaugeType, shape, indicatorStyle);
        }
        return shape;
    }

    public abstract void paintLabel(Graphics2D var1, GaugeType var2, Double var3, IndicatorStyle var4);

    protected abstract void drawIndicator(Graphics2D var1, GaugeType var2, Shape var3, IndicatorStyle var4);

    protected abstract Shape calculateShape(GaugeType var1, Double var2);
}

