/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gantt;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public abstract class PaintedTexture {
    private final int \u0101;
    private final int \u0102;

    public PaintedTexture(int n2, int n3) {
        this.\u0101 = n2;
        this.\u0102 = n3;
    }

    public int getWidth() {
        return this.\u0101;
    }

    public int getHeight() {
        return this.\u0102;
    }

    protected abstract void drawTexture(Graphics2D var1);

    public TexturePaint createTexturePaint() {
        BufferedImage bufferedImage = new BufferedImage(this.\u0101, this.\u0102, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            this.drawTexture(graphics2D);
        }
        finally {
            graphics2D.dispose();
        }
        return new TexturePaint(bufferedImage, new Rectangle2D.Double(0.0, 0.0, this.\u0101, this.\u0102));
    }

    public static TexturePaint createDiagonalLines(int n2, int n3, final Paint paint, final boolean bl, final boolean bl2) {
        return new PaintedTexture(n2, n3){

            @Override
            protected void drawTexture(Graphics2D graphics2D) {
                graphics2D.setPaint(paint);
                if (bl) {
                    graphics2D.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, 0);
                }
                if (bl2) {
                    graphics2D.drawLine(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                }
            }
        }.createTexturePaint();
    }

    public static TexturePaint createLines(int n2, int n3, final Paint paint, final boolean bl, final boolean bl2) {
        return new PaintedTexture(n2, n3){

            @Override
            protected void drawTexture(Graphics2D graphics2D) {
                graphics2D.setPaint(paint);
                if (bl) {
                    graphics2D.drawLine(0, this.getHeight() / 2, this.getWidth() - 1, this.getHeight() / 2);
                }
                if (bl2) {
                    graphics2D.drawLine(this.getWidth() / 2, 0, this.getWidth() / 2, this.getHeight() - 1);
                }
            }
        }.createTexturePaint();
    }
}

