/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gantt;

import com.jidesoft.gantt.A;
import com.jidesoft.gantt.AbstractGanttModel;
import com.jidesoft.gantt.DefaultGanttEntryRelationModel;
import com.jidesoft.gantt.DefaultGanttTreeTableModel;
import com.jidesoft.gantt.GanttEntry;
import com.jidesoft.gantt.GanttEntryRelationModel;
import com.jidesoft.gantt.GanttModelEvent;
import com.jidesoft.gantt.SubEntryGanttEntry;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.FilterableTreeTableModel;
import com.jidesoft.grid.ITreeTableModel;
import com.jidesoft.grid.SortableTreeTableModel;
import com.jidesoft.range.Range;
import com.jidesoft.scale.ScaleModel;
import com.jidesoft.swing.JideSwingUtilities;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class DefaultGanttModel<T, S extends GanttEntry<T>>
extends AbstractGanttModel<T, S>
implements PropertyChangeListener {
    private static final long \u0108 = 5386888127084217005L;
    private ITreeTableModel<S> \u0106;
    private Range<T> \u0107;
    private ScaleModel<T> \u0105;
    private GanttEntryRelationModel<S> \u0104;
    private TableModelListener \u0103;
    private boolean \u0102 = true;

    public DefaultGanttModel() {
        this(new SortableTreeTableModel(new FilterableTreeTableModel(new DefaultGanttTreeTableModel())));
    }

    public DefaultGanttModel(ITreeTableModel<S> iTreeTableModel) {
        this.setTreeTableModel(iTreeTableModel);
        this.setGanttEntryRelationModel(this.createGanttEntryRelationModel());
    }

    protected DefaultGanttEntryRelationModel<S> createGanttEntryRelationModel() {
        return new DefaultGanttEntryRelationModel();
    }

    @Override
    public ITreeTableModel<S> getTreeTableModel() {
        return this.\u0106;
    }

    public void setTreeTableModel(ITreeTableModel<S> iTreeTableModel) {
        if (this.\u0103 == null) {
            this.\u0103 = new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    int n2 = -1;
                    if (tableModelEvent instanceof A) {
                        n2 = ((A)tableModelEvent).\u0101();
                    }
                    DefaultGanttModel.this.fireGanttChanged(new GanttModelEvent(DefaultGanttModel.this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), n2, tableModelEvent.getType()));
                    DefaultGanttModel.this.updateRange(tableModelEvent);
                }
            };
        }
        if (this.\u0106 != null) {
            ((TableModel)((Object)this.\u0106)).removeTableModelListener(this.\u0103);
        }
        this.\u0106 = iTreeTableModel;
        if (this.\u0106 != null) {
            ((TableModel)((Object)this.\u0106)).addTableModelListener(this.\u0103);
        }
        this.fireGanttDataChanged();
    }

    protected boolean isRangeColumn(int n2) {
        return n2 == -1 || n2 == 1 || n2 == 2;
    }

    protected void updateRange(TableModelEvent tableModelEvent) {
        if (this.\u0107 == null || !this.isAutoUpdateRange() || this.getEntryCount() == 0) {
            return;
        }
        if (tableModelEvent != null && tableModelEvent.getType() == 0 && !this.isRangeColumn(tableModelEvent.getColumn())) {
            return;
        }
        List<S> list = tableModelEvent != null && (tableModelEvent.getType() == 0 || tableModelEvent.getType() == 1) ? this.\u0101(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow()) : this.\u0101(0, this.getEntryCount() - 1);
        if (list.size() == 1) {
            DefaultGanttModel.union(this.\u0107, (Expandable)this.getTreeTableModel().getRoot(), (GanttEntry)list.get(0));
        } else if (!list.isEmpty()) {
            DefaultGanttModel.union(this.\u0107, (Expandable)this.getTreeTableModel().getRoot());
        }
    }

    private List<S> \u0101(int n2, int n3) {
        if (n2 < 0 || n2 >= this.getEntryCount() || n3 < 0 || n3 >= this.getEntryCount()) {
            n2 = 0;
            n3 = this.getEntryCount() - 1;
        }
        Object object = this.getTreeTableModel().getRoot();
        ArrayList arrayList = new ArrayList();
        for (int i2 = n2; i2 <= n3; ++i2) {
            Object s2 = this.getEntryAt(i2);
            if (s2.getParent() != object) continue;
            arrayList.add(s2);
        }
        return arrayList;
    }

    public void setAutoUpdateRange(boolean bl) {
        this.\u0102 = bl;
    }

    public boolean isAutoUpdateRange() {
        return this.\u0102;
    }

    @Override
    public Range<T> getRange() {
        return this.\u0107;
    }

    public void setRange(Range<T> range) {
        if (!JideSwingUtilities.equals(range, this.\u0107)) {
            this.\u0107 = range;
            this.fireGanttChanged(new GanttModelEvent(this, -2, -2, 0));
            if (this.\u0107 != null) {
                PropertyChangeListener[] propertyChangeListenerArray;
                for (PropertyChangeListener propertyChangeListener : propertyChangeListenerArray = this.\u0107.getPropertyChangeListeners()) {
                    if (propertyChangeListener != this) continue;
                    return;
                }
                this.\u0107.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        DefaultGanttModel.this.fireGanttChanged(new GanttModelEvent(DefaultGanttModel.this, -2, -2, 0));
                    }
                });
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.fireGanttChanged(new GanttModelEvent(this, -2, -2, 0));
    }

    @Override
    public ScaleModel<T> getScaleModel() {
        return this.\u0105;
    }

    public void setScaleModel(ScaleModel<T> scaleModel) {
        this.\u0105 = scaleModel;
    }

    @Override
    public GanttEntryRelationModel<S> getGanttEntryRelationModel() {
        return this.\u0104;
    }

    public void setGanttEntryRelationModel(GanttEntryRelationModel<S> ganttEntryRelationModel) {
        this.\u0104 = ganttEntryRelationModel;
    }

    public void addGanttEntry(S s2) {
        ((Expandable)this.getTreeTableModel().getRoot()).addChild(s2);
    }

    public void removeGanttEntry(S s2) {
        if (s2 != null && s2.getParent() != null) {
            s2.getParent().removeChild(s2);
        }
    }

    public static <T> void union(Range<T> range, Expandable expandable, GanttEntry<T> ganttEntry) {
        if (range == null) {
            return;
        }
        if (ganttEntry == null) {
            DefaultGanttModel.union(range, expandable);
            return;
        }
        Range<T> range2 = ganttEntry.getRange();
        if (range2 != null) {
            double d2;
            T t2 = range.lower();
            T t3 = range.upper();
            T t4 = range2.lower();
            T t5 = range2.upper();
            if (t2 == null && t3 == null) {
                DefaultGanttModel.union(range, expandable);
                return;
            }
            if (t2 == null) {
                t2 = t4;
            } else if (t4 != null) {
                d2 = range2.minimum();
                if (d2 < range.minimum()) {
                    t2 = t4;
                } else {
                    DefaultGanttModel.union(range, expandable);
                    return;
                }
            }
            if (t3 == null) {
                t3 = t5;
            } else if (t5 != null) {
                d2 = range2.maximum();
                if (d2 > range.maximum()) {
                    t3 = t5;
                } else {
                    DefaultGanttModel.union(range, expandable);
                    return;
                }
            }
            if (t2 != null && t3 != null) {
                range.adjust(t2, t3);
            }
        }
    }

    public static <T> void union(Range<T> range, Expandable expandable) {
        if (range != null) {
            Range<Object> range2;
            Object object2;
            Object object3 = null;
            Object object4 = null;
            double d2 = 0.0;
            double d3 = 0.0;
            ArrayList<GanttEntry> arrayList = new ArrayList<GanttEntry>();
            List<?> list = expandable.getChildren();
            if (list != null) {
                object2 = list.iterator();
                while (object2.hasNext()) {
                    Object object5 = object2.next();
                    arrayList.add((GanttEntry)object5);
                }
            }
            if (expandable instanceof SubEntryGanttEntry && (object2 = ((SubEntryGanttEntry)expandable).getSubEntries()) != null) {
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    range2 = iterator.next();
                    arrayList.add((GanttEntry)((Object)range2));
                }
            }
            for (GanttEntry ganttEntry : arrayList) {
                Object object;
                range2 = ganttEntry.getRange();
                if (range2 == null) continue;
                Object object5 = range2.lower();
                if (object5 != null && (object3 == null || range2.minimum() < d2)) {
                    object3 = range2.lower();
                    d2 = range2.minimum();
                }
                if ((object = range2.upper()) == null || object4 != null && !(range2.maximum() > d3)) continue;
                object4 = range2.upper();
                d3 = range2.maximum();
            }
            if (object3 != null && object4 != null) {
                range.adjust(object3, object4);
            }
        }
    }
}

