/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.selection;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.caret.CaretPosition;
import com.jidesoft.editor.selection.SelectionEvent;
import com.jidesoft.editor.selection.SelectionListener;
import com.jidesoft.editor.selection.SelectionModel;
import javax.swing.event.EventListenerList;
import javax.swing.text.Element;

public class DefaultSelectionModel
implements SelectionModel {
    private EventListenerList \u0103 = null;
    private int \u0105;
    private int \u0109;
    private int \u0107 = -1;
    private int \u0106 = -1;
    private CaretPosition \u0102;
    private CaretPosition \u0108;
    private boolean \u0104 = false;
    private CodeEditor \u0101;

    public DefaultSelectionModel(CodeEditor codeEditor) {
        this.\u0101 = codeEditor;
    }

    @Override
    public synchronized int getSelectionStart() {
        if (this.hasSelection()) {
            return this.\u0105;
        }
        return this.\u0101.getCaretModel().getOffset();
    }

    @Override
    public synchronized int getSelectionEnd() {
        if (this.hasSelection()) {
            return this.\u0109;
        }
        return this.\u0101.getCaretModel().getOffset();
    }

    public synchronized void setSelectionStart(int n2) {
        int n3 = this.\u0105;
        if (n3 != n2) {
            this.\u0105 = n2;
            this.\u0107 = -1;
            this.fireSelectionChangeEvent(n3, this.\u0109, this.\u0105, this.\u0109);
        }
    }

    public synchronized void setSelectionEnd(int n2) {
        int n3 = this.\u0109;
        if (n3 != n2) {
            this.\u0109 = n2;
            this.\u0106 = -1;
            this.fireSelectionChangeEvent(this.\u0105, n3, this.\u0105, this.\u0109);
        }
    }

    @Override
    public synchronized int getSelectionStartLine() {
        if (this.hasSelection()) {
            if (this.\u0107 < 0) {
                this.\u0107 = this.\u0101.getLineNumber(this.\u0105);
            }
            return this.\u0107;
        }
        return this.\u0101.getCaretModel().getModelPosition().line;
    }

    @Override
    public synchronized int getSelectionEndLine() {
        if (this.hasSelection()) {
            if (this.\u0106 < 0) {
                this.\u0106 = this.\u0101.getLineNumber(this.\u0109);
            }
            return this.\u0106;
        }
        return this.\u0101.getCaretModel().getModelPosition().line;
    }

    @Override
    public CaretPosition getSelectionStartViewPosition() {
        return this.\u0102;
    }

    @Override
    public CaretPosition getSelectionEndViewPosition() {
        return this.\u0108;
    }

    @Override
    public int offsetInSelectionToOffsetInDocument(int n2) {
        int n3;
        int n4;
        int n5;
        if (this.\u0105 == this.\u0109) {
            return -1;
        }
        if (!this.isColumnSelectionMode()) {
            return Math.min(this.\u0105, this.\u0109) + n2;
        }
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        if (this.\u0107 < 0) {
            this.\u0107 = this.\u0101.getLineNumber(this.\u0105);
        }
        if (this.\u0106 < 0) {
            this.\u0106 = this.\u0101.getLineNumber(this.\u0109);
        }
        if (this.\u0105 < this.\u0109) {
            n6 = this.\u0105;
            n7 = this.\u0109;
            n8 = this.\u0107;
            n9 = this.\u0106;
        } else if (this.\u0105 > this.\u0109) {
            n6 = this.\u0109;
            n7 = this.\u0105;
            n8 = this.\u0106;
            n9 = this.\u0107;
        }
        Element element = this.\u0101.getDocument().getDefaultRootElement();
        if (this.\u0102 == null || this.\u0108 == null) {
            n5 = n6 - this.\u0101.getLineStartOffset(n8);
            n4 = n7 - this.\u0101.getLineStartOffset(n9);
            if (n4 < n5) {
                n3 = n4;
                n4 = n5;
                n5 = n3;
            }
            n4 = Math.max(this.\u0101.getCaretModel().getViewPosition().column, n4);
        } else {
            n4 = this.\u0108.column;
            n5 = this.\u0102.column;
            if (n4 < n5) {
                n3 = n4;
                n4 = n5;
                n5 = n3;
            }
        }
        n3 = 0;
        for (int i2 = n8; i2 <= n9; ++i2) {
            Element element2 = element.getElement(i2);
            int n10 = element2.getStartOffset();
            int n11 = element2.getEndOffset() - 1;
            int n12 = Math.min(n4 - n5, n11 - (n10 = Math.min(n10 + n5, n11)));
            if (n12 == 0) {
                if (n3 <= n2 && n3 + n4 - n5 >= n2) {
                    return -1;
                }
                n3 += n4 - n5 + 1;
                continue;
            }
            if (n3 <= n2 && n3 + n12 >= n2) {
                return n10 + n2 - n3;
            }
            if ((n3 += n12) <= n2 && n3 + n4 - n5 - n12 >= n2) {
                return -1;
            }
            n3 += n4 - n5 - n12;
            ++n3;
        }
        return -1;
    }

    @Override
    public int offsetInDocumentToOffsetInSelection(int n2) {
        int n3;
        int n4;
        int n5;
        if (this.\u0105 == this.\u0109) {
            return -1;
        }
        if (!this.isColumnSelectionMode()) {
            return n2 - Math.min(this.\u0105, this.\u0109);
        }
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        if (this.\u0107 < 0) {
            this.\u0107 = this.\u0101.getLineNumber(this.\u0105);
        }
        if (this.\u0106 < 0) {
            this.\u0106 = this.\u0101.getLineNumber(this.\u0109);
        }
        if (this.\u0105 < this.\u0109) {
            n6 = this.\u0105;
            n7 = this.\u0109;
            n8 = this.\u0107;
            n9 = this.\u0106;
        } else if (this.\u0105 > this.\u0109) {
            n6 = this.\u0109;
            n7 = this.\u0105;
            n8 = this.\u0106;
            n9 = this.\u0107;
        }
        Element element = this.\u0101.getDocument().getDefaultRootElement();
        if (this.\u0102 == null || this.\u0108 == null) {
            n5 = n6 - this.\u0101.getLineStartOffset(n8);
            n4 = n7 - this.\u0101.getLineStartOffset(n9);
            if (n4 < n5) {
                n3 = n4;
                n4 = n5;
                n5 = n3;
            }
            n4 = Math.max(this.\u0101.getCaretModel().getViewPosition().column, n4);
        } else {
            n4 = this.\u0108.column;
            n5 = this.\u0102.column;
            if (n4 < n5) {
                n3 = n4;
                n4 = n5;
                n5 = n3;
            }
        }
        n3 = 0;
        for (int i2 = n8; i2 <= n9; ++i2) {
            Element element2 = element.getElement(i2);
            int n10 = element2.getStartOffset();
            int n11 = element2.getEndOffset() - 1;
            n10 = Math.min(n10 + n5, n11);
            int n12 = Math.min(n4 - n5, n11 - n10);
            if (n10 <= n2 && n10 + n12 >= n2) {
                return n3 + n2 - n10;
            }
            n3 += n4 - n5 + 1;
        }
        return -1;
    }

    @Override
    public synchronized String getSelectedText() {
        if (this.\u0105 == this.\u0109) {
            return null;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.\u0107 < 0) {
            this.\u0107 = this.\u0101.getLineNumber(this.\u0105);
        }
        if (this.\u0106 < 0) {
            this.\u0106 = this.\u0101.getLineNumber(this.\u0109);
        }
        if (this.\u0105 < this.\u0109) {
            n2 = this.\u0105;
            n3 = this.\u0109;
            n4 = this.\u0107;
            n5 = this.\u0106;
        } else if (this.\u0105 > this.\u0109) {
            n2 = this.\u0109;
            n3 = this.\u0105;
            n4 = this.\u0106;
            n5 = this.\u0107;
        }
        if (this.isColumnSelectionMode()) {
            int n6;
            int n7;
            int n8;
            Element element = this.\u0101.getDocument().getDefaultRootElement();
            if (this.\u0102 == null || this.\u0108 == null) {
                n8 = n2 - this.\u0101.getLineStartOffset(n4);
                n7 = n3 - this.\u0101.getLineStartOffset(n5);
                if (n7 < n8) {
                    n6 = n7;
                    n7 = n8;
                    n8 = n6;
                }
                n7 = Math.max(this.\u0101.getCaretModel().getViewPosition().column, n7);
            } else {
                n7 = this.\u0108.column;
                n8 = this.\u0102.column;
                if (n7 < n8) {
                    n6 = n7;
                    n7 = n8;
                    n8 = n6;
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = n4; i2 <= n5; ++i2) {
                int n9;
                Element element2 = element.getElement(i2);
                int n10 = element2.getStartOffset();
                int n11 = element2.getEndOffset() - 1;
                int n12 = Math.min(n7 - n8, n11 - (n10 = Math.min(n10 + n8, n11)));
                if (n12 == 0) {
                    for (n9 = 0; n9 < n7 - n8; ++n9) {
                        stringBuffer.append(' ');
                    }
                } else {
                    this.\u0101.getText(n10, n12, this.\u0101.lineSegment);
                    stringBuffer.append(this.\u0101.lineSegment.array, this.\u0101.lineSegment.offset, this.\u0101.lineSegment.count);
                    n9 = stringBuffer.charAt(stringBuffer.length() - 1);
                    if (n9 == 10 || n9 == 13) {
                        stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
                    }
                    for (int i3 = --n12; i3 < n7 - n8; ++i3) {
                        stringBuffer.append(' ');
                    }
                }
                if (i2 == n5) continue;
                stringBuffer.append('\n');
            }
            return stringBuffer.toString();
        }
        return this.\u0101.getText(n2, Math.min(this.\u0101.getDocumentLength(), n3) - n2);
    }

    @Override
    public synchronized void setSelection(int n2, int n3) {
        int n4 = this.\u0105;
        int n5 = this.\u0109;
        this.\u0105 = n2;
        this.\u0107 = -1;
        this.\u0109 = n3;
        this.\u0106 = -1;
        if (n2 == n3 || !this.isColumnSelectionMode()) {
            this.\u0102 = null;
            this.\u0108 = null;
        } else {
            this.\u0102 = this.\u0101.offsetToViewPosition(this.\u0105);
            this.\u0108 = this.\u0101.offsetToViewPosition(this.\u0109);
        }
        this.fireSelectionChangeEvent(n4, n5, this.\u0105, this.\u0109);
    }

    @Override
    public synchronized void setSelection(CaretPosition caretPosition, CaretPosition caretPosition2) {
        int n2 = this.\u0105;
        int n3 = this.\u0109;
        this.\u0102 = caretPosition;
        this.\u0108 = caretPosition2;
        this.\u0105 = this.\u0101.modelPositionToOffset(this.\u0101.viewToModelPosition(caretPosition));
        this.\u0107 = -1;
        this.\u0109 = this.\u0101.modelPositionToOffset(this.\u0101.viewToModelPosition(caretPosition2));
        this.\u0106 = -1;
        this.fireSelectionChangeEvent(n2, n3, this.\u0105, this.\u0109);
    }

    @Override
    public synchronized void clearSelection() {
        this.setSelection(0, 0);
    }

    @Override
    public synchronized boolean hasSelection() {
        return this.\u0105 != this.\u0109;
    }

    @Override
    public synchronized boolean isColumnSelectionMode() {
        return this.\u0104;
    }

    @Override
    public synchronized void setColumnSelectionMode(boolean bl) {
        if (this.\u0104 != bl) {
            boolean bl2 = this.\u0104;
            this.\u0104 = bl;
            this.\u0101.firePropertyChange("columnSelectionEnabled", bl2, this.\u0104);
        }
    }

    @Override
    public synchronized void addSelectionListener(SelectionListener selectionListener) {
        if (this.\u0103 == null) {
            this.\u0103 = new EventListenerList();
        }
        this.\u0103.add(SelectionListener.class, selectionListener);
    }

    @Override
    public synchronized void removeSelectionListener(SelectionListener selectionListener) {
        this.\u0103.remove(SelectionListener.class, selectionListener);
    }

    @Override
    public synchronized SelectionListener[] getSelectionListeners() {
        return (SelectionListener[])this.\u0103.getListeners(SelectionListener.class);
    }

    protected void fireSelectionChangeEvent(int n2, int n3, int n4, int n5) {
        if (this.\u0103 == null) {
            return;
        }
        Object[] objectArray = this.\u0103.getListenerList();
        SelectionEvent selectionEvent = new SelectionEvent(this.\u0101, n2, n3, n4, n5);
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != SelectionListener.class) continue;
            ((SelectionListener)objectArray[i2 + 1]).selectionChanged(selectionEvent);
        }
    }
}

