/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.language;

import com.jidesoft.editor.language.LanguageSpec;
import com.jidesoft.editor.tokenmarker.CCTokenMarker;
import com.jidesoft.editor.tokenmarker.CTokenMarker;
import com.jidesoft.editor.tokenmarker.HTMLTokenMarker;
import com.jidesoft.editor.tokenmarker.JavaScriptTokenMarker;
import com.jidesoft.editor.tokenmarker.JavaTokenMarker;
import com.jidesoft.editor.tokenmarker.PHPTokenMarker;
import com.jidesoft.editor.tokenmarker.PLSQLTokenMarker;
import com.jidesoft.editor.tokenmarker.PerlTokenMarker;
import com.jidesoft.editor.tokenmarker.PythonTokenMarker;
import com.jidesoft.editor.tokenmarker.TSQLTokenMarker;
import com.jidesoft.editor.tokenmarker.VHDLTokenMarker;
import com.jidesoft.editor.tokenmarker.VerilogTokenMarker;
import com.jidesoft.editor.tokenmarker.XMLTokenMarker;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class LanguageSpecManager {
    private Map<String, LanguageSpec> \u0102;
    private static LanguageSpecManager \u0101;

    public static LanguageSpecManager getInstance() {
        if (\u0101 == null) {
            \u0101 = new LanguageSpecManager();
        }
        return \u0101;
    }

    protected LanguageSpecManager() {
        this.initDefaultLanguageSpecs();
    }

    protected void initDefaultLanguageSpecs() {
        this.\u0102 = new TreeMap<String, LanguageSpec>();
        this.registerLanguageSpec(new LanguageSpec("Java", "java", new JavaTokenMarker(), "_", "//", "/*", "*/"));
        this.registerLanguageSpec(new LanguageSpec("JSP", "jsp", new JavaScriptTokenMarker(), "_", "//", "/*", "*/"));
        this.registerLanguageSpec(new LanguageSpec("PHP", "php", new PHPTokenMarker(), "_", "//", "/*", "*/"));
        this.registerLanguageSpec(new LanguageSpec("Verilog", "v;verilog", new VerilogTokenMarker(), "_", "//", "/*", "*/"));
        this.registerLanguageSpec(new LanguageSpec("VHDL", "vhdl", new VHDLTokenMarker(), "_", "--"));
        this.registerLanguageSpec(new LanguageSpec("PLSQL", "plsql", new PLSQLTokenMarker(), "_", "--", "/*", "*/"));
        this.registerLanguageSpec(new LanguageSpec("TSQL", "tsql", new TSQLTokenMarker(), "_", "--", "/*", "*/"));
        this.registerLanguageSpec(new LanguageSpec("Perl", "pl;pm;cgi", new PerlTokenMarker(), "_", "#", "/*", "*/"));
        this.registerLanguageSpec(new LanguageSpec("C", "c", new CTokenMarker(), "_", "//", "/*", "*/"));
        this.registerLanguageSpec(new LanguageSpec("C++", "cpp;cxx", new CCTokenMarker(), "_", "//", "/*", "*/"));
        this.registerLanguageSpec(new LanguageSpec("HTML", "html;htm;shtml;stm;asp;asa;aspx", new HTMLTokenMarker(), "_", null, "<!--", "-->"));
        this.registerLanguageSpec(new LanguageSpec("XML", "xml", new XMLTokenMarker(), "_", null, "<!--", "-->"));
        this.registerLanguageSpec(new LanguageSpec("Python", "py", new PythonTokenMarker(), "_", "#"));
    }

    public LanguageSpec getLanguageSpec(String string) {
        if (string != null) {
            return this.\u0102.get(string);
        }
        return null;
    }

    public LanguageSpec[] getLanguageSpecs() {
        LanguageSpec[] languageSpecArray = new LanguageSpec[this.\u0102.size()];
        int n2 = 0;
        Set<String> set = this.\u0102.keySet();
        for (String string : set) {
            languageSpecArray[n2] = this.\u0102.get(string);
            ++n2;
        }
        return languageSpecArray;
    }

    public void registerLanguageSpec(LanguageSpec languageSpec) {
        this.\u0102.put(languageSpec.getName(), languageSpec);
    }

    public void unregisterLanguageSpec(String string) {
        this.\u0102.remove(string);
    }
}

