/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.highlight.DefaultHighlighter;
import com.jidesoft.editor.highlight.Highlighter;
import com.jidesoft.editor.selection.SelectionListener;
import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.SearchableBar;
import com.jidesoft.swing.WholeWordsSupport;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class CodeEditorSearchable
extends Searchable
implements DocumentListener,
PropertyChangeListener,
WholeWordsSupport {
    private static final Color \u0140 = new Color(204, 204, 255);
    private Color \u0143 = null;
    private Highlighter.HighlightPainter \u013f;
    private CodeEditor \u0144;
    private boolean \u0142;
    private boolean \u0141 = false;

    public CodeEditorSearchable(CodeEditor codeEditor) {
        super(codeEditor);
        this.\u0144 = codeEditor;
        codeEditor.getDocument().addDocumentListener(this);
        codeEditor.addPropertyChangeListener(this);
        this.setHighlightColor(\u0140);
    }

    public Color getHighlightColor() {
        if (this.\u0143 != null) {
            return this.\u0143;
        }
        return \u0140;
    }

    public void setHighlightColor(Color color) {
        this.\u0143 = color;
        this.\u013f = new A(this.\u0143);
    }

    @Override
    public void firePropertyChangeEvent(String string) {
        super.firePropertyChangeEvent(string);
        this.\u0144.\u0112();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!"firstLine".equals(propertyChangeEvent.getPropertyName()) && !"visibleLines".equals(propertyChangeEvent.getPropertyName())) {
            return;
        }
        if (!this.\u0142) {
            return;
        }
        this.highlightAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void highlightAll() {
        this.\u0142 = true;
        String string = this.getSearchingText();
        int n2 = this.\u0144.viewToModelLine(this.\u0144.getFirstLine());
        int n3 = this.\u0144.getVisibleLines();
        int n4 = this.\u0144.getLineStartOffset(n2);
        int n5 = this.\u0144.getLineStartOffset(n2 + n3);
        int n6 = -1;
        int n7 = n4;
        int n8 = this.getCursor();
        this.setCursor(n7);
        boolean bl = this.isRepeats();
        int n9 = this.\u0144.getCaretModel().getOffset();
        this.setRepeats(false);
        try {
            while (n7 != -1 && n7 >= n4 && n7 < n5) {
                n7 = this.findNext(string);
                if (n7 == -1) continue;
                if (n6 == -1) {
                    n6 = n7;
                }
                this.select(n7, string);
            }
            if (n6 != -1) {
                this.select(n6, string);
            }
        }
        finally {
            this.setRepeats(bl);
            this.\u0144.getCaretModel().setOffset(n9);
        }
        this.setCursor(n8);
    }

    @Override
    protected void cancelHighlightAll() {
        super.cancelHighlightAll();
        this.\u0142 = false;
    }

    @Override
    protected void setSelectedIndex(int n2, boolean bl) {
        String string = this.getSearchingText();
        if (n2 >= 0) {
            if (bl) {
                this.\u0144.setCaretPosition(n2 + string.length());
                try {
                    this.\u0144.getHighlighter().addHighlight(n2, n2 + string.length(), this.\u013f);
                }
                catch (BadLocationException badLocationException) {}
            } else {
                this.\u010a();
                if (this.getSearchableProvider() instanceof SearchableBar && ((SearchableBar)this.getSearchableProvider()).isHighlightAll()) {
                    try {
                        this.\u0144.getHighlighter().addHighlight(n2, n2 + string.length(), this.\u013f);
                    }
                    catch (BadLocationException badLocationException) {}
                } else {
                    this.\u0144.select(n2, n2 + string.length(), true);
                }
            }
        } else {
            this.\u0144.getSelectionModel().clearSelection();
            if (!bl) {
                this.\u010a();
            }
        }
    }

    private void \u010a() {
        Highlighter highlighter = this.\u0144.getHighlighter();
        if (highlighter instanceof DefaultHighlighter) {
            Highlighter.Highlight[] highlightArray = highlighter.getHighlights();
            for (int i2 = highlightArray.length - 1; i2 >= 0; --i2) {
                Highlighter.Highlight highlight = highlightArray[i2];
                if (!(highlight.getPainter() instanceof A)) continue;
                highlighter.removeHighlight(((DefaultHighlighter)highlighter).getHighlightInfo(i2));
            }
        }
    }

    @Override
    protected int getSelectedIndex() {
        return this.\u0144.getSelectionModel().getSelectionStart();
    }

    @Override
    protected Object getElementAt(int n2) {
        String string = this.getSearchingText();
        if (string != null) {
            int n3;
            int n4 = string.length();
            if (n2 + n4 > (n3 = this.getElementCount())) {
                n4 = this.getElementCount() - n2;
            }
            return this.\u0144.getText(n2, n4);
        }
        return "";
    }

    @Override
    protected int getElementCount() {
        return this.\u0144.getDocumentLength();
    }

    @Override
    protected String convertElementToString(Object object) {
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.hidePopup();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.hidePopup();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.hidePopup();
    }

    @Override
    public boolean isActivateKey(KeyEvent keyEvent) {
        return keyEvent.getID() == 401 && keyEvent.getKeyCode() == 114 && (8 & keyEvent.getModifiers()) != 0;
    }

    @Override
    public int findLast(String string) {
        return this.\u0144.getDocument().findPrevious(new String[]{string}, this.\u0144.getDocumentLength(), 0, this.isCaseSensitive(), this.isWholeWords());
    }

    @Override
    public int findFirst(String string) {
        return this.\u0144.getDocument().findNext(new String[]{string}, 0, this.\u0144.getDocumentLength(), this.isCaseSensitive(), this.isWholeWords());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int findFromCursor(String string) {
        int n2;
        int n3;
        if (this.isCountMatch()) {
            SelectionListener[] selectionListenerArray;
            n3 = this.isReverseOrder();
            this.setReverseOrder(false);
            for (SelectionListener selectionListener : selectionListenerArray = this.\u0144.getSelectionModel().getSelectionListeners()) {
                this.\u0144.getSelectionModel().removeSelectionListener(selectionListener);
            }
            try {
                int n4;
                int n5;
                int n6 = n5 = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
                if (n5 < 0) {
                    n5 = 0;
                }
                int n7 = -1;
                this._matchCount = -1;
                do {
                    this.setSelectedIndex(n7, false);
                    n4 = n7;
                    n7 = this.\u0144.getDocument().findNext(new String[]{string}, n4, this.\u0144.getDocumentLength(), this.isCaseSensitive(), this.isWholeWords()) + 1;
                    ++this._matchCount;
                } while (n7 > n4);
                --this._matchCount;
                this.setSelectedIndex(n5, false);
            }
            finally {
                this.setReverseOrder(n3 != 0);
                for (SelectionListener selectionListener : selectionListenerArray) {
                    this.\u0144.getSelectionModel().addSelectionListener(selectionListener);
                }
            }
        }
        int n8 = n3 = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
        if (n3 < 0) {
            n3 = 0;
        }
        if ((n2 = this.\u0144.getDocument().findNext(new String[]{string}, n3, this.\u0144.getDocumentLength(), this.isCaseSensitive(), this.isWholeWords())) < 0 && (n2 = this.\u0144.getDocument().findNext(new String[]{string}, 0, Math.min(n3 + string.length() - 1, this.\u0144.getDocumentLength()), this.isCaseSensitive(), this.isWholeWords())) >= n3) {
            n2 = -1;
        }
        return n2;
    }

    @Override
    public int findNext(String string) {
        int n2;
        int n3;
        int n4 = n3 = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
        if (n3 < 0) {
            n3 = 0;
        }
        if ((n2 = this.\u0144.getDocument().findNext(new String[]{string}, n3 + 1, this.\u0144.getDocumentLength(), this.isCaseSensitive(), this.isWholeWords())) == -1 && this.isRepeats() && (n2 = this.\u0144.getDocument().findNext(new String[]{string}, 0, n3, this.isCaseSensitive(), this.isWholeWords())) >= n3) {
            n2 = -1;
        }
        return n2;
    }

    @Override
    public int findPrevious(String string) {
        int n2;
        int n3;
        int n4 = n3 = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
        if (n3 < 0) {
            n3 = 0;
        }
        if ((n2 = this.\u0144.getDocument().findPrevious(new String[]{string}, n3, 0, this.isCaseSensitive(), this.isWholeWords())) == -1 && this.isRepeats() && (n2 = this.\u0144.getDocument().findPrevious(new String[]{string}, this.getElementCount(), n3, this.isCaseSensitive(), this.isWholeWords())) <= n3) {
            n2 = -1;
        }
        return n2;
    }

    @Override
    public boolean isWholeWords() {
        return this.\u0141;
    }

    @Override
    public void setWholeWords(boolean bl) {
        this.hidePopup();
        this.\u0141 = bl;
    }

    @Override
    protected void searchingTextEmpty() {
        if (!(this.getSearchableProvider() instanceof SearchableBar) || !((SearchableBar)this.getSearchableProvider()).isHighlightAll()) {
            this.\u0144.getCaretModel().moveCaret(-1, 0, false, false, true);
        }
        this.setSelectedIndex(-1, false);
    }

    private class A
    extends DefaultHighlighter.DefaultHighlightPainter {
        public A(Color color) {
            super(color);
        }
    }
}

