/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.database;

import com.jidesoft.database.TableModelCache;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;

public class ResultSetTableModel
extends AbstractTableModel {
    private static final long \u0101 = -3405605430548602851L;
    private Class[] \u0103;
    private String[] \u0104;
    protected int _recordCount;
    protected transient int _currentRow = -1;
    protected TableModelCache _cache;
    protected boolean _forwardOnly = false;
    protected ResultSet _resultSet;
    private boolean \u0102 = false;
    protected static final Logger LOGGER = Logger.getLogger(ResultSetTableModel.class.getName());

    public ResultSetTableModel(ResultSet resultSet) throws SQLException {
        this._resultSet = resultSet;
        this.\u0101();
    }

    public ResultSetTableModel(ResultSet resultSet, int n2) throws SQLException {
        this._resultSet = resultSet;
        this._recordCount = n2;
        this.\u0101();
    }

    private void \u0101() throws SQLException {
        this.refreshData();
    }

    @Override
    public int getColumnCount() {
        return this.\u0104.length;
    }

    private int \u0102() {
        return this.\u0104.length;
    }

    @Override
    public String getColumnName(int n2) {
        return this.\u0104[n2];
    }

    @Override
    public Class<?> getColumnClass(int n2) {
        return this.\u0103[n2];
    }

    @Override
    public int getRowCount() {
        return this._recordCount;
    }

    public void invalidateCache(int n2) {
        this._cache.\u0103(n2);
    }

    public void invalidateCache() {
        this._cache.\u0101();
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        if (this._cache.\u0101(n2, n3)) {
            return this._cache.\u0107(n2, n3);
        }
        try {
            if (this.isForwardOnly()) {
                if (this._currentRow == -1) {
                    this._resultSet.next();
                }
                if (this._currentRow <= n2) {
                    for (int i2 = this._currentRow; i2 <= n2; ++i2) {
                        for (int i3 = 0; i3 < this.\u0102(); ++i3) {
                            this._cache.\u0102(this._resultSet.getObject(i3 + 1), i2, i3);
                        }
                        this._resultSet.next();
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("next " + this._currentRow);
                        }
                        ++this._currentRow;
                    }
                }
            } else {
                if (n2 - this._currentRow != 1) {
                    this._resultSet.absolute(n2 + 1);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("jump " + n2);
                    }
                } else {
                    this._resultSet.next();
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("next " + n2);
                    }
                }
                for (int i4 = 0; i4 < this.\u0102(); ++i4) {
                    this._cache.\u0102(this._resultSet.getObject(i4 + 1), n2, i4);
                }
                this._currentRow = n2;
            }
            return this._cache.\u0107(n2, n3);
        }
        catch (SQLException sQLException) {
            LOGGER.severe(sQLException.getLocalizedMessage());
            return null;
        }
    }

    public void refreshData() throws SQLException {
        this.setUpdatable(this._resultSet != null && this._resultSet.getConcurrency() == 1008);
        this.setForwardOnly(this._resultSet == null || this._resultSet.getType() == 1003);
        int n2 = this._resultSet.getMetaData().getColumnCount();
        this.\u0104 = new String[n2];
        this.\u0103 = new Class[n2];
        for (int i2 = 0; i2 < this.\u0104.length; ++i2) {
            this.\u0104[i2] = this._resultSet.getMetaData().getColumnName(i2 + 1);
            try {
                this.\u0103[i2] = Class.forName(this._resultSet.getMetaData().getColumnClassName(i2 + 1));
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.\u0103[i2] = Object.class;
            }
        }
        this._cache = new TableModelCache();
        try {
            this._resultSet.last();
            this._recordCount = this._resultSet.getRow();
            this._resultSet.first();
            this._currentRow = 0;
        }
        catch (SQLException sQLException) {
            this.\u0103();
        }
        this._cache.\u0101(this._recordCount);
        this._cache.\u0102(this.\u0104.length);
        this.fireTableDataChanged();
    }

    private void \u0103() {
        this._cache.\u0104(-1);
        int n2 = 0;
        try {
            boolean bl;
            while (bl = this._resultSet.next()) {
                for (int i2 = 0; i2 < this.\u0102(); ++i2) {
                    this._cache.\u0102(this._resultSet.getObject(i2 + 1), n2, i2);
                }
                ++n2;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this._currentRow = n2;
        this._recordCount = n2;
    }

    @Override
    public boolean isCellEditable(int n2, int n3) {
        return this.isUpdatable();
    }

    @Override
    public void setValueAt(Object object, int n2, int n3) {
        try {
            if (!this.isForwardOnly()) {
                ResultSet resultSet = this.getResultSet();
                resultSet.absolute(n2 + 1);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("jump " + n2);
                }
                resultSet.updateObject(n3 + 1, object);
                resultSet.updateRow();
                this._cache.\u0102(object, n2, n3);
                this._currentRow = n2;
                this.fireTableCellUpdated(n2, n3);
            }
        }
        catch (SQLException sQLException) {
            LOGGER.severe(sQLException.getLocalizedMessage());
        }
    }

    public void setUpdatable(boolean bl) {
        this.\u0102 = bl;
    }

    public boolean isUpdatable() {
        return this.\u0102;
    }

    public ResultSet getResultSet() {
        return this._resultSet;
    }

    public boolean isForwardOnly() {
        return this._forwardOnly;
    }

    public void setForwardOnly(boolean bl) {
        this._forwardOnly = bl;
    }

    public void close() throws SQLException {
        if (this._resultSet != null) {
            this._resultSet.close();
        }
    }

    public int getMaximumCachedRows() {
        return this._cache.\u0108();
    }

    public void setMaximumCachedRows(int n2) {
        this._cache.\u0104(n2);
    }
}

