/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.database;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.CurrencyConverter;
import com.jidesoft.converter.NumberConverter;
import com.jidesoft.database.ResultSetTableModel;
import com.jidesoft.filter.AndFilter;
import com.jidesoft.filter.BetweenFilter;
import com.jidesoft.filter.EqualFilter;
import com.jidesoft.filter.Filter;
import com.jidesoft.filter.InFilter;
import com.jidesoft.filter.LikeFilter;
import com.jidesoft.filter.NotFilter;
import com.jidesoft.filter.OrFilter;
import com.jidesoft.filter.SqlFilterSupport;
import com.jidesoft.filter.WildcardFilter;
import com.jidesoft.grid.AutoFilterTableHeaderAdapter;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.DynamicTableFilter;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.FilterItemSupport;
import com.jidesoft.grid.FilterableTableModelEvent;
import com.jidesoft.grid.FilterableTableModelListener;
import com.jidesoft.grid.GridIconsFactory;
import com.jidesoft.grid.IFilterableTableModel;
import com.jidesoft.grid.ISortableTableModel;
import com.jidesoft.grid.MultipleValuesFilter;
import com.jidesoft.grid.SingleValueFilter;
import com.jidesoft.grid.SortEvent;
import com.jidesoft.grid.SortItemSupport;
import com.jidesoft.grid.SortListener;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.StringConverter;
import com.jidesoft.utils.TypeUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import javax.swing.table.AbstractTableModel;

public class DatabaseTableModel
extends AbstractTableModel
implements ISortableTableModel,
IFilterableTableModel,
ContextSensitiveTableModel {
    protected ResultSetTableModel _resultSetTableModel;
    protected Connection _connection;
    protected Statement _statement;
    protected String _fromStatement;
    protected String _selectStatement;
    protected String _preStatement;
    private boolean \u0ce1 = false;
    private Map<String, String> \u0ce0 = new HashMap<String, String>();
    private static final Logger \u0d06 = Logger.getLogger(DatabaseTableModel.class.getName());
    protected ConverterContext[] _converterContexts;
    private boolean \u0cb8 = false;
    private static final long \u0cb9 = -5764565305416398488L;
    protected SortItemSupport _sortItemSupport;
    private boolean[] \u0d05;
    protected FilterItemSupport _filterItemSupport;
    private boolean \u0cde = false;
    private static final Logger \u0cb7 = Logger.getLogger(FilterableTableModelEvent.class.getName());

    public DatabaseTableModel(Connection connection, String string) throws SQLException {
        this(connection, "*", string);
    }

    public DatabaseTableModel(Connection connection, String string, String string2) throws SQLException {
        this(connection, string, string2, false);
    }

    public DatabaseTableModel(Connection connection, String string, String string2, String string3) throws SQLException {
        this(connection, string, string2, string3, false);
    }

    public DatabaseTableModel(Connection connection, String string, String string2, boolean bl) throws SQLException {
        this(connection, null, string, string2, bl);
    }

    public DatabaseTableModel(Connection connection, String string, String string2, String string3, boolean bl) throws SQLException {
        this._connection = connection;
        this._preStatement = string;
        this._selectStatement = string2;
        this._fromStatement = string3;
        this._sortItemSupport = new SortItemSupport();
        this._filterItemSupport = new FilterItemSupport();
        this._filterItemSupport.setFiltersApplied(true);
        this.\u0ce1 = bl;
        this.initDatabase();
    }

    protected void initDatabase() throws SQLException {
        if (this._selectStatement == null) {
            this._selectStatement = "*";
        }
        this._statement = null;
        this.refreshData(this._sortItemSupport, this._filterItemSupport);
    }

    public void setColumnMapping(Map<String, String> map) {
        this.\u0ce0 = map;
    }

    public Map<String, String> getColumnMapping() {
        return this.\u0ce0;
    }

    @Override
    public int getColumnCount() {
        return this._resultSetTableModel == null ? 0 : this._resultSetTableModel.getColumnCount();
    }

    private String \u0120(int n2) {
        return this._resultSetTableModel == null ? "" : this._resultSetTableModel.getColumnName(n2);
    }

    @Override
    public String getColumnName(int n2) {
        String string = this.\u0120(n2);
        Map<String, String> map = this.getColumnMapping();
        if (map != null && map.containsKey(string.toUpperCase())) {
            return map.get(string.toUpperCase());
        }
        return string;
    }

    @Override
    public ConverterContext getConverterContextAt(int n2, int n3) {
        if (this._converterContexts != null && n3 < this._converterContexts.length) {
            return this._converterContexts[n3];
        }
        return null;
    }

    @Override
    public EditorContext getEditorContextAt(int n2, int n3) {
        return null;
    }

    @Override
    public Class<?> getCellClassAt(int n2, int n3) {
        return this.getColumnClass(n3);
    }

    @Override
    public Class<?> getColumnClass(int n2) {
        return this._resultSetTableModel == null ? null : this._resultSetTableModel.getColumnClass(n2);
    }

    @Override
    public int getRowCount() {
        return this._resultSetTableModel == null ? 0 : this._resultSetTableModel.getRowCount();
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        return this._resultSetTableModel == null ? null : this._resultSetTableModel.getValueAt(n2, n3);
    }

    @Override
    public int getSortedRowAt(int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getActualRowAt(int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sortColumn(int n2) {
        if (this._sortItemSupport.sortColumn(n2)) {
            this.resort();
        }
    }

    @Override
    public void sortColumn(int n2, boolean bl) {
        if (this._sortItemSupport.sortColumn(n2, bl)) {
            this.resort();
        }
    }

    @Override
    public void unsortColumn(int n2) {
        if (this._sortItemSupport.unsortColumn(n2)) {
            this.resort();
        }
    }

    @Override
    public void reverseColumnSortOrder(int n2) {
        if (this._sortItemSupport.reverseColumnSortOrder(n2)) {
            this.resort();
        }
    }

    @Override
    public void sortColumn(int n2, boolean bl, boolean bl2) {
        if (this._sortItemSupport.sortColumn(n2, bl, bl2)) {
            this.resort();
        }
    }

    @Override
    public boolean isColumnSorted(int n2) {
        return this._sortItemSupport.isColumnSorted(n2);
    }

    @Override
    public boolean isColumnAscending(int n2) {
        return this._sortItemSupport.isColumnAscending(n2);
    }

    @Override
    public void reset() {
        if (this._sortItemSupport.reset()) {
            this.resort();
        }
    }

    @Override
    public void toggleSortOrder(int n2, boolean bl) {
        this._sortItemSupport.toggleSortOrder(n2, bl);
        this.resort();
    }

    @Override
    public List<ISortableTableModel.SortItem> getSortingColumns() {
        return this._sortItemSupport.getSortingColumns();
    }

    @Override
    public void setSortingColumns(List<ISortableTableModel.SortItem> list) {
        this._sortItemSupport.setSortingColumns(list);
        this.resort();
    }

    @Override
    public int getColumnSortRank(int n2) {
        return this._sortItemSupport.getColumnSortRank(n2);
    }

    @Override
    public void setMasterSortColumns(int[] nArray) {
        this._sortItemSupport.setMasterSortColumns(nArray);
    }

    @Override
    public int[] getMasterSortColumns() {
        return this._sortItemSupport.getMasterSortColumns();
    }

    @Override
    public boolean isMultiColumnSortable() {
        return this._sortItemSupport.isMultiColumnSortable();
    }

    @Override
    public void setMultiColumnSortable(boolean bl) {
        this._sortItemSupport.setMultiColumnSortable(bl);
        this.resort();
    }

    @Override
    public boolean isSortable() {
        return this._sortItemSupport.isSortable();
    }

    @Override
    public void setSortable(boolean bl) {
        this._sortItemSupport.setSortable(bl);
    }

    @Override
    public void resort() {
        this.fireSortingEvent();
        this.sort();
        this.fireTableDataChanged();
        this.fireSortEvent();
    }

    @Override
    public int getSortPriority() {
        return this._sortItemSupport.getSortPriority();
    }

    @Override
    public void setSortPriority(int n2) {
        this._sortItemSupport.setSortPriority(n2);
    }

    @Override
    public int getMaximumSortColumns() {
        return this._sortItemSupport.getMaximumSortColumns();
    }

    @Override
    public void setMaximumSortColumns(int n2) {
        this._sortItemSupport.setMaximumSortColumns(n2);
    }

    @Override
    public void addSortListener(SortListener sortListener) {
        if (!JideSwingUtilities.isListenerRegistered(this.listenerList, SortListener.class, (EventListener)sortListener)) {
            this.listenerList.add(SortListener.class, sortListener);
        }
    }

    @Override
    public void removeSortListener(SortListener sortListener) {
        this.listenerList.remove(SortListener.class, sortListener);
    }

    @Override
    public SortListener[] getSortListeners() {
        return (SortListener[])this.listenerList.getListeners(SortListener.class);
    }

    public void fireSortEvent() {
        Object[] objectArray = this.listenerList.getListenerList();
        SortEvent sortEvent = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != SortListener.class) continue;
            if (sortEvent == null) {
                sortEvent = new SortEvent(this);
            }
            ((SortListener)objectArray[i2 + 1]).sortChanged(sortEvent);
        }
    }

    public void fireSortingEvent() {
        Object[] objectArray = this.listenerList.getListenerList();
        SortEvent sortEvent = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != SortListener.class) continue;
            if (sortEvent == null) {
                sortEvent = new SortEvent(this);
            }
            ((SortListener)objectArray[i2 + 1]).sortChanging(sortEvent);
        }
    }

    @Override
    public boolean isColumnSortable(int n2) {
        if (this.getColumnCount() == 0) {
            return false;
        }
        if (!this.isSortable()) {
            return false;
        }
        if (n2 >= 0 && n2 < this.getColumnCount()) {
            this.\u01e1();
            return this.\u0d05[n2];
        }
        return false;
    }

    @Override
    public void setColumnSortable(int n2, boolean bl) {
        if (n2 >= 0 && n2 < this.getColumnCount()) {
            this.\u01e1();
            this.\u0d05[n2] = bl;
        }
    }

    private void \u01e1() {
        if (this.\u0d05 == null) {
            this.\u0d05 = new boolean[this.getColumnCount()];
            Arrays.fill(this.\u0d05, true);
        }
    }

    protected void sort() {
        try {
            this.refreshData(this._sortItemSupport, this._filterItemSupport);
        }
        catch (SQLException sQLException) {
            \u0d06.severe(sQLException.getLocalizedMessage());
        }
    }

    protected String createOrderStatement(SortItemSupport sortItemSupport) {
        List<ISortableTableModel.SortItem> list;
        List<ISortableTableModel.SortItem> list2 = list = sortItemSupport == null ? null : sortItemSupport.getSortingColumns();
        if (list != null && list.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer("ORDER BY ");
            for (int i2 = 0; i2 < list.size(); ++i2) {
                ISortableTableModel.SortItem sortItem = list.get(i2);
                String string = this.\u0120(sortItem.column);
                stringBuffer.append(string).append(sortItem.ascending ? " ASC" : " DESC");
                if (i2 == list.size() - 1) continue;
                stringBuffer.append(",");
            }
            return stringBuffer.toString();
        }
        return null;
    }

    protected StringBuffer prepareWhereStatement(IFilterableTableModel.FilterItem filterItem) {
        StringBuffer stringBuffer = new StringBuffer();
        this.\u0101(filterItem.filter, filterItem.column, stringBuffer);
        return stringBuffer;
    }

    private void \u0101(Filter filter, int n2, StringBuffer stringBuffer) {
        Filter filter2;
        int n3;
        Object object;
        if (filter instanceof OrFilter) {
            object = ((OrFilter)filter).getFilters();
            for (n3 = 0; n3 < object.size(); ++n3) {
                filter2 = (Filter)object.get(n3);
                stringBuffer.append("(");
                this.\u0101(filter2, n2, stringBuffer);
                stringBuffer.append(")");
                if (n3 == object.size() - 1) continue;
                stringBuffer.append(" OR ");
            }
        } else if (filter instanceof AndFilter) {
            object = ((AndFilter)filter).getFilters();
            for (n3 = 0; n3 < object.size(); ++n3) {
                filter2 = (Filter)object.get(n3);
                stringBuffer.append("(");
                this.\u0101(filter2, n2, stringBuffer);
                stringBuffer.append(")");
                if (n3 == object.size() - 1) continue;
                stringBuffer.append(" AND ");
            }
        } else if (filter instanceof NotFilter) {
            object = ((NotFilter)filter).getFilter();
            stringBuffer.append(" NOT (");
            this.\u0101((Filter)object, n2, stringBuffer);
            stringBuffer.append(")");
        }
        if (n2 == -2) {
            stringBuffer.append("(");
            boolean bl = true;
            for (n3 = 0; n3 < this.getColumnCount(); ++n3) {
                if (!(filter instanceof SqlFilterSupport)) continue;
                if (!bl) {
                    stringBuffer.append(" OR ");
                }
                this.\u0101(filter, n2, stringBuffer, n3);
                bl = false;
            }
            if (bl) {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            } else {
                stringBuffer.append(")");
            }
        } else if (n2 == -1) {
            stringBuffer.append("(");
            boolean bl = true;
            for (n3 = 0; n3 < this.getColumnCount(); ++n3) {
                if (!(filter instanceof SqlFilterSupport)) continue;
                if (!bl) {
                    stringBuffer.append(" AND ");
                }
                this.\u0101(filter, n2, stringBuffer, n3);
                bl = false;
            }
            if (bl) {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            } else {
                stringBuffer.append(")");
            }
        } else {
            this.\u0101(filter, n2, stringBuffer, n2);
        }
    }

    private void \u0101(Filter filter, int n2, StringBuffer stringBuffer, int n3) {
        if (filter instanceof LikeFilter) {
            this.\u0101((LikeFilter)filter, n3, stringBuffer);
        } else if (filter instanceof EqualFilter) {
            this.\u0101((EqualFilter)filter, n3, stringBuffer);
        } else if (filter instanceof BetweenFilter) {
            this.\u0101((BetweenFilter)filter, n3, stringBuffer);
        } else if (filter instanceof InFilter) {
            this.\u0101((InFilter)filter, n3, stringBuffer);
        } else if (filter instanceof SingleValueFilter) {
            this.\u0101((SingleValueFilter)filter, n3, stringBuffer);
        } else if (filter instanceof MultipleValuesFilter) {
            this.\u0101((MultipleValuesFilter)filter, n3, stringBuffer);
        } else if (filter instanceof WildcardFilter) {
            this.\u0101((WildcardFilter)filter, n2, stringBuffer);
        }
    }

    private void \u0101(WildcardFilter wildcardFilter, int n2, StringBuffer stringBuffer) {
        stringBuffer.append(this.\u0120(n2)).append(" LIKE ");
        if (wildcardFilter.isBeginWith() && wildcardFilter.isEndWith()) {
            stringBuffer.append("'").append("%").append(wildcardFilter.getPattern()).append("%").append("'");
        } else if (wildcardFilter.isBeginWith()) {
            stringBuffer.append("'").append(wildcardFilter.getPattern()).append("%").append("'");
        } else if (wildcardFilter.isEndWith()) {
            stringBuffer.append("'").append("%").append(wildcardFilter.getPattern()).append("'");
        }
    }

    protected String convertElementToString(Filter filter, Object object) {
        if (object == null) {
            return "NULL";
        }
        if (object instanceof String || object instanceof Date) {
            return "'" + object + "'";
        }
        return object.toString();
    }

    private void \u0101(InFilter inFilter, int n2, StringBuffer stringBuffer) {
        stringBuffer.append(this.\u0120(n2)).append(inFilter.getOperator()).append("(");
        T[] TArray = inFilter.getValues();
        for (int i2 = 0; i2 < TArray.length; ++i2) {
            Object t2 = TArray[i2];
            stringBuffer.append(this.convertElementToString(inFilter, t2));
            if (i2 == TArray.length - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
    }

    private void \u0101(MultipleValuesFilter multipleValuesFilter, int n2, StringBuffer stringBuffer) {
        stringBuffer.append(this.\u0120(n2)).append(multipleValuesFilter.getOperator()).append("(");
        T[] TArray = multipleValuesFilter.getValues();
        for (int i2 = 0; i2 < TArray.length; ++i2) {
            Object t2 = TArray[i2];
            stringBuffer.append(this.convertElementToString(multipleValuesFilter, t2));
            if (i2 == TArray.length - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
    }

    private void \u0101(BetweenFilter betweenFilter, int n2, StringBuffer stringBuffer) {
        stringBuffer.append(this.\u0120(n2)).append(betweenFilter.getOperator());
        Object t2 = betweenFilter.getValue1();
        stringBuffer.append(this.convertElementToString(betweenFilter, t2));
        stringBuffer.append(" AND ");
        Object t3 = betweenFilter.getValue2();
        stringBuffer.append(this.convertElementToString(betweenFilter, t3));
    }

    private void \u0101(EqualFilter equalFilter, int n2, StringBuffer stringBuffer) {
        stringBuffer.append(this.\u0120(n2)).append(equalFilter.getOperator());
        Object t2 = equalFilter.getValue();
        stringBuffer.append(this.convertElementToString(equalFilter, t2));
    }

    private void \u0101(SingleValueFilter singleValueFilter, int n2, StringBuffer stringBuffer) {
        stringBuffer.append(this.\u0120(n2)).append(singleValueFilter.getOperator());
        Object t2 = singleValueFilter.getValue();
        stringBuffer.append(this.convertElementToString(singleValueFilter, t2));
    }

    private void \u0101(LikeFilter likeFilter, int n2, StringBuffer stringBuffer) {
        String string = likeFilter.getPattern();
        if (string == null) {
            return;
        }
        if (!likeFilter.isCaseSensitive()) {
            stringBuffer.append("lower(").append(this.\u0120(n2)).append(")");
        } else {
            stringBuffer.append(this.\u0120(n2));
        }
        if (!likeFilter.isCaseSensitive()) {
            string = string.toLowerCase();
        }
        stringBuffer.append(likeFilter.getOperator()).append("'").append(string).append("'");
    }

    @Override
    public void refresh() {
        try {
            this.refreshData(this._sortItemSupport, this._filterItemSupport);
        }
        catch (SQLException sQLException) {
            StringWriter stringWriter = new StringWriter();
            sQLException.printStackTrace(new PrintWriter(stringWriter));
            \u0d06.severe(stringWriter.toString());
        }
    }

    protected String createWhereStatement(FilterItemSupport filterItemSupport) {
        List<IFilterableTableModel.FilterItem> list;
        List<IFilterableTableModel.FilterItem> list2 = list = filterItemSupport == null ? null : filterItemSupport.getFilterItems();
        if (list != null && list.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer("");
            for (int i2 = 0; i2 < list.size(); ++i2) {
                IFilterableTableModel.FilterItem filterItem = list.get(i2);
                StringBuffer stringBuffer2 = this.prepareWhereStatement(filterItem);
                if (stringBuffer2.length() > 0) {
                    stringBuffer.append("(").append(stringBuffer2).append(")");
                }
                if (i2 == list.size() - 1) continue;
                stringBuffer.append(filterItemSupport.isAndMode() ? " AND " : " OR ");
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.insert(0, "WHERE ");
                return stringBuffer.toString();
            }
        }
        return null;
    }

    @Override
    public boolean isColumnFilterable(int n2) {
        return true;
    }

    @Override
    public boolean isColumnVisible(int n2) {
        return true;
    }

    @Override
    public boolean isColumnAutoFilterable(int n2) {
        return true;
    }

    @Override
    public boolean isValuePredetermined(int n2) {
        return true;
    }

    @Override
    public void addFilter(int n2, Filter filter) {
        this._filterItemSupport.addFilter(n2, filter);
    }

    @Override
    public void addFilter(Filter filter) {
        this._filterItemSupport.addFilter(filter);
    }

    @Override
    public void addFilter(IFilterableTableModel.FilterItem filterItem) {
        this._filterItemSupport.addFilter(filterItem);
    }

    @Override
    public void removeFilter(int n2, Filter filter) {
        this._filterItemSupport.removeFilter(n2, filter);
    }

    @Override
    public void removeFilter(Filter filter) {
        this._filterItemSupport.removeFilter(filter);
    }

    @Override
    public void removeFilter(IFilterableTableModel.FilterItem filterItem) {
        this._filterItemSupport.removeFilter(filterItem);
    }

    @Override
    public void removeAllFilters(int n2) {
        this._filterItemSupport.removeAllFilters(n2);
    }

    @Override
    public void removeAllFilters() {
        this._filterItemSupport.removeAllFilters();
    }

    @Override
    public void clearFilters() {
        this._filterItemSupport.clearFilters();
    }

    @Override
    public Filter[] getFilters(int n2) {
        return this._filterItemSupport.getFilters(n2);
    }

    @Override
    public List<IFilterableTableModel.FilterItem> getFilterItems() {
        return this._filterItemSupport.getFilterItems();
    }

    @Override
    public void setFiltersApplied(boolean bl) {
        this._filterItemSupport.setFiltersApplied(bl);
        this.refresh();
    }

    @Override
    public boolean isFiltersApplied() {
        return this._filterItemSupport.isFiltersApplied();
    }

    @Override
    public boolean hasFilter() {
        return this._filterItemSupport.hasFilter();
    }

    @Override
    public boolean hasFilter(int n2) {
        return this._filterItemSupport.hasFilter(n2);
    }

    @Override
    public boolean isAndMode() {
        return this._filterItemSupport.isAndMode();
    }

    @Override
    public void setAndMode(boolean bl) {
        this._filterItemSupport.setAndMode(bl);
    }

    @Override
    public boolean isAdjusting() {
        return this.\u0cde;
    }

    @Override
    public void setAdjusting(boolean bl) {
        if (this.\u0cde != bl) {
            this.\u0cde = bl;
            if (!this.\u0cde) {
                // empty if block
            }
        }
    }

    @Override
    public Object[] getPossibleValues(int n2, Comparator comparator) {
        try {
            String string = this.createPossibleValuesStatement(n2);
            if (this._statement == null) {
                this._statement = this.createStatement();
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Statement statement = this.\u0106(string);
            ResultSet resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                arrayList.add(resultSet.getObject(1));
            }
            Object[] objectArray = arrayList.toArray(new Object[arrayList.size()]);
            Arrays.sort(objectArray, comparator);
            return objectArray;
        }
        catch (SQLException sQLException) {
            return new Object[0];
        }
    }

    @Override
    public Object[] getPossibleValuesAndConverters(int n2, Comparator comparator) {
        return this.getPossibleValues(n2, comparator);
    }

    @Override
    public boolean isSameConverterAt(int n2) {
        return true;
    }

    @Override
    public boolean isSplitArrayOrCollection() {
        return false;
    }

    @Override
    public void setSplitArrayOrCollection(boolean bl) {
    }

    protected String createPossibleValuesStatement(int n2) {
        return this.createSqlStatement(this._preStatement, "distinct " + this.\u0120(n2), this._fromStatement, null, null).toString();
    }

    @Override
    public void setFilteringPaused(boolean bl) {
    }

    @Override
    public boolean isFilteringPaused() {
        return false;
    }

    @Override
    public void addFilterableTableModelListener(FilterableTableModelListener filterableTableModelListener) {
        this.listenerList.add(FilterableTableModelListener.class, filterableTableModelListener);
    }

    @Override
    public void removeFilterableTableModelListener(FilterableTableModelListener filterableTableModelListener) {
        this.listenerList.remove(FilterableTableModelListener.class, filterableTableModelListener);
    }

    @Override
    public FilterableTableModelListener[] getFilterableTableModelListeners() {
        return (FilterableTableModelListener[])this.listenerList.getListeners(FilterableTableModelListener.class);
    }

    public void fireFilterChanged(FilterableTableModelEvent filterableTableModelEvent) {
        if (\u0cb7.isLoggable(Level.FINE)) {
            switch (filterableTableModelEvent.getID()) {
                case 7099: {
                    \u0cb7.fine("FilterableTableModel: \"" + filterableTableModelEvent.getFilter() + "\" is added at column index " + filterableTableModelEvent.getColumn());
                    break;
                }
                case 7100: {
                    if (filterableTableModelEvent.getFilter() == null) {
                        \u0cb7.fine("FilterableTableModel: all filters are cleared at column index " + filterableTableModelEvent.getColumn());
                        break;
                    }
                    \u0cb7.fine("FilterableTableModel: \"" + filterableTableModelEvent.getFilter() + "\" is removed at column index " + filterableTableModelEvent.getColumn());
                }
            }
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != FilterableTableModelListener.class) continue;
            ((FilterableTableModelListener)objectArray[i2 + 1]).filterableTableModelChanged(filterableTableModelEvent);
        }
    }

    public void fireFilterAdded(int n2, Filter filter) {
        this.fireFilterChanged(new FilterableTableModelEvent(this, 7099, n2, filter));
    }

    public void fireFilterRemoved(int n2, Filter filter) {
        this.fireFilterChanged(new FilterableTableModelEvent(this, 7100, n2, filter));
    }

    @Override
    public Icon getFilterIcon(int n2) {
        return GridIconsFactory.getImageIcon("icons/filter.png");
    }

    protected Statement createStatement() throws SQLException {
        Statement statement;
        int n2 = this.isUpdatable() ? 1008 : 1007;
        try {
            statement = this._connection.createStatement(1005, n2);
        }
        catch (SQLException sQLException) {
            try {
                statement = this._connection.createStatement(1004, n2);
            }
            catch (SQLException sQLException2) {
                statement = this._connection.createStatement(1003, n2);
            }
        }
        return statement;
    }

    protected Statement createReadonlyStatement() throws SQLException {
        Statement statement;
        try {
            statement = this._connection.createStatement(1004, 1007);
        }
        catch (SQLException sQLException) {
            statement = this._connection.createStatement(1003, 1007);
        }
        return statement;
    }

    protected Statement adjustStatement(Statement statement, String string) throws SQLException {
        return statement.getResultSetConcurrency() != 1008 || string.startsWith("select count(*) ") ? this.createReadonlyStatement() : null;
    }

    public void refreshData(SortItemSupport sortItemSupport, FilterItemSupport filterItemSupport) throws SQLException {
        String string = this.createCountStatement(filterItemSupport);
        if (\u0d06.isLoggable(Level.FINE)) {
            \u0d06.fine("SQL statement: " + string);
        }
        if (this._statement == null) {
            this._statement = this.createStatement();
        }
        Statement statement = this.\u0106(string);
        ResultSet resultSet = statement.executeQuery(string);
        resultSet.next();
        int n2 = resultSet.getInt(1);
        StringBuffer stringBuffer = this.createSqlStatement(this._preStatement, this._selectStatement, this._fromStatement, sortItemSupport, filterItemSupport);
        String string2 = stringBuffer.toString();
        statement = this.\u0106(string2);
        ResultSet resultSet2 = statement.executeQuery(string2);
        if (this._resultSetTableModel != null) {
            this._resultSetTableModel.close();
        }
        this._resultSetTableModel = this.createResultSetTableModel(resultSet2, n2);
        this.configureConverterContexts();
        this.fireTableDataChanged();
    }

    private Statement \u0106(String string) throws SQLException {
        Statement statement = this.adjustStatement(this._statement, string);
        if (statement == null) {
            statement = this._statement;
        }
        if (\u0d06.isLoggable(Level.FINE)) {
            \u0d06.fine("SQL statement: " + string);
        }
        return statement;
    }

    protected ResultSetTableModel createResultSetTableModel(ResultSet resultSet, int n2) throws SQLException {
        return new ResultSetTableModel(resultSet, n2);
    }

    protected void configureConverterContexts() throws SQLException {
        int n2 = this.getColumnCount();
        this._converterContexts = new ConverterContext[n2];
        if (this._resultSetTableModel == null) {
            return;
        }
        ResultSetMetaData resultSetMetaData = this._resultSetTableModel.getResultSet().getMetaData();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = i2 + 1;
            if (this.isConsiderCurrencyField() && resultSetMetaData.isCurrency(n3)) {
                this._converterContexts[i2] = CurrencyConverter.CONTEXT;
                continue;
            }
            if (TypeUtils.isNumericType(this.getColumnClass(i2))) {
                int n4 = resultSetMetaData.getScale(n3);
                this._converterContexts[i2] = NumberConverter.CONTEXT_FRACTION_NUMBER;
                NumberFormat numberFormat = NumberFormat.getInstance();
                numberFormat.setMinimumFractionDigits(n4);
                numberFormat.setMaximumFractionDigits(n4);
                numberFormat.setMaximumIntegerDigits(resultSetMetaData.getPrecision(n3));
                this._converterContexts[i2].setUserObject(numberFormat);
                continue;
            }
            this._converterContexts[i2] = null;
        }
    }

    protected String createCountStatement(FilterItemSupport filterItemSupport) {
        Pattern[] patternArray = new Pattern[]{Pattern.compile(" order +by "), Pattern.compile(" group +by ")};
        String string = this._fromStatement;
        for (int i2 = 0; i2 < patternArray.length; ++i2) {
            Matcher matcher = patternArray[i2].matcher(string.toLowerCase());
            if (!matcher.find()) continue;
            string = string.substring(0, matcher.start());
        }
        return this.createSqlStatement(this._preStatement, "count(*)", string, null, filterItemSupport).toString();
    }

    protected StringBuffer createSqlStatement(String string, String string2, String string3, SortItemSupport sortItemSupport, FilterItemSupport filterItemSupport) {
        String string4;
        StringBuffer stringBuffer = string != null && string.trim().length() > 0 ? new StringBuffer(string).append(" select ") : new StringBuffer("select ");
        stringBuffer.append(string2).append(" from ").append(string3);
        String string5 = this.createWhereStatement(filterItemSupport);
        if (string5 != null) {
            stringBuffer.append(" ").append(string5);
        }
        if ((string4 = this.createOrderStatement(sortItemSupport)) != null) {
            stringBuffer.append(" ").append(string4);
        }
        return stringBuffer;
    }

    @Override
    public void setValueAt(Object object, int n2, int n3) {
        if (this._resultSetTableModel != null) {
            this._resultSetTableModel.setValueAt(object, n2, n3);
            try {
                this.commit();
            }
            catch (SQLException sQLException) {
                \u0d06.severe(sQLException.getLocalizedMessage());
            }
        }
    }

    public void invalidateCache(int n2) {
        this._resultSetTableModel.invalidateCache(n2);
    }

    public void invalidateCache() {
        this._resultSetTableModel.invalidateCache();
    }

    @Override
    public boolean isCellEditable(int n2, int n3) {
        boolean bl;
        boolean bl2 = bl = this._resultSetTableModel != null && this._resultSetTableModel.isCellEditable(n2, n3);
        if (bl) {
            try {
                return !this._resultSetTableModel.getResultSet().getMetaData().isReadOnly(n3 + 1);
            }
            catch (SQLException sQLException) {
                return false;
            }
        }
        return false;
    }

    public void setUpdatable(boolean bl) {
        boolean bl2 = this.\u0ce1;
        if (bl2 != bl) {
            this.\u0ce1 = bl;
            this._statement = null;
            try {
                this.initDatabase();
            }
            catch (SQLException sQLException) {
                this.\u0ce1 = false;
            }
        }
        if (this._resultSetTableModel != null) {
            this._resultSetTableModel.setUpdatable(this.\u0ce1);
        }
    }

    public boolean isUpdatable() {
        return this.\u0ce1;
    }

    public void commit() throws SQLException {
        if (!this._connection.getAutoCommit()) {
            this._connection.commit();
        }
    }

    public void close() throws SQLException {
        if (this._resultSetTableModel != null) {
            this._resultSetTableModel.close();
        }
        this._connection.close();
    }

    public boolean validate(int n2, Object object) {
        try {
            if (!this.validateNullable(n2, object)) {
                return false;
            }
            if (!this.validateSigned(n2, object)) {
                return false;
            }
            if (!this.validatePrecision(n2, object)) {
                return false;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return true;
    }

    public boolean validateNullable(int n2, Object object) throws SQLException {
        return object != null || this._resultSetTableModel.getResultSet().getMetaData().isNullable(n2 + 1) != 0;
    }

    public boolean validateSigned(int n2, Object object) throws SQLException {
        return !TypeUtils.isNumericType(this.getColumnClass(n2)) || !(((Number)object).doubleValue() < 0.0) || this._resultSetTableModel.getResultSet().getMetaData().isSigned(n2 + 1);
    }

    public boolean validatePrecision(int n2, Object object) throws SQLException {
        int n3 = this._resultSetTableModel.getResultSet().getMetaData().getPrecision(n2 + 1);
        if (n3 == 0) {
            return true;
        }
        return !(TypeUtils.isNumericType(this.getColumnClass(n2)) ? Math.pow(10.0, n3) < ((Number)object).doubleValue() : object.toString().length() > n3);
    }

    public boolean isConsiderCurrencyField() {
        return this.\u0cb8;
    }

    public void setConsiderCurrencyField(boolean bl) {
        this.\u0cb8 = bl;
    }

    @Override
    public DynamicTableFilter[] getDynamicTableFilters(int n2) {
        return new DynamicTableFilter[0];
    }

    @Override
    public boolean isAllowMultipleValues(int n2) {
        return true;
    }

    @Override
    public StringConverter getTitleConverter(int n2) {
        return null;
    }

    @Override
    public AutoFilterTableHeaderAdapter.FilterTitleFormatter getFilterTitleFormatter(int n2) {
        return null;
    }

    @Override
    public ListCellRenderer getListCellRenderer(int n2) {
        return null;
    }

    @Override
    public boolean isUseTableCellRenderer(int n2) {
        return false;
    }

    @Override
    public boolean isAllowCustomFilter(int n2) {
        return true;
    }

    @Override
    public SingleValueFilter createSingleValueFilter(Object object) {
        return new SingleValueFilter<Object>(object);
    }

    @Override
    public MultipleValuesFilter createMultipleValuesFilter(Object[] objectArray) {
        return new MultipleValuesFilter<Object>(objectArray);
    }
}

