/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.DateModel;
import com.jidesoft.combobox.DateModelEvent;
import com.jidesoft.combobox.DateModelListener;
import com.jidesoft.combobox.DefaultDateModel;
import com.jidesoft.combobox.E;
import com.jidesoft.combobox.PopupPanel;
import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.icons.JideIconsFactory;
import com.jidesoft.icons.MaskFilter;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.spinner.SpinnerWheelSupport;
import com.jidesoft.swing.DelegateAction;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.NullLabel;
import com.jidesoft.swing.NullPanel;
import com.jidesoft.utils.PortingUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.JTextComponent;

public class MonthChooserPanel
extends PopupPanel
implements ItemListener,
ActionListener,
MouseListener,
MouseWheelListener,
DateModelListener {
    private Color \u039a = UIDefaultsLookup.getColor("TextField.background");
    private Color \u0398 = UIDefaultsLookup.getColor("TextField.foreground");
    private Font \u03bd = UIDefaultsLookup.getFont("TextField.font");
    private Border \u03ac = BorderFactory.createEmptyBorder(6, 6, 6, 6);
    private Color \u03a1 = UIDefaultsLookup.getColor("InternalFrame.activeTitleBackground");
    private Color \u039c = UIDefaultsLookup.getColor("InternalFrame.activeTitleForeground");
    private Border \u039e = BorderFactory.createEmptyBorder(4, 4, 4, 4);
    private Border \u03b2 = BorderFactory.createEmptyBorder(4, 4, 4, 4);
    private Color \u039d = UIDefaultsLookup.getColor("TextField.foreground");
    private Color \u039f = UIDefaultsLookup.getColor("TextField.selectionForeground");
    private Color \u03a6 = UIDefaultsLookup.getColor("TextField.selectionBackground");
    private int \u0396 = 5;
    private int \u03aa = 0;
    private int \u03af = 70;
    private int \u03a4 = 25;
    private Border \u03ad = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    private Border \u0395 = BorderFactory.createLineBorder(Color.red, 1);
    private int \u03b0 = 0;
    private boolean \u03a0 = false;
    private DateFormat \u03ab;
    private DateFormat \u0394;
    private DateFormat \u03be;
    private int \u03bc;
    private int \u03ae;
    private int \u03bb;
    private int \u03a9;
    private HashMap<Component, Date> \u039b = new HashMap();
    private Calendar \u0393;
    private Calendar \u0399;
    private Calendar \u03b1;
    private JButton \u03b9;
    private JButton \u03a5;
    private JButton \u03a3;
    private JButton \u03a8;
    private JComponent \u03b8;
    private JComponent \u03b5;
    private JComponent[] \u03b6 = new JComponent[12];
    private JPanel \u03a7;
    private boolean \u03b7 = true;
    private boolean \u03b3 = true;
    private boolean \u03b4;
    private ButtonPanel \u03ba;
    public static final String VIEWONLY_PROPERTY = "viewonly";
    public static int NAVIGATION_BUTTON_HEIGHT = 18;
    public static int NAVIGATION_BUTTON_WIDTH = 20;
    private DateModel \u0397;
    boolean \u03bf = false;

    public MonthChooserPanel() {
        this(new DefaultDateModel(), true);
    }

    public MonthChooserPanel(DateModel dateModel) {
        this(dateModel, true);
    }

    public MonthChooserPanel(boolean bl) {
        this(new DefaultDateModel(), bl);
    }

    public MonthChooserPanel(DateModel dateModel, boolean bl) {
        this(dateModel, bl, Locale.getDefault());
    }

    public MonthChooserPanel(DateModel dateModel, boolean bl, Locale locale) {
        this.\u0397 = dateModel;
        this.\u03b7 = bl;
        this.setLocale(locale);
        this.initDateFormat(locale);
        this.initComponents();
        this.initCalendar();
        this.addItemListener(this);
        this.addMouseWheelListener(this);
        this.updateCalendar();
        this.\u03bf = true;
    }

    public DateModel getDateModel() {
        return this.\u0397;
    }

    public void setDateModel(DateModel dateModel) {
        if (this.\u0397 != dateModel) {
            if (this.\u0397 != null) {
                this.removeModeListener();
            }
            this.\u0397 = dateModel;
            if (this.\u0397 != null) {
                this.addModelListener();
            }
        }
    }

    protected void addModelListener() {
        this.\u0397.addDateModelListener(this);
    }

    protected void removeModeListener() {
        this.\u0397.removeDateModelListener(this);
    }

    @Override
    public void dateModelChanged(DateModelEvent dateModelEvent) {
        this.updateCalendar();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.isViewOnly()) {
            Component component;
            Object object = mouseEvent.getSource();
            if (object instanceof Component && this.\u039b.containsKey(component = (Component)object)) {
                this.setSelectedDate(this.\u039b.get(component));
                this.repaint();
            }
            this.mousePressed(mouseEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.isViewOnly()) {
            Object object = mouseEvent.getSource();
            if (object == this.\u03b8) {
                this.\u0145();
            } else {
                this.\u0141();
            }
        }
    }

    private void \u0145() {
        if (!this.\u03a0) {
            this.\u03a7.remove(this.\u03b8);
            try {
                ((JSpinner)this.\u03b5).setValue(this.\u0393.get(1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.\u03a7.add(this.\u03b5);
            Container container = this.getTopLevelAncestor();
            if (container != null) {
                if (container instanceof Window) {
                    ((Window)container).setFocusableWindowState(true);
                }
                container.setFocusable(true);
            }
            this.\u03b5.requestFocus();
            this.\u03a7.revalidate();
            this.\u03a7.repaint();
            this.repaint();
            this.\u03a0 = true;
        }
    }

    private void \u0141() {
        if (this.\u03a0) {
            this.\u03a7.remove(this.\u03b5);
            this.\u03a7.add(this.\u03b8);
            Object object = ((JSpinner)this.\u03b5).getValue();
            if (object instanceof Integer) {
                this.setDisplayedYear((Integer)object);
                this.\u03a7.revalidate();
                this.\u03a7.repaint();
                this.updateCalendar();
            }
            this.\u03a0 = false;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Object object;
        if (!this.isViewOnly() && (object = mouseEvent.getSource()) == this.\u03b8) {
            this.\u0145();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        boolean bl;
        int n2 = mouseWheelEvent.getUnitsToScroll();
        boolean bl2 = bl = n2 < 0;
        if (bl) {
            if (JideSwingUtilities.isMenuShortcutKeyDown(mouseWheelEvent)) {
                this.\u0142();
            } else {
                this.\u0144();
            }
        } else if (JideSwingUtilities.isMenuShortcutKeyDown(mouseWheelEvent)) {
            this.\u0146();
        } else {
            this.\u014a();
        }
    }

    public void enableMouseWheel() {
        this.removeMouseWheelListener(this);
        this.addMouseWheelListener(this);
    }

    public void disableMouseWheel() {
        this.removeMouseWheelListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (!(object instanceof Component)) {
            return;
        }
        Component component = (Component)object;
        if (this.\u039b.containsKey(component)) {
            this.setSelectedDate(this.\u039b.get(component));
            this.\u03b1 = this.getSelectedCalendar();
            this.\u0149();
            this.updateCalendar();
        } else if (object instanceof JMenuItem) {
            Container container = ((JMenuItem)object).getParent();
            for (int i2 = 0; i2 < container.getComponentCount(); ++i2) {
                Component component2 = container.getComponent(i2);
                if (component2 != object) continue;
                this.\u0393.set(2, i2);
                this.updateCalendar();
                break;
            }
        } else if (object == this.\u03a5) {
            this.\u0141();
            this.\u0393.roll(1, -1);
            this.updateCalendar();
        } else if (object == this.\u03b9) {
            this.\u0141();
            this.\u0393.roll(1, 1);
            this.updateCalendar();
        } else if (object == this.\u03a3) {
            this.\u0141();
            this.setSelectedDate(null);
        } else if (object == this.\u03a8) {
            this.\u0141();
            this.setSelectedCalendar(this.\u0399);
        }
    }

    Calendar \u014b() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, this.\u03bb);
        calendar.set(2, this.\u03a9);
        return calendar;
    }

    public Date getSelectedDate() {
        if (this.getSelectedCalendar() != null) {
            return this.getSelectedCalendar().getTime();
        }
        return null;
    }

    public Calendar getSelectedCalendar() {
        Object object = this.getSelectedObject();
        if (object instanceof Calendar) {
            return (Calendar)((Calendar)object).clone();
        }
        if (object instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)object);
            return calendar;
        }
        return null;
    }

    public void setSelectedDate(Date date) {
        if (date == null) {
            this.setSelectedObject(null);
        } else {
            Calendar calendar = this.getMonthCalendar();
            calendar.setTime(date);
            this.setSelectedCalendar(calendar);
        }
    }

    protected Calendar getMonthCalendar() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        calendar.set(10, 0);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    protected void updateMonthCalendar(Calendar calendar) {
        calendar.set(5, 1);
    }

    public void setSelectedCalendar(Calendar calendar) {
        if (this.\u0397.isValidDate(calendar)) {
            if (calendar != null) {
                this.setSelectedObject(calendar.clone());
            } else {
                this.setSelectedObject(null);
            }
        }
    }

    private void \u0147() {
        this.\u0141();
        Date date = this.\u03b1.getTime();
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            this.setSelectedCalendar(calendar);
        } else {
            this.setSelectedCalendar(null);
        }
    }

    public boolean setDisplayedYear(int n2) {
        Calendar calendar = this.getMonthCalendar();
        calendar.set(1, n2);
        if (this.\u0397.yearInRange(calendar)) {
            this.\u0393 = calendar;
            this.updateCalendar();
            return true;
        }
        return false;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            if (this.getSelectedCalendar() == null) {
                this.\u03bb = 0;
                this.\u03a9 = 0;
            } else {
                this.\u03b1 = this.getSelectedCalendar();
                this.\u0149();
                this.setDisplayedYear(this.\u03b1.get(1));
            }
            this.updateCalendar();
        }
    }

    protected Component createMonthsPanel() {
        JPanel jPanel = this.\u0101(new BorderLayout());
        jPanel.add(this.createMonthPanel(), "Center");
        jPanel.setBackground(this.\u039a);
        jPanel.setForeground(this.\u0398);
        return jPanel;
    }

    protected Component createMonthPanel() {
        JPanel jPanel = this.\u0101(new GridLayout(4, 3, this.\u0396, this.\u03aa));
        for (int i2 = 0; i2 < this.\u03b6.length; ++i2) {
            this.\u03b6[i2] = this.createMonthLabel(i2);
            jPanel.add(this.\u03b6[i2]);
        }
        jPanel.setBackground(this.\u039a);
        jPanel.setForeground(this.\u0398);
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        return jPanel;
    }

    @Override
    void \u0101(DelegateAction delegateAction) {
        for (JComponent jComponent : this.\u03b6) {
            if (jComponent == null) continue;
            DelegateAction.replaceAction(jComponent, 0, KeyStroke.getKeyStroke(10, 0), delegateAction);
        }
    }

    private Dimension \u0102(AbstractButton abstractButton) {
        Dimension dimension = BasicGraphicsUtils.getPreferredButtonSize(abstractButton, abstractButton.getIconTextGap());
        if (dimension.width < this.\u03af) {
            dimension.width = this.\u03af;
        }
        if (dimension.height < this.\u03a4) {
            dimension.height = this.\u03a4;
        }
        return dimension;
    }

    protected JComponent createMonthLabel(int n2) {
        JideButton jideButton = new JideButton("0"){

            @Override
            public Dimension getPreferredSize() {
                return MonthChooserPanel.this.\u0102(this);
            }
        };
        jideButton.setHorizontalAlignment(this.\u03b0);
        jideButton.addMouseListener(this);
        jideButton.setBackground(this.\u039a);
        jideButton.setForeground(this.\u0398);
        jideButton.setBorder(this.\u03ad);
        jideButton.setFont(null);
        return jideButton;
    }

    protected JTextField getTextField(JSpinner jSpinner) {
        JComponent jComponent = jSpinner.getEditor();
        if (jComponent instanceof JSpinner.DefaultEditor) {
            return ((JSpinner.DefaultEditor)jComponent).getTextField();
        }
        System.err.println("Unexpected editor type: " + jSpinner.getEditor().getClass() + " isn't a descendent of DefaultEditor");
        return null;
    }

    protected Component createYearPanel() {
        this.\u03b8 = this.createYearLabel();
        this.\u03b8.addMouseListener(this);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(this.getMonthCalendar().get(1), 1900, 2100, 1);
        this.\u03b5 = new JSpinner(spinnerNumberModel);
        SpinnerWheelSupport.installMouseWheelSupport((JSpinner)this.\u03b5);
        this.\u03b5.setFont(this.getFont());
        ((JSpinner)this.\u03b5).setEditor(new JSpinner.NumberEditor((JSpinner)this.\u03b5, "#"));
        this.\u03b5.setBorder(BorderFactory.createEmptyBorder());
        this.\u03b5.setForeground(this.\u039c);
        this.\u03b5.setBackground(this.\u03a1);
        JTextField jTextField = this.getTextField((JSpinner)this.\u03b5);
        if (jTextField != null) {
            jTextField.setBorder(BorderFactory.createEmptyBorder());
            jTextField.setColumns(3);
            jTextField.setHorizontalAlignment(4);
            jTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyChar() == '\n') {
                        MonthChooserPanel.this.\u0141();
                    }
                }
            });
        }
        ((JSpinner)this.\u03b5).addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Object object = ((JSpinner)MonthChooserPanel.this.\u03b5).getValue();
                if (object instanceof Integer) {
                    MonthChooserPanel.this.setDisplayedYear((Integer)object);
                    MonthChooserPanel.this.updateCalendar();
                }
            }
        });
        this.\u03a7 = this.\u0101(new FlowLayout());
        this.\u03a7.setOpaque(false);
        this.\u03a7.add(this.\u03b8);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setFont(null);
        this.\u03a5 = new JideButton(new ImageIcon(MaskFilter.createImage(JideIconsFactory.getImageIcon("jide/direction_left.gif").getImage(), Color.BLACK, this.\u039c)));
        this.\u03a5.setPreferredSize(new Dimension(NAVIGATION_BUTTON_WIDTH, NAVIGATION_BUTTON_HEIGHT));
        PortingUtils.removeFocus(this.\u03a5);
        this.\u03a5.addActionListener(this);
        JPanel jPanel2 = JideSwingUtilities.createCenterPanel(this.\u03a5);
        jPanel2.setOpaque(false);
        jPanel.add((Component)jPanel2, "Before");
        this.\u03b9 = new JideButton(new ImageIcon(MaskFilter.createImage(JideIconsFactory.getImageIcon("jide/direction_right.gif").getImage(), Color.BLACK, this.\u039c)));
        this.\u03b9.setPreferredSize(new Dimension(NAVIGATION_BUTTON_WIDTH, NAVIGATION_BUTTON_HEIGHT));
        PortingUtils.removeFocus(this.\u03b9);
        this.\u03b9.addActionListener(this);
        jPanel2 = JideSwingUtilities.createCenterPanel(this.\u03b9);
        jPanel2.setOpaque(false);
        jPanel.add((Component)jPanel2, "After");
        jPanel.add((Component)this.\u03a7, "Center");
        this.\u03a5.setVisible(!this.isViewOnly());
        this.\u03b9.setVisible(!this.isViewOnly());
        jPanel.setBorder(this.\u039e);
        jPanel.setBackground(this.\u03a1);
        jPanel.setForeground(this.\u039c);
        return jPanel;
    }

    protected Component createButtonPanel() {
        this.\u03ba = new ButtonPanel(){

            @Override
            public void updateUI() {
                super.updateUI();
                this.\u0109();
            }

            private void \u0109() {
                this.setFont(null);
                this.setBackground(null);
                this.setForeground(null);
            }
        };
        this.\u03a8 = new JButton(this.getResourceString("Date.thismonth"));
        this.\u03a8.setName("Date.thismonth");
        this.\u03a8.setMnemonic(this.getResourceString("Date.thismonth.mnemonic").charAt(0));
        this.\u03a8.addActionListener(this);
        this.\u03ba.addButton(this.\u03a8);
        this.\u03a3 = new JButton(this.getResourceString("Date.none"));
        this.\u03a3.setName("Date.none");
        this.\u03a3.setMnemonic(this.getResourceString("Date.none.mnemonic").charAt(0));
        this.\u03a3.addActionListener(this);
        this.\u03ba.addButton(this.\u03a3);
        JPanel jPanel = this.\u0101(new FlowLayout());
        jPanel.add(this.\u03ba);
        jPanel.setBorder(this.\u03b2);
        jPanel.setBackground(this.\u039a);
        jPanel.setForeground(this.\u0398);
        this.updateButtons();
        JideSwingUtilities.setOpaqueRecursively(jPanel, false);
        return jPanel;
    }

    protected void initCalendar() {
        this.\u0399 = this.getMonthCalendar();
        this.\u03bc = this.\u0399.get(1);
        this.\u03ae = this.\u0399.get(2);
        this.setSelectedDate(null);
        this.\u03b1 = this.getMonthCalendar();
        this.\u03bb = 0;
        this.\u03a9 = 0;
        this.setDisplayedYear(this.\u03b1.get(1));
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setBorder(this.\u03ac);
        this.setBackground(this.\u039a);
        this.setForeground(this.\u0398);
        this.setFont(this.\u03bd);
    }

    protected void initComponents() {
        this.setLayout(new BorderLayout(6, 6));
        this.setBorder(this.\u03ac);
        this.setBackground(this.\u039a);
        this.setForeground(this.\u0398);
        this.setFont(this.\u03bd);
        this.add(this.createYearPanel(), "First");
        this.add(this.createMonthsPanel(), "Center");
        if (this.\u03b7) {
            this.add(this.createButtonPanel(), "Last");
        }
        this.setRequestFocusEnabled(true);
        this.setFocusable(true);
        this.registerKeyStrokes();
        this.applyComponentOrientation(this.getComponentOrientation());
    }

    protected void updateCalendar() {
        if (this.\u0393 == null) {
            this.\u0393 = this.getMonthCalendar();
        } else if (!this.getDateModel().monthInRange(this.\u0393)) {
            if (this.getDateModel().getMaxDate() != null && this.\u0393.getTimeInMillis() > this.getDateModel().getMaxDate().getTimeInMillis()) {
                this.\u0393 = this.getDateModel().getMaxDate();
            } else if (this.getDateModel().getMinDate() != null && this.\u0393.getTimeInMillis() < this.getDateModel().getMinDate().getTimeInMillis()) {
                this.\u0393 = this.getDateModel().getMinDate();
            }
        }
        this.updateYearLabel(this.\u03b8, this.\u0393);
        this.\u0393.set(2, 0);
        this.updateMonthCalendar(this.\u0393);
        for (int i2 = 0; i2 < 12; ++i2) {
            this.\u039b.put(this.\u03b6[i2], this.\u0393.getTime());
            boolean bl = this.isDateSelected(this.\u0393);
            boolean bl2 = this.isToday(this.\u0393);
            this.updateMonthLabel(this.\u03b6[i2], this.\u0393, bl, bl2);
            this.\u0393.roll(2, 1);
            this.updateMonthCalendar(this.\u0393);
        }
        this.invalidate();
    }

    private JPanel \u0101(LayoutManager layoutManager) {
        NullPanel nullPanel = new NullPanel(layoutManager);
        nullPanel.addMouseListener(this);
        return nullPanel;
    }

    public boolean isViewOnly() {
        return this.\u03b4;
    }

    public void setViewOnly(boolean bl) {
        boolean bl2 = this.\u03b4;
        if (bl2 != bl) {
            this.\u03b4 = bl;
            this.firePropertyChange(VIEWONLY_PROPERTY, this.\u03b4, bl2);
            if (this.\u03b9 != null) {
                this.\u03b9.setVisible(!bl);
            }
            if (this.\u03a5 != null) {
                this.\u03a5.setVisible(!bl);
            }
            if (this.\u03ba != null) {
                this.\u03ba.setVisible(!bl);
                this.\u03ba.getParent().setVisible(!bl);
            }
            this.revalidate();
            this.updateCalendar();
        }
    }

    protected void updateDayOfWeekLabel(JComponent jComponent, Calendar calendar) {
        if (jComponent instanceof JLabel) {
            ((JLabel)jComponent).setText(this.\u03be.format(calendar.getTime()));
        } else if (jComponent instanceof JTextComponent) {
            ((JTextComponent)jComponent).setText(this.\u03be.format(calendar.getTime()));
        }
    }

    protected void updateMonthLabel(JComponent jComponent, Calendar calendar, boolean bl, boolean bl2) {
        if (jComponent instanceof JLabel) {
            ((JLabel)jComponent).setText(this.\u03ab.format(calendar.getTime()));
        } else if (jComponent instanceof AbstractButton) {
            ((AbstractButton)jComponent).setText(this.\u03ab.format(calendar.getTime()));
        } else if (jComponent instanceof JTextComponent) {
            ((JTextComponent)jComponent).setText(String.valueOf(calendar.get(2)));
        }
        if (this.isViewOnly()) {
            bl = false;
            bl2 = false;
        }
        if (!this.\u0397.isValidDate(calendar)) {
            jComponent.setEnabled(false);
            jComponent.setBackground(new Color(230, 230, 230));
            if (jComponent instanceof AbstractButton) {
                ((AbstractButton)jComponent).setSelected(false);
            }
        } else {
            jComponent.setEnabled(true);
            if (bl) {
                if (jComponent instanceof AbstractButton) {
                    ((AbstractButton)jComponent).setSelected(bl);
                } else {
                    jComponent.setBackground(this.\u03a6);
                    jComponent.setForeground(this.\u039f);
                }
            } else if (jComponent instanceof AbstractButton) {
                ((AbstractButton)jComponent).setSelected(bl);
            } else {
                jComponent.setBackground(this.\u039a);
                jComponent.setForeground(this.\u039d);
            }
        }
        if (bl2) {
            jComponent.setBorder(this.\u0395);
        } else {
            jComponent.setBorder(this.\u03ad);
        }
    }

    protected void updateYearLabel(JComponent jComponent, Calendar calendar) {
        if (jComponent instanceof JLabel) {
            ((JLabel)jComponent).setText(this.\u0394.format(this.\u0393.getTime()));
        }
    }

    protected JComponent createYearLabel() {
        return new NullLabel("0000");
    }

    private void \u0144() {
        this.\u0141();
        this.\u03b1.add(2, -1);
        if (this.isMonthOutOfRange(this.\u03b1)) {
            this.\u03b1.add(2, 1);
            return;
        }
        this.\u0149();
        this.setDisplayedYear(this.\u03b1.get(1));
    }

    private void \u014a() {
        this.\u0141();
        this.\u03b1.add(2, 1);
        if (this.isMonthOutOfRange(this.\u03b1)) {
            this.\u03b1.add(2, -1);
            return;
        }
        this.\u0149();
        this.setDisplayedYear(this.\u03b1.get(1));
    }

    private void \u0140() {
        this.\u0141();
        this.\u03b1.add(2, -3);
        if (this.isMonthOutOfRange(this.\u03b1)) {
            this.\u03b1.add(2, 3);
            return;
        }
        this.\u0149();
        this.setDisplayedYear(this.\u03b1.get(1));
    }

    private void \u0148() {
        this.\u0141();
        this.\u03b1.add(2, 3);
        if (this.isMonthOutOfRange(this.\u03b1)) {
            this.\u03b1.add(2, -3);
            return;
        }
        this.\u0149();
        this.setDisplayedYear(this.\u03b1.get(1));
    }

    private void \u0142() {
        this.\u0141();
        this.\u03b1.add(1, -1);
        if (this.isMonthOutOfRange(this.\u03b1)) {
            this.\u03b1.add(1, 1);
            return;
        }
        this.\u0149();
        this.setDisplayedYear(this.\u03b1.get(1));
    }

    private void \u0146() {
        this.\u0141();
        this.\u03b1.add(1, 1);
        if (this.isMonthOutOfRange(this.\u03b1)) {
            this.\u03b1.add(1, -1);
            return;
        }
        this.\u0149();
        this.setDisplayedYear(this.\u03b1.get(1));
    }

    private void \u0143() {
        this.\u0141();
        this.\u03b1.set(2, this.\u03b1.getActualMinimum(2));
        if (this.isMonthOutOfRange(this.\u03b1)) {
            this.\u03b1 = this.\u0397.getMinDate();
        }
        this.\u0149();
        this.setDisplayedYear(this.\u03b1.get(1));
    }

    private void \u013f() {
        this.\u0141();
        this.\u03b1.set(2, this.\u03b1.getActualMaximum(2));
        if (this.isMonthOutOfRange(this.\u03b1)) {
            this.\u03b1 = this.\u0397.getMaxDate();
        }
        this.\u0149();
        this.setDisplayedYear(this.\u03b1.get(1));
    }

    protected void registerKeyStrokes() {
        this.registerKeyboardAction(new AbstractAction(){
            private static final long \u0102 = -8247297922204714531L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonthChooserPanel.this.\u0144();
            }
        }, KeyStroke.getKeyStroke(37, 0), 1);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long \u0102 = 3565852826159995687L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonthChooserPanel.this.\u014a();
            }
        }, KeyStroke.getKeyStroke(39, 0), 1);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long \u0102 = -5072751162756155084L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonthChooserPanel.this.\u0140();
            }
        }, KeyStroke.getKeyStroke(38, 0), 1);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long \u0102 = -6103410982451047429L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonthChooserPanel.this.\u0148();
            }
        }, KeyStroke.getKeyStroke(40, 0), 1);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long \u0102 = -8988153852759059530L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonthChooserPanel.this.\u0142();
            }
        }, KeyStroke.getKeyStroke(33, 0), 1);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long \u0102 = 9194558310165823351L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonthChooserPanel.this.\u0146();
            }
        }, KeyStroke.getKeyStroke(34, 0), 1);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long \u0102 = 6900079802750207259L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonthChooserPanel.this.\u0143();
            }
        }, KeyStroke.getKeyStroke(36, 0), 1);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long \u0102 = -1028437496809349369L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonthChooserPanel.this.\u013f();
            }
        }, KeyStroke.getKeyStroke(35, 0), 1);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long \u0102 = 7271057711901809362L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MonthChooserPanel.this.\u0147();
            }
        }, KeyStroke.getKeyStroke(10, 0), 1);
    }

    private void \u0149() {
        int n2 = this.\u03bb;
        int n3 = this.\u03a9;
        this.\u03bb = this.\u03b1.get(1);
        this.\u03a9 = this.\u03b1.get(2);
        this.firePropertyChange("selectedYear", n2, this.\u03bb);
        this.firePropertyChange("selectedMonth", n3, this.\u03a9);
    }

    protected void updateButtons() {
        if (!this.isShowThisMonthButton()) {
            this.\u03ba.removeButton(this.\u03a8);
        } else {
            this.\u03ba.addButton(this.\u03a8);
        }
        if (!this.isShowNoneButton()) {
            this.\u03ba.removeButton(this.\u03a3);
        } else {
            this.\u03ba.addButton(this.\u03a3);
        }
        if (!this.isShowNoneButton() && !this.isShowThisMonthButton()) {
            this.\u03ba.setVisible(false);
        } else {
            this.\u03ba.setVisible(!this.isViewOnly());
        }
    }

    public boolean isShowNoneButton() {
        return this.\u03b7;
    }

    public void setShowNoneButton(boolean bl) {
        this.\u03b7 = bl;
        if (this.\u03ba != null) {
            this.updateButtons();
        }
    }

    public boolean isShowThisMonthButton() {
        return this.\u03b3;
    }

    public void setShowThisMonthButton(boolean bl) {
        this.\u03b3 = bl;
    }

    protected boolean isDateSelected(Calendar calendar) {
        return calendar.get(1) == this.\u03bb && calendar.get(2) == this.\u03a9;
    }

    protected boolean isToday(Calendar calendar) {
        return calendar.get(1) == this.\u03bc && calendar.get(2) == this.\u03ae;
    }

    protected String getResourceString(String string) {
        return E.\u0101(Locale.getDefault()).getString(string);
    }

    protected void initDateFormat(Locale locale) {
        this.\u03ab = new SimpleDateFormat("MMMM", locale);
        this.\u0394 = new SimpleDateFormat("yyyy", locale);
        this.\u03be = new SimpleDateFormat("E", locale);
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.initDateFormat(locale);
        if (this.\u03bf && this.\u039b != null) {
            this.updateCalendar();
        }
    }

    protected boolean isMonthOutOfRange(Calendar calendar) {
        if (this.\u0397.monthInRange(calendar)) {
            return false;
        }
        PortingUtils.notifyUser();
        return true;
    }

    public Calendar getDisplayedCalendar() {
        return this.\u03b1;
    }

    public DateFormat getMonthFormatter() {
        return this.\u03ab;
    }

    public void setMonthFormatter(DateFormat dateFormat) {
        this.\u03ab = dateFormat;
        this.updateCalendar();
    }
}

