/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.AbstractComboBox;
import com.jidesoft.combobox.FontChooserPanel;
import com.jidesoft.combobox.PopupPanel;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class FontComboBox
extends AbstractComboBox {
    public FontComboBox() {
        super(0);
        this.setType(Font.class);
        this.initComponent();
    }

    public FontComboBox(Font font) {
        super(0);
        this.setType(Font.class);
        this.initComponent();
        this.setSelectedFont(font);
    }

    @Override
    public AbstractComboBox.EditorComponent createEditorComponent() {
        if (this.isEditable()) {
            return new AbstractComboBox.DefaultTextFieldEditorComponent(this.getType());
        }
        return new AbstractComboBox.DefaultRendererComponent(this.getType());
    }

    @Override
    public PopupPanel createPopupComponent() {
        PopupPanel popupPanel = this.createFontChooserPanel();
        popupPanel.addPropertyChangeListener("font", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                FontComboBox.this.setSelectedItem(propertyChangeEvent.getNewValue(), false);
                FontComboBox.this.getEditor().selectAll();
            }
        });
        return popupPanel;
    }

    protected PopupPanel createFontChooserPanel() {
        return new FontChooserPanel(this.getDefaultOKAction(), this.getDefaultCancelAction());
    }

    public Font getSelectedFont() {
        this.updateFontFromEditorComponent();
        if (this.getSelectedItem() instanceof Font) {
            return (Font)this.getSelectedItem();
        }
        return null;
    }

    protected void updateFontFromEditorComponent() {
        Object object = this.getEditor().getItem();
        Object object2 = this.getSelectedItem();
        if (object instanceof Font && !object.equals(object2)) {
            this.setSelectedItem(object, false);
        } else if (object == null && object2 != null) {
            this.setSelectedItem(null, false);
        }
    }

    public void setSelectedFont(Font font) {
        this.setSelectedItem(font);
    }

    @Override
    protected boolean isUpdateFromPopupOnFly() {
        return false;
    }
}

