/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.AbstractComboBox;
import com.jidesoft.combobox.ColorChooserPanel;
import com.jidesoft.combobox.PopupPanel;
import com.jidesoft.plaf.LookAndFeelFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class ColorComboBox
extends AbstractComboBox
implements PropertyChangeListener {
    private int \u0188 = 1;
    private boolean \u0182 = true;
    private boolean \u0186 = true;
    private boolean \u0185 = true;
    public static final String PROPERTY_COLOR_MODE = "colorMode";
    public static final String PROPERTY_SELECTED_COLOR = "selectedColor";
    public static final String PROPERTY_COLOR_VALUE_VISIBLE = "colorValueVisible";
    public static final String PROPERTY_COLOR_ICON_VISIBLE = "colorIconVisible";
    private boolean \u0189 = false;
    private boolean \u0187 = true;
    private boolean \u0183 = true;
    private boolean \u0184 = false;

    public ColorComboBox() {
        super(0);
        this.setType(Color.class);
        this.initComponent();
    }

    public ColorComboBox(int n2) {
        super(0);
        this.setType(Color.class);
        this.\u0188 = n2;
        this.initComponent();
    }

    @Override
    public AbstractComboBox.EditorComponent createEditorComponent() {
        if (this.isEditable()) {
            ColorEditorComponent colorEditorComponent = new ColorEditorComponent(Color.class);
            colorEditorComponent.setColorValueVisible(this.isColorValueVisible());
            colorEditorComponent.setColorIconVisible(this.isColorIconVisible());
            return colorEditorComponent;
        }
        ColorRendererComponent colorRendererComponent = new ColorRendererComponent(Color.class);
        colorRendererComponent.setColorValueVisible(this.isColorValueVisible());
        colorRendererComponent.setColorIconVisible(this.isColorIconVisible());
        return colorRendererComponent;
    }

    @Override
    public PopupPanel createPopupComponent() {
        ColorChooserPanel colorChooserPanel = new ColorChooserPanel(this.getColorMode(), this.isAllowMoreColors(), this.isAllowDefaultColor(), this.getLocale());
        colorChooserPanel.addPropertyChangeListener(PROPERTY_SELECTED_COLOR, this);
        if (this._editor != null && this._editor instanceof ColorEditorComponent) {
            Color color = ((ColorEditorComponent)this._editor).\u0134.getColor();
            int n2 = 255;
            if (color != null && this.isUseAlphaColorButtons()) {
                n2 = color.getAlpha();
            }
            colorChooserPanel.\u0104(n2);
        }
        return colorChooserPanel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        PopupPanel popupPanel = this.getPopupPanel();
        if (popupPanel instanceof ColorChooserPanel) {
            Color color;
            Object object = propertyChangeEvent.getNewValue();
            if (!this.isUseAlphaColorButtons() && object instanceof Color && this._editor != null && this._editor instanceof ColorEditorComponent && (color = ((ColorEditorComponent)this._editor).\u0134.getColor()) != null) {
                object = new Color(((Color)object).getRed(), ((Color)object).getGreen(), ((Color)object).getBlue(), color.getAlpha());
            }
            this.getEditor().setItem(object);
        }
    }

    public int getColorMode() {
        return this.\u0188;
    }

    public void setColorMode(int n2) {
        int n3 = this.\u0188;
        if (n3 != n2) {
            this.\u0188 = n2;
            this.firePropertyChange(PROPERTY_COLOR_MODE, n3, this.\u0188);
            this.resetPopup();
        }
    }

    public boolean isAllowDefaultColor() {
        return this.\u0187;
    }

    public void setAllowDefaultColor(boolean bl) {
        this.\u0187 = bl;
        this.resetPopup();
    }

    public boolean isAllowMoreColors() {
        return this.\u0183;
    }

    public void setAllowMoreColors(boolean bl) {
        this.\u0183 = bl;
        this.resetPopup();
    }

    public Color getSelectedColor() {
        this.updateColorFromEditorComponent();
        if (this.getSelectedItem() instanceof Color) {
            return (Color)this.getSelectedItem();
        }
        return null;
    }

    protected void updateColorFromEditorComponent() {
        Object object = this.getEditor().getItem();
        Object object2 = this.getSelectedItem();
        if (object instanceof Color && !object.equals(object2)) {
            this.setSelectedItem(object, false);
        } else if (object == null && object2 != null) {
            this.setSelectedItem(null, false);
        }
    }

    public void setSelectedColor(Color color) {
        this.setSelectedItem(color);
    }

    @Override
    public void setSelectedItem(Object object, boolean bl) throws IllegalArgumentException {
        if (object instanceof Color) {
            if (this.isPopupVisible() && !this.isUseAlphaColorButtons()) {
                int n2 = 255;
                if (this._editor != null && this._editor instanceof ColorEditorComponent && ((ColorEditorComponent)this._editor).\u0134 != null && ((ColorEditorComponent)this._editor).\u0134.getColor() != null) {
                    n2 = ((ColorEditorComponent)this._editor).\u0134.getColor().getAlpha();
                }
                object = new Color(((Color)object).getRed(), ((Color)object).getGreen(), ((Color)object).getBlue(), n2);
            }
        } else if (!this.isInvalidValueAllowed() && object != null) {
            object = null;
            bl = false;
        }
        if (!this.isInvalidValueAllowed() && object == null && !this.isAllowDefaultColor()) {
            throw new IllegalArgumentException("Null color not accepted.");
        }
        super.setSelectedItem(object, bl);
    }

    public boolean isCrossBackGroundStyle() {
        return this.\u0189;
    }

    public void setCrossBackGroundStyle(boolean bl) {
        if (this.\u0189 != bl) {
            this.\u0189 = bl;
            this.repaint();
        }
    }

    public boolean isUseAlphaColorButtons() {
        return this.\u0185;
    }

    public void setUseAlphaColorButtons(boolean bl) {
        if (this.\u0185 != bl) {
            this.\u0185 = bl;
            if (this._editor != null) {
                this._editor.setItem(this.getSelectedColor());
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.isColorValueVisible()) {
            dimension.width += 20;
        }
        return dimension;
    }

    public boolean isColorValueVisible() {
        return this.\u0182;
    }

    public void setColorValueVisible(boolean bl) {
        boolean bl2 = this.\u0182;
        if (bl2 != bl) {
            this.\u0182 = bl;
            if (this.getEditor() instanceof ColorEditorComponent) {
                ((ColorEditorComponent)this.getEditor()).setColorValueVisible(this.isColorValueVisible());
            } else if (this.getEditor() instanceof ColorRendererComponent) {
                ((ColorRendererComponent)this.getEditor()).setColorValueVisible(this.isColorIconVisible());
            }
            this.firePropertyChange(PROPERTY_COLOR_VALUE_VISIBLE, bl2, bl);
        }
    }

    public boolean isColorIconVisible() {
        return this.\u0186;
    }

    public void setColorIconVisible(boolean bl) {
        boolean bl2 = this.\u0186;
        if (bl2 != bl) {
            this.\u0186 = bl;
            if (this.getEditor() instanceof ColorEditorComponent) {
                ((ColorEditorComponent)this.getEditor()).setColorIconVisible(this.isColorIconVisible());
            } else if (this.getEditor() instanceof ColorRendererComponent) {
                ((ColorRendererComponent)this.getEditor()).setColorIconVisible(this.isColorIconVisible());
            }
            this.firePropertyChange(PROPERTY_COLOR_ICON_VISIBLE, bl2, bl);
        }
    }

    public boolean isInvalidValueAllowed() {
        return this.\u0184;
    }

    public void setInvalidValueAllowed(boolean bl) {
        this.\u0184 = bl;
    }

    public class ColorLabel
    extends JComponent {
        private static final int \u0103 = 2;
        private static final double \u0102 = 1.618;
        private Color \u0104;

        public ColorLabel() {
            this.setOpaque(false);
        }

        public Color getColor() {
            return this.\u0104;
        }

        public void setColor(Color color) {
            this.\u0104 = color;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension((int)((double)this.getHeight() * 1.618), this.getHeight());
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            int n2 = this.getHeight();
            int n3 = ColorComboBox.this.isColorValueVisible() ? (int)((double)n2 * 1.618) : this.getWidth();
            graphics.setColor(Color.gray);
            graphics.drawRect(2, 2, n3 - 4, n2 - 4 - 1);
            if (ColorComboBox.this.isCrossBackGroundStyle()) {
                graphics.drawLine(2, 2, n3 - 2, n2 - 2 - 1);
                graphics.drawLine(2, n2 - 2 - 1, n3 - 2, 2);
            } else {
                graphics.setColor(new Color(204, 204, 204));
                int n4 = n3 - 2 - 1;
                int n5 = n2 - 2 - 2;
                int n6 = 4;
                int n7 = 4;
                boolean bl = false;
                for (int i2 = 3; i2 <= n5; i2 += n7) {
                    int n8 = bl ? 3 : 3 + n6;
                    boolean bl2 = bl = !bl;
                    while (n8 <= n4) {
                        graphics.fillRect(n8, i2, Math.min(n6, n4 - n8 + 1), Math.min(n7, n5 - i2 + 1));
                        n8 += 2 * n6;
                    }
                }
            }
            if (this.getColor() != null) {
                graphics.setColor(this.getColor());
                graphics.fillRect(3, 3, n3 - 4 - 1, n2 - 4 - 2);
            }
        }
    }

    public class ColorEditorComponent
    extends AbstractComboBox.DefaultTextFieldEditorComponent {
        private ColorLabel \u0134;

        public ColorEditorComponent(Class<?> clazz) {
            super(clazz);
            this.\u0134 = new ColorLabel();
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() != 2 && SwingUtilities.isLeftMouseButton(mouseEvent) && ColorComboBox.this.isEnabled()) {
                        if (ColorEditorComponent.this._textField.isShowing()) {
                            ColorEditorComponent.this._textField.requestFocus();
                        } else {
                            ColorComboBox.this.requestFocus();
                        }
                        if (!ColorComboBox.this.isEditable() || !ColorComboBox.this.isColorValueVisible()) {
                            ColorComboBox.this.actionPerformed(null);
                        }
                    }
                }
            };
            this.\u0134.addMouseListener(mouseAdapter);
            this._textField.addMouseListener(mouseAdapter);
            this.\u0134.setOpaque(false);
            this.add((Component)this.\u0134, "Before");
        }

        public void updateVisible() {
            if (ColorComboBox.this.isColorIconVisible() && ColorComboBox.this.isColorValueVisible()) {
                this.add((Component)this.\u0134, "Before");
                this.add((Component)this._textField, "Center");
            } else if (ColorComboBox.this.isColorIconVisible() && !ColorComboBox.this.isColorValueVisible()) {
                this.add((Component)this.\u0134, "Center");
                this.remove(this._textField);
            } else if (!ColorComboBox.this.isColorIconVisible() && ColorComboBox.this.isColorValueVisible()) {
                this.add((Component)this._textField, "Center");
                this.remove(this.\u0134);
            } else {
                this.add((Component)this.\u0134, "Before");
                this.add((Component)this._textField, "Center");
            }
            this.revalidate();
        }

        public void setColorValueVisible(boolean bl) {
            this.updateVisible();
        }

        public void setColorIconVisible(boolean bl) {
            this.updateVisible();
        }

        @Override
        public Object getItem() {
            Object object = super.getItem();
            if (object == null && this.isEditable() && ColorComboBox.this.isInvalidValueAllowed()) {
                object = this.getText();
            }
            return object;
        }

        @Override
        public void setItem(Object object) {
            super.setItem(object);
            if (object instanceof Color) {
                this.\u0134.setColor((Color)object);
                this.\u0134.repaint();
                if (ColorComboBox.this._popupPanel != null && ColorComboBox.this._popupPanel instanceof ColorChooserPanel) {
                    int n2 = 255;
                    if (ColorComboBox.this.isUseAlphaColorButtons()) {
                        n2 = ((Color)object).getAlpha();
                    }
                    ((ColorChooserPanel)ColorComboBox.this._popupPanel).\u0104(n2);
                }
            } else if (object == null) {
                this.\u0134.setColor(null);
                this.\u0134.repaint();
                if (ColorComboBox.this._popupPanel != null && ColorComboBox.this._popupPanel instanceof ColorChooserPanel) {
                    ((ColorChooserPanel)ColorComboBox.this._popupPanel).\u0104(255);
                }
            } else if (ColorComboBox.this.isInvalidValueAllowed()) {
                this.\u0134.setColor(null);
                this.\u0134.repaint();
                if (ColorComboBox.this._popupPanel != null && ColorComboBox.this._popupPanel instanceof ColorChooserPanel) {
                    ((ColorChooserPanel)ColorComboBox.this._popupPanel).\u0104(255);
                }
                this._textField.setText(object.toString());
            }
        }

        public ColorLabel getColorLabel() {
            return this.\u0134;
        }
    }

    public class ColorRendererComponent
    extends AbstractComboBox.DefaultRendererComponent {
        private ColorLabel \u0137;

        public ColorRendererComponent(Class<?> clazz) {
            super(clazz);
            if (LookAndFeelFactory.isLnfInstalled("apple.laf.AquaLookAndFeel") && LookAndFeelFactory.isLnfInUse("apple.laf.AquaLookAndFeel") || LookAndFeelFactory.isLnfInstalled("com.apple.laf.AquaLookAndFeel") && LookAndFeelFactory.isLnfInUse("com.apple.laf.AquaLookAndFeel")) {
                this.setLayout(new BorderLayout(0, 0));
            } else {
                this.setLayout(new BorderLayout(2, 2));
            }
            this.\u0137 = new ColorLabel();
            this.\u0137.setOpaque(false);
            this.removeAll();
            this.add((Component)this.\u0137, "Before");
            this.add((Component)this._rendererPane, "Center");
        }

        public void updateVisible() {
            if (ColorComboBox.this.isColorIconVisible() && ColorComboBox.this.isColorValueVisible()) {
                this.add((Component)this.\u0137, "Before");
                this.add((Component)this._rendererPane, "Center");
            } else if (ColorComboBox.this.isColorIconVisible() && !ColorComboBox.this.isColorValueVisible()) {
                this.add((Component)this.\u0137, "Center");
                this.remove(this._rendererPane);
            } else if (!ColorComboBox.this.isColorIconVisible() && ColorComboBox.this.isColorValueVisible()) {
                this.add((Component)this._rendererPane, "Center");
                this.remove(this.\u0137);
            } else {
                this.add((Component)this.\u0137, "Before");
                this.add((Component)this._rendererPane, "Center");
            }
            this.revalidate();
        }

        public void setColorValueVisible(boolean bl) {
            this.updateVisible();
        }

        public void setColorIconVisible(boolean bl) {
            this.updateVisible();
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Object object = ColorComboBox.this.getSelectedItem();
            if (object instanceof Color || object == null) {
                this.\u0137.setColor((Color)object);
            }
        }

        @Override
        protected void paintRendererPane(Graphics graphics, Component component) {
            if (component instanceof JComponent) {
                Insets insets = ((JComponent)component).getInsets();
                if (insets.top == 0 && insets.bottom == 0 && insets.left == 0 && insets.right == 0) {
                    insets = new Insets(1, 1, 1, 1);
                }
                insets.left = (int)((double)insets.left + (this.\u0137.getBounds().getWidth() + (double)((BorderLayout)this.getLayout()).getVgap()));
                this._rendererPane.paintComponent(graphics, component, this, insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom, true);
            } else {
                this._rendererPane.paintComponent(graphics, component, this, 0, 0, this.getWidth(), this.getHeight(), true);
            }
        }
    }
}

