/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.render;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.render.AbstractPieLabelRenderer;
import com.jidesoft.chart.render.DefaultPointLabeler;
import com.jidesoft.chart.render.PieLabelRenderer2D;
import com.jidesoft.chart.render.PointLabeler;
import com.jidesoft.chart.style.ChartStyle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;

public class SimplePieLabelRenderer
extends AbstractPieLabelRenderer
implements PieLabelRenderer2D {
    public static final String PROPERTY_RADIUS_PROPORTION = "Radius Proportion";
    public static final String PROPERTY_POINT_LABELER = "Point Labeler";
    public static final String PROPERTY_OUTLINE_COLOR = "Outline Color";
    public static final String PROPERTY_BACKGROUND = "Background";
    public static final String PROPERTY_FOREGROUND = "Foreground";
    private PropertyChangeSupport \u0107 = new PropertyChangeSupport(this);
    private PointLabeler \u0105 = new DefaultPointLabeler();
    private double \u0106 = 0.85;
    private Color \u0103 = UIManager.getColor("ToolTip.background");
    private Color \u0108 = Color.darkGray;
    private Stroke \u0104 = new BasicStroke(1.0f);

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.\u0107.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.\u0107.removePropertyChangeListener(propertyChangeListener);
    }

    public double getRadiusProportion() {
        return this.\u0106;
    }

    public void setRadiusProportion(double d2) {
        double d3 = this.\u0106;
        this.\u0106 = d2;
        this.\u0107.firePropertyChange(PROPERTY_RADIUS_PROPORTION, d3, d2);
    }

    @Override
    public PointLabeler getPointLabeler() {
        return this.\u0105;
    }

    public Color getBackground() {
        return this.\u0103;
    }

    public void setBackground(Color color) {
        Color color2 = this.\u0103;
        this.\u0103 = color;
        this.\u0107.firePropertyChange(PROPERTY_BACKGROUND, color2, color);
    }

    protected Color createBackground(Chart chart, ChartModel chartModel, Chartable chartable) {
        return this.getBackground();
    }

    public Color getForeground() {
        return this.getLabelColor();
    }

    public void setForeground(Color color) {
        Color color2 = this.getLabelColor();
        this.setLabelColor(color);
        this.\u0107.firePropertyChange(PROPERTY_FOREGROUND, color2, color);
    }

    protected Color createLabelColor(Chart chart, ChartModel chartModel, Chartable chartable) {
        return this.getLabelColor();
    }

    protected Font createLabelFont(Chart chart, ChartModel chartModel, Chartable chartable) {
        return this.getLabelFont();
    }

    public Color getOutlineColor() {
        return this.\u0108;
    }

    public void setOutlineColor(Color color) {
        Color color2 = this.\u0108;
        this.\u0108 = color;
        this.\u0107.firePropertyChange(PROPERTY_OUTLINE_COLOR, color2, color);
    }

    protected Color createOutlineColor(Chart chart, ChartModel chartModel, Chartable chartable) {
        return this.getOutlineColor();
    }

    public Stroke getOutlineStroke() {
        return this.\u0104;
    }

    public void setOutlineStroke(Stroke stroke) {
        this.\u0104 = stroke;
    }

    @Override
    public void setPointLabeler(PointLabeler pointLabeler) {
        PointLabeler pointLabeler2 = this.\u0105;
        this.\u0105 = pointLabeler;
        this.\u0107.firePropertyChange(PROPERTY_POINT_LABELER, pointLabeler2, pointLabeler);
    }

    @Override
    public int getTickLength() {
        return 0;
    }

    @Override
    public void setTickLength(int n2) {
        throw new UnsupportedOperationException("This renderer does not support ticks");
    }

    @Override
    public void renderLabels(Graphics graphics, Chart chart, ChartModel chartModel, Point point, int n2, int n3, int[] nArray, ChartStyle chartStyle) {
        float[] fArray = new float[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            fArray[i2] = nArray[i2];
        }
        this.renderLabels((Graphics2D)graphics, chart, chartModel, (Point2D)point, (double)n2, (double)n3, fArray, chartStyle);
    }

    @Override
    public void renderLabels(Graphics2D graphics2D, Chart chart, ChartModel chartModel, Point2D point2D, double d2, double d3, float[] fArray, ChartStyle chartStyle) {
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        double d4 = point2D.getX();
        double d5 = point2D.getY();
        double d6 = chartStyle.getPieOffsetAngle();
        graphics2D2.setFont(chart.getFont());
        graphics2D2.setStroke(new BasicStroke(1.0f, 0, 1));
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            Chartable chartable = chartModel.getPoint(i2);
            double d7 = d6 + (double)(fArray[i2] / 2.0f);
            double d8 = 0.2;
            ListSelectionModel listSelectionModel = chart.getSelectionsForModel(chartModel);
            boolean bl = listSelectionModel.isSelectedIndex(i2);
            int n2 = bl && chart.isSelectionShowsExplodedSegments() ? (int)(d8 * d2 / 2.0 * Math.cos(Math.toRadians(d7))) : 0;
            int n3 = bl && chart.isSelectionShowsExplodedSegments() ? -((int)(d8 * d3 / 2.0 * Math.sin(Math.toRadians(d7)))) : 0;
            double d9 = d4 + (double)n2 + d2 / 2.0 * this.\u0106 * Math.cos(Math.toRadians(d7));
            double d10 = d5 + (double)n3 - d3 / 2.0 * this.\u0106 * Math.sin(Math.toRadians(d7));
            int n4 = d9 - d4 >= 0.0 ? 1 : -1;
            String string = this.\u0105.getDisplayText(chartable);
            Font font = this.createLabelFont(chart, chartModel, chartable);
            if (font == null) {
                font = graphics2D2.getFont();
            }
            if (string != null) {
                Serializable serializable;
                Color color;
                double d11;
                FontMetrics fontMetrics = graphics2D2.getFontMetrics(font);
                int n5 = fontMetrics.stringWidth(string);
                int n6 = fontMetrics.getAscent();
                int n7 = fontMetrics.getHeight();
                double d12 = d11 = n4 > 0 ? (double)((int)d9) : (double)((int)(d9 - (double)n5));
                if (d11 < 0.0) {
                    d11 = 0.0;
                } else if (d11 + (double)n5 > (double)chart.getXEnd()) {
                    d11 = chart.getXEnd() - n5;
                }
                double d13 = (int)d10 - fontMetrics.getHeight() / 2;
                int n8 = chart.getSize().height;
                int n9 = fontMetrics.getHeight();
                if (d13 < 0.0) {
                    d13 = 0.0;
                } else if (d13 + (double)n9 > (double)n8) {
                    d13 = n8 - n7;
                }
                Rectangle2D.Double double_ = new Rectangle2D.Double(d11, d13, n5 + 2, fontMetrics.getHeight());
                Color color2 = this.createBackground(chart, chartModel, chartable);
                if (color2 != null) {
                    graphics2D2.setColor(color2);
                    graphics2D2.fill(double_);
                }
                if ((color = this.createOutlineColor(chart, chartModel, chartable)) != null) {
                    graphics2D2.setColor(color);
                    graphics2D2.setStroke(this.getOutlineStroke());
                    serializable = new Rectangle2D.Double(((RectangularShape)double_).getX() - 1.0, ((RectangularShape)double_).getY() - 1.0, ((RectangularShape)double_).getWidth() + 1.0, ((RectangularShape)double_).getHeight() + 1.0);
                    graphics2D2.draw((Shape)((Object)serializable));
                }
                if ((serializable = this.createLabelColor(chart, chartModel, chartable)) != null) {
                    graphics2D2.setFont(font);
                    graphics2D2.setColor((Color)serializable);
                    graphics2D2.drawString(string, (float)(((RectangularShape)double_).getX() + 1.0), (float)(((RectangularShape)double_).getY() + (double)n6));
                }
            }
            d6 += (double)fArray[i2];
        }
        graphics2D2.dispose();
    }
}

