/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.model;

import com.jidesoft.chart.annotation.Annotation;
import com.jidesoft.chart.model.AnnotatedChartModel;
import com.jidesoft.chart.model.ChartCategory;
import com.jidesoft.chart.model.ChartModelIterator;
import com.jidesoft.chart.model.ChartModelListener;
import com.jidesoft.chart.model.ChartPoint;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.Highlight;
import com.jidesoft.chart.model.RealPosition;
import com.jidesoft.range.Category;
import com.jidesoft.range.CategoryRange;
import com.jidesoft.range.NumericRange;
import com.jidesoft.range.Positionable;
import com.jidesoft.range.Range;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class TableToChartAdapter
implements AnnotatedChartModel,
TableModelListener {
    public static final String PROPERTY_X_COLUMN = "XColumn";
    public static final String PROPERTY_Y_COLUMN = "YColumn";
    private TableModel \u01d2;
    private String \u01da;
    private List<Annotation> \u01c7 = new ArrayList<Annotation>();
    private final List<ChartModelListener> \u01cd = new CopyOnWriteArrayList<ChartModelListener>();
    private Map<Integer, Highlight> \u01c9 = new HashMap<Integer, Highlight>();
    private PropertyChangeSupport \u01cb = new PropertyChangeSupport(this);
    private Map<Integer, ChartPoint> \u01cf = new HashMap<Integer, ChartPoint>();
    private CategoryRange<?> \u01ca = new CategoryRange();
    private CategoryRange<?> \u01cc = new CategoryRange();
    private boolean \u01d0 = false;
    private double \u01d8;
    private double \u01d6;
    private double \u01d7;
    private double \u01d5;
    private boolean \u01d9 = false;
    private int \u01d4 = 0;
    private int \u01d1 = 1;
    private Integer \u01c8 = null;
    private Integer \u01ce = null;

    public TableToChartAdapter(String string, TableModel tableModel) {
        this.setDelegate(tableModel);
        this.\u01da = string;
    }

    public void setDelegate(TableModel tableModel) {
        if (this.\u01d2 != null) {
            this.\u01d2.removeTableModelListener(this);
        }
        this.\u01d2 = tableModel;
        if (this.\u01d2 != null) {
            this.\u01d2.addTableModelListener(this);
        }
        this.update();
    }

    public TableModel getDelegate() {
        return this.\u01d2;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.\u01cb.addPropertyChangeListener(propertyChangeListener);
    }

    public void addHighlight(int n2, Highlight highlight) {
        this.\u01c9.put(n2, highlight);
        this.\u01cf.remove(n2);
    }

    public void removeHighlight(int n2) {
        this.\u01c9.remove(n2);
        this.\u01cf.remove(n2);
    }

    public void setRowInterval(Integer n2, Integer n3) {
        assert (n3 == null || n2 == null || n3 >= n2);
        this.\u01c8 = n2;
        this.\u01ce = n3;
        this.update();
    }

    public Integer getMinRow() {
        return this.\u01c8;
    }

    public void setMinRow(Integer n2) {
        this.\u01c8 = n2;
        this.update();
    }

    public Integer getMaxRow() {
        return this.\u01ce;
    }

    public void setMaxRow(Integer n2) {
        this.\u01ce = n2;
        this.update();
    }

    @Override
    public String getName() {
        return this.\u01da;
    }

    public int getXColumn() {
        return this.\u01d4;
    }

    public void setXColumn(int n2) {
        int n3 = this.\u01d4;
        this.\u01d4 = n2;
        this.\u01cb.firePropertyChange(PROPERTY_X_COLUMN, n3, n2);
        this.update();
    }

    public int getYColumn() {
        return this.\u01d1;
    }

    public void setYColumn(int n2) {
        int n3 = this.\u01d1;
        this.\u01d1 = n2;
        this.\u01cb.firePropertyChange(PROPERTY_Y_COLUMN, n3, n2);
        this.update();
    }

    private void \u010e() {
        this.\u01d7 = Double.MIN_VALUE;
        this.\u01d8 = Double.MAX_VALUE;
        this.\u01d5 = Double.MIN_VALUE;
        this.\u01d6 = Double.MAX_VALUE;
        int n2 = this.getPointCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Chartable chartable = this.getPoint(i2);
            double d2 = chartable.getX().position();
            double d3 = chartable.getY().position();
            if (d2 < this.\u01d8) {
                this.\u01d8 = d2;
            }
            if (d2 > this.\u01d7) {
                this.\u01d7 = d2;
            }
            if (d3 < this.\u01d6) {
                this.\u01d6 = d3;
            }
            if (!(d3 > this.\u01d5)) continue;
            this.\u01d5 = d3;
        }
        this.\u01d0 = true;
    }

    public Range<?> getXRange() {
        if (!this.\u01d0) {
            this.\u010e();
        }
        if (this.\u01ca.size() == 0.0) {
            return new NumericRange(this.\u01d8, this.\u01d7);
        }
        return this.\u01ca;
    }

    public Range<?> getYRange() {
        if (!this.\u01d0) {
            this.\u010e();
        }
        if (this.\u01cc.size() == 0.0) {
            return new NumericRange(this.\u01d6, this.\u01d5);
        }
        return this.\u01cc;
    }

    @Override
    public Chartable getPoint(int n2) {
        ChartPoint chartPoint = this.\u01cf.get(n2);
        if (chartPoint == null && n2 < this.getPointCount()) {
            Serializable serializable;
            Object object;
            Positionable positionable;
            int n3 = this.\u01c8 == null ? 0 : this.\u01c8;
            Object object2 = this.\u01d2.getValueAt(n3 + n2, this.\u01d4);
            Object object3 = this.\u01d2.getValueAt(n3 + n2, this.\u01d1);
            if (object2 == null) {
                positionable = null;
            } else if (object2 instanceof Number) {
                object = (Number)object2;
                positionable = new RealPosition(((Number)object).doubleValue());
            } else {
                positionable = new ChartCategory<Object>(object2);
                this.\u01ca.add((Category<?>)positionable);
            }
            if (object3 == null) {
                object = null;
            } else if (object3 instanceof Number) {
                serializable = (Number)object3;
                object = new RealPosition(serializable.doubleValue());
            } else {
                object = new ChartCategory<Object>(object3);
                this.\u01cc.add((ChartCategory)object);
            }
            chartPoint = new ChartPoint(positionable, (Positionable)object);
            serializable = this.\u01c9.get(n2);
            if (serializable != null) {
                chartPoint.setHighlight((Highlight)serializable);
            }
            this.\u01cf.put(n2, chartPoint);
        }
        return chartPoint;
    }

    @Override
    public int getPointCount() {
        if (this.\u01d2 == null) {
            return 0;
        }
        if (this.\u01c8 == null || this.\u01ce == null) {
            return this.\u01d2.getRowCount();
        }
        if (this.\u01c8 < 0 || this.\u01ce < 0) {
            return 0;
        }
        return this.\u01ce - this.\u01c8 + 1;
    }

    @Override
    public boolean isCyclical() {
        return this.\u01d9;
    }

    public void setCyclical(boolean bl) {
        this.\u01d9 = bl;
    }

    @Override
    public int getAnnotationCount() {
        return this.\u01c7.size();
    }

    public void clearAnnotations() {
        this.\u01c7.clear();
    }

    @Override
    public Annotation getAnnotation(int n2) {
        return this.\u01c7.get(n2);
    }

    public void addAnnotation(Annotation annotation) {
        this.\u01c7.add(annotation);
    }

    public void removeAnnotation(Annotation annotation) {
        this.\u01c7.remove(annotation);
    }

    @Override
    public boolean isAnnotationsVisible() {
        return true;
    }

    @Override
    public void setAnnotationsVisible(boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addChartModelListener(ChartModelListener chartModelListener) {
        if (!this.\u01cd.contains(chartModelListener)) {
            this.\u01cd.add(chartModelListener);
        }
    }

    @Override
    public void removeChartModelListener(ChartModelListener chartModelListener) {
        this.\u01cd.remove(chartModelListener);
    }

    @Override
    public Iterator<Chartable> iterator() {
        return new ChartModelIterator(this);
    }

    public void update() {
        this.\u01cf.clear();
        this.\u01ca = new CategoryRange();
        this.\u01cc = new CategoryRange();
        this.\u01d0 = false;
        this.fireModelChanged();
    }

    protected void fireModelChanged() {
        for (ChartModelListener chartModelListener : this.\u01cd) {
            chartModelListener.chartModelChanged();
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.update();
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29) {
                System.err.println("The Lm class is invalid, exiting ...");
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4096)) {
            Lm.showInvalidProductMessage(TableToChartAdapter.class.getName(), 4096);
        }
    }
}

