/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.event;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.ChartException;
import com.jidesoft.chart.axis.Axis;
import com.jidesoft.chart.axis.AxisQuantity;
import com.jidesoft.chart.event.ChartCrossHair;
import com.jidesoft.chart.fit.FunctionMap;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ChartValueReporter
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long \u0101 = 1727491356080087902L;
    private Chart \u0107;
    private JLabel \u0109 = new JLabel(" ");
    private Point \u0105 = null;
    private String \u0103 = "x = %.3f, y = %.3f";
    private String \u0102 = "[No point selected]";
    private Double \u0108;
    private Double \u0106;
    private transient ChartModel \u0104 = null;

    public ChartValueReporter(Chart chart) {
        this.\u0107 = chart;
        this.setLayout(new BorderLayout());
        this.add((Component)this.\u0109, "Center");
    }

    public ChartValueReporter(final ChartCrossHair chartCrossHair) {
        assert (chartCrossHair != null);
        this.\u0107 = chartCrossHair.getChart();
        assert (this.\u0107 != null);
        this.setLayout(new BorderLayout());
        this.add((Component)this.\u0109, "Center");
        chartCrossHair.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("Position".equals(propertyChangeEvent.getPropertyName())) {
                    Chartable chartable = chartCrossHair.getPosition();
                    if (chartable == null) {
                        ChartValueReporter.this.clearChartValue();
                    } else {
                        ChartValueReporter.this.updateChartValue(chartable.getX().position(), chartable.getY().position());
                    }
                }
            }
        });
    }

    protected void clearChartValue() {
        this.\u0109.setText(this.\u0102);
        this.\u0108 = null;
        this.\u0106 = null;
        this.\u0105 = null;
    }

    protected void updateChartValue(double d2, double d3) {
        this.\u0108 = d2;
        this.\u0106 = d3;
        Axis axis = this.\u0107.getXAxis();
        Axis axis2 = this.\u0107.getYAxis();
        if (axis.getQuantity() == AxisQuantity.TIME) {
            if (axis2.getQuantity() == AxisQuantity.TIME) {
                this.setText(String.format(this.\u0103, (long)d2, (long)d3));
            } else {
                this.setText(String.format(this.\u0103, (long)d2, d3));
            }
        } else if (axis2.getQuantity() == AxisQuantity.TIME) {
            this.setText(String.format(this.\u0103, d2, (long)d3));
        } else {
            this.setText(String.format(this.\u0103, d2, d3));
        }
    }

    protected void setText(String string) {
        this.\u0109.setText(string);
    }

    public String getFormatString() {
        return this.\u0103;
    }

    public void setFormatString(String string) {
        this.\u0103 = string;
    }

    public String getNoSelectionText() {
        return this.\u0102;
    }

    public void setNoSelectionText(String string) {
        this.\u0102 = string;
    }

    public Double getChartX() {
        return this.\u0108;
    }

    public Double getChartY() {
        return this.\u0106;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.clearChartValue();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.\u0105 = mouseEvent.getPoint();
        this.update();
    }

    public ChartModel getModel() {
        return this.\u0104;
    }

    public void setModel(ChartModel chartModel) {
        this.\u0104 = chartModel;
    }

    public void update() {
        ChartModel chartModel;
        ChartModel chartModel2 = chartModel = this.\u0104 == null ? this.\u0107.nearestModel(this.\u0105) : this.\u0104;
        if (this.\u0105 != null && chartModel != null && chartModel.getPointCount() >= 2) {
            try {
                Point2D point2D = this.\u0107.calculateUserPoint(this.\u0105);
                if (point2D != null) {
                    double d2 = FunctionMap.getYApproximately(chartModel, point2D.getX());
                    double d3 = point2D.getX();
                    this.updateChartValue(d3, d2);
                }
            }
            catch (ChartException chartException) {
                this.clearChartValue();
            }
        }
    }
}

