/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.axis;

import com.jidesoft.chart.axis.NumericTickCalculator;
import com.jidesoft.chart.axis.Tick;
import com.jidesoft.range.Range;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;

public class DefaultNumericTickCalculator
implements NumericTickCalculator {
    public static final String PROPERTY_NUMBER_FORMAT = "numberFormat";
    public static final String PROPERTY_TICK_INTERVALS_BETWEEN_MAJORS = "tickIntervalsBetweenMajors";
    private static final Tick[] \u0117 = new Tick[0];
    private static double \u011a = 4.0;
    private static double \u011c = 10.0;
    private int \u0116 = 5;
    private static final int \u011d = 500;
    private NumberFormat \u0119 = NumberFormat.getInstance();
    private PropertyChangeSupport \u011b = new PropertyChangeSupport(this);
    private int \u0118 = 0;

    public DefaultNumericTickCalculator() {
        this.\u0119.setMinimumFractionDigits(0);
        this.\u0119.setMaximumFractionDigits(2);
        this.\u0119.setGroupingUsed(false);
    }

    public int getMinorTickIntervalBetweenMajors() {
        return this.\u0116;
    }

    public void setMinorTickIntervalBetweenMajors(int n2) {
        int n3 = this.\u0116;
        this.\u0116 = n2;
        this.\u011b.firePropertyChange(PROPERTY_TICK_INTERVALS_BETWEEN_MAJORS, n3, n2);
    }

    @Override
    public NumberFormat getNumberFormat() {
        return this.\u0119;
    }

    @Override
    public void setNumberFormat(NumberFormat numberFormat) {
        this.\u0119 = numberFormat;
        this.\u011b.firePropertyChange(PROPERTY_NUMBER_FORMAT, null, numberFormat);
    }

    @Override
    public void setNumberFormat(String string) {
        DecimalFormat decimalFormat = this.\u0101(string);
        this.setNumberFormat(decimalFormat);
    }

    private DecimalFormat \u0101(String string) {
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance();
        decimalFormat.applyPattern(string);
        return decimalFormat;
    }

    public int getScale() {
        return this.\u0118;
    }

    public void setScale(int n2) {
        this.\u0118 = n2;
    }

    @Override
    public Tick[] calculateTicks(Range<Double> range) {
        double d2;
        double d3;
        if (range == null) {
            return new Tick[0];
        }
        double d4 = range.minimum();
        double d5 = range.maximum();
        if (Double.isNaN(d4) || Double.isNaN(d5)) {
            return \u0117;
        }
        assert (d5 >= d4) : "Max >= Min; max is " + d5 + ", min is " + d4;
        double d6 = d5 - d4;
        if (d6 < 1.0E-8) {
            d6 = 1.0E-8;
        }
        double d7 = Math.log10(d6);
        double d8 = Math.ceil(d7 - 1.0);
        double d9 = Math.pow(10.0, d8);
        assert (\u011c / \u011a >= 2.0);
        do {
            if ((d3 = d6 / d9) > \u011c) {
                d9 *= 2.0;
                continue;
            }
            if (!(d3 < \u011a)) continue;
            d9 /= 2.0;
        } while (d3 < \u011a || d3 > \u011c);
        double d10 = d9 / (double)this.\u0116;
        double d11 = Math.ceil(d4 / d9) * d9;
        ArrayList<Tick> arrayList = new ArrayList<Tick>();
        for (d2 = d11 - d10; d2 > d4 && arrayList.size() < this.\u0116; d2 -= d10) {
            arrayList.add(new Tick(d2));
        }
        d2 = d5 + d10 / 1000.0;
        for (double d12 = d11; d12 < d2 && arrayList.size() < 500; d12 += d9) {
            double d13;
            double d14;
            String string;
            if (d12 == 0.0) {
                d12 = 0.0;
            }
            if ((string = this.\u0119.format(d14 = this.\u0118 == 0 ? d12 : d12 * Math.pow(10.0, this.\u0118))).startsWith("-0")) {
                try {
                    Number number = this.\u0119.parse(string);
                    if (number != null && (double)number.floatValue() == -0.0) {
                        string = string.substring(1);
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            arrayList.add(new Tick(d12, string));
            if (!(d12 <= d5)) continue;
            for (int i2 = 1; i2 < this.\u0116 && !((d13 = d12 + (double)i2 * d10) > d5); ++i2) {
                arrayList.add(new Tick(d13));
            }
        }
        return arrayList.toArray(new Tick[arrayList.size()]);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.\u011b.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.\u011b.removePropertyChangeListener(propertyChangeListener);
    }
}

