/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart;

import com.jidesoft.chart.A;
import com.jidesoft.chart.Chart;
import com.jidesoft.chart.E;
import com.jidesoft.chart.event.ImageChangeEvent;
import com.jidesoft.chart.event.ImageChangeListener;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.chart.util.Pair;
import com.jidesoft.chart.util.SwingExecutor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class MultiImageLazyChartRenderer
implements E<ChartModel> {
    private static ExecutorService \u0135 = Executors.newSingleThreadExecutor();
    private Map<String, SoftReference<Image>> \u0132 = new ConcurrentHashMap<String, SoftReference<Image>>();
    private Map<String, ChartStyle> \u0136 = new ConcurrentHashMap<String, ChartStyle>();
    private List<A> \u012d = new CopyOnWriteArrayList<A>();
    private Point2D \u0133;
    private Point2D \u012f;
    private int \u012e;
    private int \u0134;
    private Image \u012c;
    private Chart \u0130;
    private List<ImageChangeListener> \u0131 = new CopyOnWriteArrayList<ImageChangeListener>();

    public MultiImageLazyChartRenderer(Chart chart) {
        this.\u0130 = chart;
    }

    @Override
    public void addImageChangeListener(ImageChangeListener imageChangeListener) {
        this.\u0131.add(imageChangeListener);
    }

    @Override
    public void removeImageChangeListener(ImageChangeListener imageChangeListener) {
        this.\u0131.remove(imageChangeListener);
    }

    protected void fireImageChange() {
        ImageChangeEvent imageChangeEvent = new ImageChangeEvent(this);
        for (ImageChangeListener imageChangeListener : this.\u0131) {
            imageChangeListener.imageChanged(imageChangeEvent);
        }
    }

    @Override
    public void updateCharts(boolean bl) {
        Pair<Point2D, Point2D> pair = this.\u0101();
        Point2D point2D = pair.getFirst();
        Point2D point2D2 = pair.getSecond();
        ArrayList<ChartModel> arrayList = new ArrayList<ChartModel>(this.\u0130.getModels());
        if (bl) {
            this.\u0132.clear();
            this.\u0136.clear();
        }
        this.cancelDrawing();
        if (arrayList.size() == 0) {
            this.\u0101(point2D, point2D2);
            this.fireImageChange();
        } else {
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                ChartModel chartModel = (ChartModel)arrayList.get(i2);
                this.\u0101(chartModel, i2, false, point2D, point2D2);
            }
        }
    }

    @Override
    public void cancelDrawing() {
        for (A a2 : this.\u012d) {
            if (a2.isCancelled()) continue;
            a2.cancel(true);
        }
    }

    @Override
    public void updateImage(ChartModel chartModel, boolean bl) {
        List<ChartModel> list = this.\u0130.getModels();
        int n2 = list.indexOf(chartModel);
        Pair<Point2D, Point2D> pair = this.\u0101();
        this.\u0101(chartModel, n2, bl, pair.getFirst(), pair.getSecond());
    }

    @Override
    public void removeImage(String string) {
        if (string != null) {
            this.\u0132.remove(string);
            this.\u0136.remove(string);
        }
    }

    @Override
    public void removeImage(ChartModel chartModel) {
        String string = chartModel.getName();
        this.removeImage(string);
    }

    private void \u0101(final ChartModel chartModel, int n2, boolean bl, final Point2D point2D, final Point2D point2D2) {
        boolean bl2;
        final String string = chartModel.getName();
        final ChartStyle chartStyle = this.\u0130.getStyle(chartModel);
        ChartStyle chartStyle2 = this.\u0136.get(string);
        boolean bl3 = bl2 = chartStyle != null && !chartStyle.isPointsVisible() && !chartStyle.isLinesVisible() && !chartStyle.isBarsVisible();
        if (bl2 && bl) {
            this.\u0101(point2D, point2D2);
            this.fireImageChange();
        } else if (bl && chartStyle2 != null && chartStyle2.equals(chartStyle) && this.\u0101(chartModel) != null) {
            this.\u0101(point2D, point2D2);
            this.fireImageChange();
        } else {
            A a2 = new A(this.\u0130, chartModel, n2, this.\u012e, this.\u0134){

                @Override
                protected void \u0101(Image image, Throwable throwable, boolean bl) {
                    if (!bl) {
                        if (image != null) {
                            if (MultiImageLazyChartRenderer.this.\u0130.containsModel(chartModel)) {
                                ChartStyle chartStyle2 = new ChartStyle(chartStyle);
                                MultiImageLazyChartRenderer.this.\u0132.put(string, new SoftReference<Image>(image));
                                MultiImageLazyChartRenderer.this.\u0136.put(string, chartStyle2);
                            }
                            for (A a2 : MultiImageLazyChartRenderer.this.\u012d) {
                                if (a2.isDone()) continue;
                                return;
                            }
                        }
                        MultiImageLazyChartRenderer.this.\u0101(point2D, point2D2);
                        MultiImageLazyChartRenderer.this.fireImageChange();
                    }
                }
            };
            this.\u012d.add(a2);
            \u0135.execute(a2);
        }
    }

    private Pair<Point2D, Point2D> \u0101() {
        int n2 = this.\u0130.getXStart();
        int n3 = this.\u0130.getYEnd();
        int n4 = this.\u0130.getXEnd();
        int n5 = this.\u0130.getYStart();
        this.\u012e = n4 - n2;
        this.\u0134 = n5 - n3;
        Point point = new Point(n2, n3);
        Point point2 = new Point(n4, n5);
        Point2D point2D = this.\u0130.calculateUserPoint(point);
        Point2D point2D2 = this.\u0130.calculateUserPoint(point2);
        return new Pair<Point2D, Point2D>(point2D, point2D2);
    }

    private Image \u0101(ChartModel chartModel) {
        String string = chartModel.getName();
        SoftReference<Image> softReference = this.\u0132.get(string);
        Image image = softReference == null ? null : softReference.get();
        return image;
    }

    private void \u0101(final Point2D point2D, final Point2D point2D2) {
        SwingExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                if (MultiImageLazyChartRenderer.this.\u012e <= 0 || MultiImageLazyChartRenderer.this.\u0134 <= 0) {
                    return;
                }
                MultiImageLazyChartRenderer.this.\u012d.clear();
                MultiImageLazyChartRenderer.this.\u012c = new BufferedImage(MultiImageLazyChartRenderer.this.\u012e, MultiImageLazyChartRenderer.this.\u0134, 2);
                MultiImageLazyChartRenderer.this.\u0133 = point2D;
                MultiImageLazyChartRenderer.this.\u012f = point2D2;
                Graphics2D graphics2D = (Graphics2D)MultiImageLazyChartRenderer.this.\u012c.getGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                for (ChartModel chartModel : MultiImageLazyChartRenderer.this.\u0130.getModels()) {
                    ChartStyle chartStyle = MultiImageLazyChartRenderer.this.\u0130.getStyle(chartModel);
                    Image image = MultiImageLazyChartRenderer.this.\u0101(chartModel);
                    if (image == null || !MultiImageLazyChartRenderer.this.\u0101(chartStyle)) continue;
                    graphics2D.drawImage(image, 0, 0, MultiImageLazyChartRenderer.this.\u012e, MultiImageLazyChartRenderer.this.\u0134, null);
                }
            }
        });
    }

    private boolean \u0101(ChartStyle chartStyle) {
        return chartStyle == null || chartStyle.isPointsVisible() || chartStyle.isLinesVisible() || chartStyle.isBarsVisible();
    }

    @Override
    public void draw(Graphics graphics) {
        if (!this.\u0130.isLazyRendering()) {
            return;
        }
        if (graphics == null) {
            return;
        }
        if (this.\u012c == null) {
            return;
        }
        if (this.\u0133 != null && this.\u012f != null) {
            Point point = this.\u0130.calculatePixelPoint(this.\u0133);
            Point point2 = this.\u0130.calculatePixelPoint(this.\u012f);
            int n2 = point.x;
            int n3 = point.y;
            int n4 = point2.x;
            int n5 = point2.y;
            int n6 = n4 - n2;
            int n7 = Math.abs(n5 - n3);
            assert (n7 >= 0);
            graphics.drawImage(this.\u012c, n2, n3, n6, n7, this.\u0130);
        }
    }
}

