/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.streams.parameters;

import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.ParameterInputValue;
import com.vertica.dsi.dataengine.utilities.ParameterMetadata;
import com.vertica.dsi.exceptions.InputOutputException;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.streams.parameters.AbstractParameterStream;
import java.io.IOException;
import java.io.InputStream;

public class UnicodeParameterStream
extends AbstractParameterStream {
    public UnicodeParameterStream(InputStream inputStream, int n, ParameterMetadata parameterMetadata, int n2) {
        super(inputStream, n, parameterMetadata, n2);
    }

    public ParameterInputValue getNextValue() throws IOException {
        if (this.isClosed()) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_CLOSED.name());
        }
        if (!this.hasMoreData()) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_EMPTY.name());
        }
        int n = this.getNumToFetch();
        byte[] byArray = new byte[n];
        int n2 = this.m_stream.read(byArray);
        this.m_numRead += (long)n2;
        DataWrapper dataWrapper = new DataWrapper();
        if (-1L != this.m_streamLength) {
            if (-1 == n2) {
                throw new InputOutputException(1, JDBCMessageKey.STREAM_UNEXPECTED_END.name());
            }
        } else {
            this.m_lastChunkReadSize = n2;
            if (n2 < byArray.length && -1 != n2) {
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                byArray = byArray2;
                this.m_lastChunkReadSize = -1L;
            } else if (-1 == n2) {
                byArray = new byte[]{};
            }
        }
        try {
            if (12 == this.m_type) {
                dataWrapper.setVarChar(new String(byArray, "UTF-16"));
            } else {
                dataWrapper.setLongVarChar(new String(byArray, "UTF-16"));
            }
        }
        catch (Exception exception) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_CORRUPT_UTF.name());
        }
        return new ParameterInputValue(this.m_parameterMetadata, dataWrapper);
    }
}

