/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.hybrid;

import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.dsi.core.interfaces.IStatement;
import com.vertica.jdbc.common.JDBCObjectFactory;
import com.vertica.jdbc.common.SCallableStatement;
import com.vertica.jdbc.common.SConnection;
import com.vertica.jdbc.common.SConnectionHandle;
import com.vertica.jdbc.common.SDatabaseMetaData;
import com.vertica.jdbc.common.SPooledConnection;
import com.vertica.jdbc.common.SPreparedStatement;
import com.vertica.jdbc.common.SStatement;
import com.vertica.jdbc.jdbc3.S3CallableStatement;
import com.vertica.jdbc.jdbc3.S3Connection;
import com.vertica.jdbc.jdbc3.S3ConnectionHandle;
import com.vertica.jdbc.jdbc3.S3DatabaseMetaData;
import com.vertica.jdbc.jdbc3.S3PooledConnection;
import com.vertica.jdbc.jdbc3.S3PreparedStatement;
import com.vertica.jdbc.jdbc3.S3Statement;
import com.vertica.jdbc.jdbc4.S4CallableStatement;
import com.vertica.jdbc.jdbc4.S4Connection;
import com.vertica.jdbc.jdbc4.S4ConnectionHandle;
import com.vertica.jdbc.jdbc4.S4DatabaseMetaData;
import com.vertica.jdbc.jdbc4.S4PooledConnection;
import com.vertica.jdbc.jdbc4.S4PreparedStatement;
import com.vertica.jdbc.jdbc4.S4Statement;
import com.vertica.support.ILogger;
import com.vertica.utilities.JDBCVersion;
import java.sql.SQLException;
import javax.sql.PooledConnection;

public class HybridJDBCObjectFactory
extends JDBCObjectFactory {
    private JDBCVersion m_jdbcVersion;

    protected HybridJDBCObjectFactory(JDBCVersion jDBCVersion) {
        this.m_jdbcVersion = jDBCVersion;
    }

    protected SCallableStatement createCallableStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        if (JDBCVersion.JDBC3 == this.m_jdbcVersion) {
            return new S3CallableStatement(string, iStatement, sConnection, n);
        }
        return new S4CallableStatement(string, iStatement, sConnection, n);
    }

    protected SConnection createConnection(IConnection iConnection, String string) throws SQLException {
        if (JDBCVersion.JDBC3 == this.m_jdbcVersion) {
            return new S3Connection(iConnection, string);
        }
        return new S4Connection(iConnection, string);
    }

    protected SConnectionHandle createConnectionHandle(SConnection sConnection, SPooledConnection sPooledConnection) throws SQLException {
        if (JDBCVersion.JDBC3 == this.m_jdbcVersion) {
            return new S3ConnectionHandle(sConnection, sPooledConnection);
        }
        return new S4ConnectionHandle(sConnection, sPooledConnection);
    }

    protected SDatabaseMetaData createDatabaseMetaData(SConnection sConnection, ILogger iLogger) throws SQLException {
        if (JDBCVersion.JDBC3 == this.m_jdbcVersion) {
            return new S3DatabaseMetaData(sConnection, iLogger);
        }
        return new S4DatabaseMetaData(sConnection, iLogger);
    }

    protected PooledConnection createPooledConnection(SConnection sConnection) throws SQLException {
        if (JDBCVersion.JDBC3 == this.m_jdbcVersion) {
            return new S3PooledConnection(sConnection);
        }
        return new S4PooledConnection(sConnection);
    }

    protected SPreparedStatement createPreparedStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        if (JDBCVersion.JDBC3 == this.m_jdbcVersion) {
            return new S3PreparedStatement(string, iStatement, sConnection, n);
        }
        return new S4PreparedStatement(string, iStatement, sConnection, n);
    }

    protected SStatement createStatement(IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        if (JDBCVersion.JDBC3 == this.m_jdbcVersion) {
            return new S3Statement(iStatement, sConnection, n);
        }
        return new S4Statement(iStatement, sConnection, n);
    }
}

