/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.script.jacl;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Locale;
import org.apache.batik.script.Interpreter;
import org.apache.batik.script.InterpreterException;
import org.apache.batik.script.jacl.JaclInterpreterFactory;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;

public class JaclInterpreter
implements Interpreter {
    private Interp interpreter = new Interp();

    public JaclInterpreter() {
        try {
            this.interpreter.eval("package require java", 0);
        }
        catch (TclException tclException) {
            // empty catch block
        }
    }

    @Override
    public String[] getMimeTypes() {
        return JaclInterpreterFactory.JACL_MIMETYPES;
    }

    @Override
    public Object evaluate(Reader reader) throws IOException {
        return this.evaluate(reader, "");
    }

    @Override
    public Object evaluate(Reader reader, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[1024];
        int n = 0;
        while ((n = reader.read(cArray)) != -1) {
            stringBuffer.append(cArray, 0, n);
        }
        String string2 = stringBuffer.toString();
        return this.evaluate(string2);
    }

    @Override
    public Object evaluate(String string) {
        try {
            this.interpreter.eval(string, 0);
        }
        catch (TclException tclException) {
            throw new InterpreterException((Exception)((Object)tclException), tclException.getMessage(), -1, -1);
        }
        catch (RuntimeException runtimeException) {
            throw new InterpreterException(runtimeException, runtimeException.getMessage(), -1, -1);
        }
        return this.interpreter.getResult();
    }

    @Override
    public void dispose() {
        this.interpreter.dispose();
    }

    @Override
    public void bindObject(String string, Object object) {
        try {
            this.interpreter.setVar(string, ReflectObject.newInstance((Interp)this.interpreter, object.getClass(), (Object)object), 0);
        }
        catch (TclException tclException) {
            // empty catch block
        }
    }

    @Override
    public void setOut(Writer writer) {
    }

    @Override
    public Locale getLocale() {
        return Locale.getDefault();
    }

    @Override
    public void setLocale(Locale locale) {
    }

    @Override
    public String formatMessage(String string, Object[] objectArray) {
        return null;
    }
}

