/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.annotations;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Form;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PDate;
import org.icepdf.core.pobjects.PObject;
import org.icepdf.core.pobjects.PRectangle;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.StateManager;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.acroform.FieldDictionary;
import org.icepdf.core.pobjects.acroform.FieldDictionaryFactory;
import org.icepdf.core.pobjects.actions.Action;
import org.icepdf.core.pobjects.annotations.Appearance;
import org.icepdf.core.pobjects.annotations.AppearanceState;
import org.icepdf.core.pobjects.annotations.BorderStyle;
import org.icepdf.core.pobjects.annotations.ButtonWidgetAnnotation;
import org.icepdf.core.pobjects.annotations.ChoiceWidgetAnnotation;
import org.icepdf.core.pobjects.annotations.CircleAnnotation;
import org.icepdf.core.pobjects.annotations.FreeTextAnnotation;
import org.icepdf.core.pobjects.annotations.GenericAnnotation;
import org.icepdf.core.pobjects.annotations.InkAnnotation;
import org.icepdf.core.pobjects.annotations.LineAnnotation;
import org.icepdf.core.pobjects.annotations.LinkAnnotation;
import org.icepdf.core.pobjects.annotations.PopupAnnotation;
import org.icepdf.core.pobjects.annotations.SignatureWidgetAnnotation;
import org.icepdf.core.pobjects.annotations.SquareAnnotation;
import org.icepdf.core.pobjects.annotations.TextAnnotation;
import org.icepdf.core.pobjects.annotations.TextMarkupAnnotation;
import org.icepdf.core.pobjects.annotations.TextWidgetAnnotation;
import org.icepdf.core.pobjects.annotations.WidgetAnnotation;
import org.icepdf.core.pobjects.graphics.Shapes;
import org.icepdf.core.pobjects.security.SecurityManager;
import org.icepdf.core.util.GraphicsRenderingHints;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Annotation
extends Dictionary {
    private static final Logger logger = Logger.getLogger(Annotation.class.toString());
    public static final Name TYPE = new Name("Annot");
    public static final Name RESOURCES_VALUE = new Name("Resources");
    public static final Name BBOX_VALUE = new Name("BBox");
    public static final Name PARENT_KEY = new Name("Parent");
    public static final Name TYPE_VALUE = new Name("Annot");
    public static final Name SUBTYPE_LINK = new Name("Link");
    public static final Name SUBTYPE_LINE = new Name("Line");
    public static final Name SUBTYPE_SQUARE = new Name("Square");
    public static final Name SUBTYPE_CIRCLE = new Name("Circle");
    public static final Name SUBTYPE_POLYGON = new Name("Polygon");
    public static final Name SUBTYPE_POLYLINE = new Name("PolyLine");
    public static final Name SUBTYPE_HIGHLIGHT = new Name("Highlight");
    public static final Name SUBTYPE_POPUP = new Name("Popup");
    public static final Name SUBTYPE_WIDGET = new Name("Widget");
    public static final Name SUBTYPE_INK = new Name("Ink");
    public static final Name SUBTYPE_FREE_TEXT = new Name("FreeText");
    public static final Name SUBTYPE_TEXT = new Name("Text");
    public static final int FLAG_INVISIBLE = 1;
    public static final int FLAG_HIDDEN = 2;
    public static final int FLAG_PRINT = 4;
    public static final int FLAG_NO_ZOOM = 8;
    public static final int FLAG_NO_ROTATE = 16;
    public static final int FLAG_NO_VIEW = 32;
    public static final int FLAG_READ_ONLY = 64;
    public static final int FLAG_LOCKED = 128;
    public static final int FLAG_TOGGLE_NO_VIEW = 256;
    public static final int FLAG_LOCKED_CONTENTS = 512;
    public static final Name BORDER_STYLE_KEY = new Name("BS");
    public static final Name RECTANGLE_KEY = new Name("Rect");
    public static final Name ACTION_KEY = new Name("A");
    public static final Name PARENT_PAGE_KEY = new Name("P");
    public static final Name BORDER_KEY = new Name("Border");
    public static final Name FLAG_KEY = new Name("F");
    public static final Name COLOR_KEY = new Name("C");
    public static final Name APPEARANCE_STREAM_KEY = new Name("AP");
    public static final Name APPEARANCE_STATE_KEY = new Name("AS");
    public static final Name APPEARANCE_STREAM_NORMAL_KEY = new Name("N");
    public static final Name APPEARANCE_STREAM_ROLLOVER_KEY = new Name("R");
    public static final Name APPEARANCE_STREAM_DOWN_KEY = new Name("D");
    public static final Name CONTENTS_KEY = new Name("Contents");
    public static final Name M_KEY = new Name("M");
    public static final Name NM_KEY = new Name("NM");
    public static final int BORDER_HORIZONTAL_CORNER_RADIUS = 0;
    public static final int BORDER_VERTICAL_CORNER_RADIUS = 1;
    public static final int BORDER_WIDTH = 2;
    public static final int BORDER_DASH = 3;
    public static final int VISIBLE_RECTANGLE = 1;
    public static final int INVISIBLE_RECTANGLE = 0;
    protected PropertyChangeSupport changeSupport;
    protected static boolean compressAppearanceStream = true;
    protected HashMap<Name, Appearance> appearances = new HashMap(3);
    protected Name currentAppearance;
    protected PDate modifiedDate;
    protected boolean hasBlendingMode;
    protected SecurityManager securityManager;
    protected Name subtype;
    protected String content;
    protected BorderStyle borderStyle;
    protected List border;
    protected Color color;
    protected Rectangle2D.Float userSpaceRectangle;
    protected boolean canDrawBorder;

    public Annotation(Library l, HashMap h) {
        super(l, h);
    }

    public static Annotation buildAnnotation(Library library, HashMap hashMap) {
        Annotation annot = null;
        Name subType = (Name)hashMap.get(SUBTYPE_KEY);
        if (subType != null) {
            if (subType.equals(SUBTYPE_LINK)) {
                annot = new LinkAnnotation(library, hashMap);
            } else if (subType.equals(TextMarkupAnnotation.SUBTYPE_HIGHLIGHT) || subType.equals(TextMarkupAnnotation.SUBTYPE_STRIKE_OUT) || subType.equals(TextMarkupAnnotation.SUBTYPE_UNDERLINE)) {
                annot = new TextMarkupAnnotation(library, hashMap);
            } else if (subType.equals(SUBTYPE_LINE)) {
                annot = new LineAnnotation(library, hashMap);
            } else if (subType.equals(SUBTYPE_SQUARE)) {
                annot = new SquareAnnotation(library, hashMap);
            } else if (subType.equals(SUBTYPE_CIRCLE)) {
                annot = new CircleAnnotation(library, hashMap);
            } else if (subType.equals(SUBTYPE_INK)) {
                annot = new InkAnnotation(library, hashMap);
            } else if (subType.equals(SUBTYPE_FREE_TEXT)) {
                annot = new FreeTextAnnotation(library, hashMap);
            } else if (subType.equals(SUBTYPE_TEXT)) {
                annot = new TextAnnotation(library, hashMap);
            } else if (subType.equals(SUBTYPE_POPUP)) {
                annot = new PopupAnnotation(library, hashMap);
            } else if (subType.equals(SUBTYPE_WIDGET)) {
                Object tmp;
                Name fieldType = library.getName(hashMap, FieldDictionary.FT_KEY);
                if (fieldType == null && (tmp = library.getObject(hashMap, FieldDictionary.PARENT_KEY)) instanceof HashMap) {
                    fieldType = library.getName((HashMap)tmp, FieldDictionary.FT_KEY);
                }
                annot = FieldDictionaryFactory.TYPE_BUTTON.equals(fieldType) ? new ButtonWidgetAnnotation(library, hashMap) : (FieldDictionaryFactory.TYPE_CHOICE.equals(fieldType) ? new ChoiceWidgetAnnotation(library, hashMap) : (FieldDictionaryFactory.TYPE_TEXT.equals(fieldType) ? new TextWidgetAnnotation(library, hashMap) : (FieldDictionaryFactory.TYPE_SIGNATURE.equals(fieldType) ? new SignatureWidgetAnnotation(library, hashMap) : new WidgetAnnotation(library, hashMap))));
            }
        }
        if (annot == null) {
            annot = new GenericAnnotation(library, hashMap);
        }
        return annot;
    }

    public static void setCompressAppearanceStream(boolean compressAppearanceStream) {
        Annotation.compressAppearanceStream = compressAppearanceStream;
    }

    @Override
    public void init() throws InterruptedException {
        Object AP;
        Object value;
        super.init();
        this.subtype = (Name)this.getObject(SUBTYPE_KEY);
        this.securityManager = this.library.getSecurityManager();
        this.content = this.getContents();
        this.canDrawBorder = !SUBTYPE_LINE.equals(this.subtype) && !SUBTYPE_CIRCLE.equals(this.subtype) && !SUBTYPE_SQUARE.equals(this.subtype) && !SUBTYPE_POLYGON.equals(this.subtype) && !SUBTYPE_POLYLINE.equals(this.subtype);
        Object BS = this.getObject(BORDER_STYLE_KEY);
        if (BS != null) {
            if (BS instanceof HashMap) {
                this.borderStyle = new BorderStyle(this.library, (HashMap)BS);
            } else if (BS instanceof BorderStyle) {
                this.borderStyle = (BorderStyle)BS;
            }
        } else {
            HashMap<Name, Object> borderMap = new HashMap<Name, Object>();
            Object borderObject = this.getObject(BORDER_KEY);
            if (borderObject != null && borderObject instanceof List) {
                this.border = (List)borderObject;
                if (this.border.size() == 3) {
                    borderMap.put(BorderStyle.BORDER_STYLE_KEY, BorderStyle.BORDER_STYLE_SOLID);
                    borderMap.put(BorderStyle.BORDER_WIDTH_KEY, this.border.get(2));
                } else if (this.border.size() == 4) {
                    borderMap.put(BorderStyle.BORDER_STYLE_KEY, BorderStyle.BORDER_STYLE_DASHED);
                    borderMap.put(BorderStyle.BORDER_WIDTH_KEY, this.border.get(2));
                    borderMap.put(BorderStyle.BORDER_DASH_KEY, Arrays.asList(Float.valueOf(3.0f)));
                }
            } else {
                borderMap.put(BorderStyle.BORDER_STYLE_KEY, BorderStyle.BORDER_STYLE_SOLID);
                borderMap.put(BorderStyle.BORDER_WIDTH_KEY, Float.valueOf(0.0f));
            }
            this.borderStyle = new BorderStyle(this.library, borderMap);
            this.entries.put(BORDER_STYLE_KEY, this.borderStyle);
        }
        this.color = null;
        List C = (List)this.getObject(COLOR_KEY);
        if (C != null && C.size() >= 3) {
            float red = ((Number)C.get(0)).floatValue();
            float green = ((Number)C.get(1)).floatValue();
            float blue = ((Number)C.get(2)).floatValue();
            red = Math.max(0.0f, Math.min(1.0f, red));
            green = Math.max(0.0f, Math.min(1.0f, green));
            blue = Math.max(0.0f, Math.min(1.0f, blue));
            this.color = new Color(red, green, blue);
        }
        if ((value = this.library.getObject(this.entries, M_KEY)) != null && value instanceof StringObject) {
            StringObject text = (StringObject)value;
            this.modifiedDate = new PDate(this.securityManager, text.getDecryptedLiteralString(this.securityManager));
        }
        if ((AP = this.getObject(APPEARANCE_STREAM_KEY)) instanceof HashMap) {
            Object appearance;
            this.currentAppearance = APPEARANCE_STREAM_NORMAL_KEY;
            Name appearanceState = (Name)this.getObject(APPEARANCE_STATE_KEY);
            if (appearanceState == null) {
                appearanceState = APPEARANCE_STREAM_NORMAL_KEY;
            }
            if ((appearance = this.library.getObject((HashMap)AP, APPEARANCE_STREAM_NORMAL_KEY)) != null) {
                this.appearances.put(APPEARANCE_STREAM_NORMAL_KEY, this.parseAppearanceDictionary(APPEARANCE_STREAM_NORMAL_KEY, appearance));
                this.appearances.get(APPEARANCE_STREAM_NORMAL_KEY).setSelectedName(appearanceState);
            }
            if ((appearance = this.library.getObject((HashMap)AP, APPEARANCE_STREAM_ROLLOVER_KEY)) != null) {
                this.appearances.put(APPEARANCE_STREAM_ROLLOVER_KEY, this.parseAppearanceDictionary(APPEARANCE_STREAM_ROLLOVER_KEY, appearance));
            }
            if ((appearance = this.library.getObject((HashMap)AP, APPEARANCE_STREAM_DOWN_KEY)) != null) {
                this.appearances.put(APPEARANCE_STREAM_DOWN_KEY, this.parseAppearanceDictionary(APPEARANCE_STREAM_DOWN_KEY, appearance));
            }
        } else {
            Appearance newAppearance = new Appearance();
            HashMap<Name, Rectangle2D.Float> appearanceDictionary = new HashMap<Name, Rectangle2D.Float>();
            Rectangle2D.Float rect = this.getUserSpaceRectangle();
            if (rect == null) {
                throw new IllegalStateException("Annotation is missing required /rect value");
            }
            if (((RectangularShape)rect).getWidth() <= 1.0) {
                ((Rectangle2D)rect).setRect(((RectangularShape)rect).getX(), ((RectangularShape)rect).getY(), 15.0, ((RectangularShape)rect).getHeight());
            }
            if (((RectangularShape)rect).getHeight() <= 1.0) {
                ((Rectangle2D)rect).setRect(((RectangularShape)rect).getX(), ((RectangularShape)rect).getY(), ((RectangularShape)rect).getWidth(), 15.0);
            }
            appearanceDictionary.put(BBOX_VALUE, new Rectangle2D.Float(0.0f, 0.0f, (float)((RectangularShape)rect).getWidth(), (float)((RectangularShape)rect).getHeight()));
            newAppearance.addAppearance(APPEARANCE_STREAM_NORMAL_KEY, new AppearanceState(this.library, appearanceDictionary));
            this.appearances.put(APPEARANCE_STREAM_NORMAL_KEY, newAppearance);
            this.currentAppearance = APPEARANCE_STREAM_NORMAL_KEY;
        }
    }

    private Appearance parseAppearanceDictionary(Name appearanceDictionary, Object streamOrDictionary) {
        Appearance appearance = new Appearance();
        if (streamOrDictionary instanceof HashMap) {
            HashMap dictionary = (HashMap)streamOrDictionary;
            Set keys = dictionary.keySet();
            for (Object key : keys) {
                Object value = dictionary.get(key);
                if (!(value instanceof Reference)) continue;
                appearance.addAppearance((Name)key, new AppearanceState(this.library, dictionary, this.library.getObject((Reference)value)));
            }
        } else {
            appearance.addAppearance(appearanceDictionary, new AppearanceState(this.library, this.entries, streamOrDictionary));
        }
        return appearance;
    }

    public Name getSubType() {
        return this.library.getName(this.entries, SUBTYPE_KEY);
    }

    public void setSubtype(Name subtype) {
        this.entries.put(SUBTYPE_KEY, subtype);
        this.subtype = subtype;
    }

    public Rectangle2D.Float getUserSpaceRectangle() {
        Object tmp;
        if (this.userSpaceRectangle == null && (tmp = this.getObject(RECTANGLE_KEY)) instanceof List) {
            this.userSpaceRectangle = this.library.getRectangle(this.entries, RECTANGLE_KEY);
        }
        return this.userSpaceRectangle;
    }

    public void setUserSpaceRectangle(Rectangle2D.Float rect) {
        if (this.userSpaceRectangle != null && rect != null) {
            this.userSpaceRectangle = new Rectangle2D.Float(rect.x, rect.y, rect.width, rect.height);
            this.entries.put(RECTANGLE_KEY, PRectangle.getPRectangleVector(this.userSpaceRectangle));
        }
    }

    public void setBBox(Rectangle bbox) {
        Appearance appearance = this.appearances.get(this.currentAppearance);
        AppearanceState appearanceState = appearance.getSelectedAppearanceState();
        appearanceState.setBbox(bbox);
    }

    public Rectangle2D getBbox() {
        AppearanceState appearanceState;
        Appearance appearance = this.appearances.get(this.currentAppearance);
        if (appearance != null && (appearanceState = appearance.getSelectedAppearanceState()) != null) {
            return appearanceState.getBbox();
        }
        return null;
    }

    protected void resetNullAppearanceStream() {
        if (!this.hasAppearanceStream()) {
            Object tmp = this.getObject(RECTANGLE_KEY);
            RectangularShape rectangle = null;
            if (tmp instanceof List) {
                rectangle = this.library.getRectangle(this.entries, RECTANGLE_KEY);
            }
            if (rectangle != null) {
                this.setBBox(rectangle.getBounds());
            }
            this.resetAppearanceStream(new AffineTransform());
        }
    }

    public Name getCurrentAppearance() {
        return this.currentAppearance;
    }

    public void setCurrentAppearance(Name currentAppearance) {
        this.currentAppearance = currentAppearance;
    }

    public BasicStroke getBorderStyleStroke() {
        if (this.borderStyle.isStyleDashed()) {
            return new BasicStroke(this.borderStyle.getStrokeWidth(), 0, 0, this.borderStyle.getStrokeWidth() * 2.0f, this.borderStyle.getDashArray(), 0.0f);
        }
        return new BasicStroke(this.borderStyle.getStrokeWidth());
    }

    public Action getAction() {
        Object tmp = this.library.getDictionary(this.entries, ACTION_KEY);
        if (tmp != null) {
            Action action = Action.buildAction(this.library, (HashMap)tmp);
            if (action != null && this.library.isReference(this.entries, ACTION_KEY)) {
                action.setPObjectReference(this.library.getReference(this.entries, ACTION_KEY));
            }
            return action;
        }
        tmp = this.getObject(ACTION_KEY);
        if (tmp != null && tmp instanceof Action) {
            return (Action)tmp;
        }
        return null;
    }

    public Action addAction(Action action) {
        boolean isDestKey;
        if (action.getPObjectReference() == null) {
            logger.severe("Addition of action was rejected null Object reference " + action);
            return null;
        }
        StateManager stateManager = this.library.getStateManager();
        boolean bl = isDestKey = this.getObject(LinkAnnotation.DESTINATION_KEY) != null;
        if (this.getObject(ACTION_KEY) != null) {
            boolean isReference = this.library.isReference(this.getEntries(), ACTION_KEY);
            if (isReference) {
                Action oldAction = (Action)action.getObject(ACTION_KEY);
                oldAction.setDeleted(true);
                stateManager.addChange(new PObject(oldAction, oldAction.getPObjectReference()));
            } else {
                this.getEntries().remove(ACTION_KEY);
                stateManager.addChange(new PObject(this, this.getPObjectReference()));
            }
        }
        this.getEntries().put(ACTION_KEY, action.getPObjectReference());
        stateManager.addChange(new PObject(this, this.getPObjectReference()));
        if (isDestKey && this instanceof LinkAnnotation) {
            this.getEntries().remove(LinkAnnotation.DESTINATION_KEY);
            stateManager.addChange(new PObject(this, this.getPObjectReference()));
        }
        action.setNew(true);
        stateManager.addChange(new PObject(action, action.getPObjectReference()));
        this.library.addObject(action, action.getPObjectReference());
        return action;
    }

    public boolean deleteAction(Action action) {
        Action currentAction;
        StateManager stateManager = this.library.getStateManager();
        if (this.getObject(ACTION_KEY) != null && (currentAction = this.getAction()).similar(action)) {
            this.getEntries().remove(ACTION_KEY);
            currentAction.setDeleted(true);
            stateManager.addChange(new PObject(currentAction, currentAction.getPObjectReference()));
            stateManager.addChange(new PObject(this, this.getPObjectReference()));
            return true;
        }
        return false;
    }

    public boolean updateAction(Action action) {
        StateManager stateManager = this.library.getStateManager();
        if (this.getObject(ACTION_KEY) != null) {
            Action currentAction = this.getAction();
            if (!currentAction.similar(action)) {
                stateManager.addChange(new PObject(action, action.getPObjectReference()));
                currentAction.setDeleted(true);
                stateManager.addChange(new PObject(currentAction, currentAction.getPObjectReference()));
            }
            this.getEntries().put(ACTION_KEY, action.getPObjectReference());
            stateManager.addChange(new PObject(action, action.getPObjectReference()));
            return true;
        }
        return false;
    }

    public boolean allowScreenNormalMode() {
        return this.allowScreenOrPrintRenderingOrInteraction() && !this.getFlagNoView();
    }

    public boolean allowScreenRolloverMode() {
        return this.allowScreenOrPrintRenderingOrInteraction() && (!this.getFlagNoView() || this.getFlagToggleNoView()) && !this.getFlagReadOnly();
    }

    public boolean allowScreenDownMode() {
        return this.allowScreenOrPrintRenderingOrInteraction() && (!this.getFlagNoView() || this.getFlagToggleNoView()) && !this.getFlagReadOnly();
    }

    public boolean allowPrintNormalMode() {
        return this.allowScreenOrPrintRenderingOrInteraction() && this.getFlagPrint();
    }

    public boolean allowAlterProperties() {
        return !this.getFlagLocked();
    }

    public BorderStyle getBorderStyle() {
        return this.borderStyle;
    }

    public void setBorderStyle(BorderStyle borderStyle) {
        this.borderStyle = borderStyle;
        this.entries.put(BORDER_STYLE_KEY, this.borderStyle);
    }

    public List<Number> getBorder() {
        return this.border;
    }

    public Object getParentAnnotation() {
        Annotation parent = null;
        Object ob = this.getObject(PARENT_KEY);
        if (ob instanceof Reference) {
            ob = this.library.getObject((Reference)ob);
        }
        if (ob instanceof Annotation) {
            parent = (Annotation)ob;
        } else if (ob instanceof HashMap) {
            return FieldDictionaryFactory.buildField(this.library, (HashMap)ob);
        }
        return parent;
    }

    public Page getPage() {
        Object annot;
        Page page = (Page)this.getObject(PARENT_PAGE_KEY);
        if (page == null && (annot = this.getParentAnnotation()) instanceof Annotation) {
            page = ((Annotation)annot).getPage();
        }
        return page;
    }

    public int getBorderType() {
        if (this.borderStyle != null ? this.borderStyle.getStrokeWidth() > 0.0f : this.border != null && this.border.size() >= 3 && ((Number)this.border.get(2)).floatValue() > 0.0f) {
            return 1;
        }
        return 0;
    }

    public Name getLineStyle() {
        if (this.borderStyle != null) {
            return this.borderStyle.getBorderStyle();
        }
        if (this.border != null) {
            if (this.border.size() > 3) {
                return BorderStyle.BORDER_STYLE_DASHED;
            }
            if (((Number)this.border.get(2)).floatValue() > 1.0f) {
                return BorderStyle.BORDER_STYLE_SOLID;
            }
        }
        return BorderStyle.BORDER_STYLE_SOLID;
    }

    public float getLineThickness() {
        if (this.borderStyle != null) {
            return this.borderStyle.getStrokeWidth();
        }
        if (this.border != null && this.border.size() >= 3) {
            return ((Number)this.border.get(2)).floatValue();
        }
        return 0.0f;
    }

    public boolean isBorder() {
        List borderProps;
        boolean borderWidth = false;
        Object border = this.getObject(BORDER_KEY);
        if (border != null && border instanceof List && (borderProps = (List)border).size() == 3) {
            borderWidth = ((Number)borderProps.get(2)).floatValue() > 0.0f;
        }
        return this.getBorderStyle() != null && this.getBorderStyle().getStrokeWidth() > 0.0f || borderWidth;
    }

    public void render(Graphics2D origG, int renderHintType, float totalRotation, float userZoom, boolean tabSelected) {
        double scaleY;
        boolean noZoom;
        if (!this.allowScreenOrPrintRenderingOrInteraction()) {
            return;
        }
        if (renderHintType == 1 && !this.allowScreenNormalMode()) {
            return;
        }
        if (renderHintType == 2 && !this.allowPrintNormalMode()) {
            return;
        }
        Rectangle2D.Float rect = this.getUserSpaceRectangle();
        AffineTransform oldAT = origG.getTransform();
        Shape oldClip = origG.getClip();
        Composite oldComp = origG.getComposite();
        Graphics2D g = origG;
        AffineTransform at = new AffineTransform(oldAT);
        at.translate(rect.getMinX(), rect.getMinY());
        boolean noRotate = this.getFlagNoRotate();
        if (noRotate) {
            float unRotation;
            for (unRotation = -totalRotation; unRotation < 0.0f; unRotation += 360.0f) {
            }
            while (unRotation > 360.0f) {
                unRotation -= 360.0f;
            }
            if (unRotation == -0.0f) {
                unRotation = 0.0f;
            }
            if ((double)unRotation != 0.0) {
                double radians = Math.toRadians(unRotation);
                AffineTransform rotationTransform = AffineTransform.getRotateInstance(radians);
                Point2D.Double origTopLeftCorner = new Point2D.Double(0.0, Math.abs(rect.getHeight()));
                Point2D rotatedTopLeftCorner = rotationTransform.transform(origTopLeftCorner, null);
                at.translate(origTopLeftCorner.getX() - rotatedTopLeftCorner.getX(), origTopLeftCorner.getY() - rotatedTopLeftCorner.getY());
                at.rotate(radians);
            }
        }
        if ((noZoom = this.getFlagNoZoom()) && (scaleY = Math.abs(at.getScaleY())) != 1.0) {
            double scaleX = Math.abs(at.getScaleX());
            double rectHeight = Math.abs(rect.getHeight());
            double resizedY = rectHeight * ((scaleY - 1.0) / scaleY);
            at.translate(0.0, resizedY);
            at.scale(1.0 / scaleX, 1.0 / scaleY);
        }
        GraphicsRenderingHints grh = GraphicsRenderingHints.getDefault();
        g.setRenderingHints(grh.getRenderingHints(renderHintType));
        g.setTransform(at);
        Shape preAppearanceStreamClip = g.getClip();
        g.clip(this.deriveDrawingRectangle());
        this.renderAppearanceStream(g);
        g.setTransform(at);
        g.setClip(preAppearanceStreamClip);
        if (tabSelected) {
            this.renderBorderTabSelected(g);
        } else {
            this.renderBorder(g);
        }
        g.setTransform(oldAT);
        g.setClip(oldClip);
        g.setComposite(oldComp);
    }

    protected void renderAppearanceStream(Graphics2D g) {
        Appearance appearance = this.appearances.get(this.currentAppearance);
        if (appearance == null) {
            return;
        }
        AppearanceState appearanceState = appearance.getSelectedAppearanceState();
        if (appearanceState.getShapes() != null) {
            AffineTransform matrix = appearanceState.getMatrix();
            Rectangle2D bbox = appearanceState.getBbox();
            Rectangle2D tBbox = matrix.createTransformedShape(bbox).getBounds2D();
            Rectangle2D.Float rect = this.getUserSpaceRectangle();
            AffineTransform tAs = AffineTransform.getScaleInstance(((RectangularShape)rect).getWidth() / tBbox.getWidth(), ((RectangularShape)rect).getHeight() / tBbox.getHeight());
            if (rect.getMinX() == tBbox.getMinX() && rect.getMinY() == tBbox.getMinY()) {
                tAs.setToTranslation(-((RectangularShape)rect).getX(), -((RectangularShape)rect).getY());
            } else {
                tAs.setToTranslation(-tBbox.getX(), -tBbox.getY());
            }
            tAs.concatenate(matrix);
            g.transform(tAs);
            AffineTransform preAf = g.getTransform();
            try {
                appearanceState.getShapes().paint(g);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.fine("Page Annotation Painting interrupted.");
            }
            g.setTransform(preAf);
        }
    }

    protected void renderBorder(Graphics2D g) {
        BorderStyle bs;
        if (this instanceof SquareAnnotation || this instanceof CircleAnnotation || this instanceof LineAnnotation || this instanceof FreeTextAnnotation || this instanceof InkAnnotation) {
            return;
        }
        Color borderColor = this.getColor();
        if (borderColor != null) {
            g.setColor(borderColor);
        }
        if ((bs = this.getBorderStyle()) != null) {
            float width = bs.getStrokeWidth();
            if (width > 0.0f && borderColor != null && this.canDrawBorder) {
                Rectangle2D.Float jrect = this.deriveBorderDrawingRectangle(width);
                if (bs.isStyleSolid()) {
                    g.setStroke(new BasicStroke(width));
                    g.draw(jrect);
                } else if (bs.isStyleDashed()) {
                    BasicStroke stroke = new BasicStroke(width, 0, 0, width * 2.0f, bs.getDashArray(), 0.0f);
                    g.setStroke(stroke);
                    g.draw(jrect);
                } else if (bs.isStyleBeveled()) {
                    jrect = this.deriveDrawingRectangle();
                    g.setStroke(new BasicStroke(1.0f));
                    g.setColor(BorderStyle.LIGHT);
                    Line2D.Double line = new Line2D.Double(jrect.getMinX() + 1.0, jrect.getMaxY() - 1.0, jrect.getMaxX() - 2.0, jrect.getMaxY() - 1.0);
                    g.draw(line);
                    line = new Line2D.Double(jrect.getMinX() + 1.0, jrect.getMinY() + 2.0, jrect.getMinX() + 1.0, jrect.getMaxY() - 1.0);
                    g.draw(line);
                    g.setColor(BorderStyle.LIGHTEST);
                    line = new Line2D.Double(jrect.getMinX() + 2.0, jrect.getMaxY() - 2.0, jrect.getMaxX() - 3.0, jrect.getMaxY() - 2.0);
                    g.draw(line);
                    line = new Line2D.Double(jrect.getMinX() + 2.0, jrect.getMinY() + 3.0, jrect.getMinX() + 2.0, jrect.getMaxY() - 2.0);
                    g.draw(line);
                    g.setColor(BorderStyle.DARK);
                    line = new Line2D.Double(jrect.getMinX() + 2.0, jrect.getMinY() + 2.0, jrect.getMaxX() - 2.0, jrect.getMinY() + 2.0);
                    g.draw(line);
                    line = new Line2D.Double(jrect.getMaxX() - 2.0, jrect.getMinY() + 2.0, jrect.getMaxX() - 2.0, jrect.getMaxY() - 2.0);
                    g.draw(line);
                    g.setColor(BorderStyle.DARKEST);
                    line = new Line2D.Double(jrect.getMinX() + 1.0, jrect.getMinY() + 1.0, jrect.getMaxX() - 1.0, jrect.getMinY() + 1.0);
                    g.draw(line);
                    line = new Line2D.Double(jrect.getMaxX() - 1.0, jrect.getMinY() + 1.0, jrect.getMaxX() - 1.0, jrect.getMaxY() - 1.0);
                    g.draw(line);
                } else if (bs.isStyleInset()) {
                    jrect = this.deriveDrawingRectangle();
                    g.setStroke(new BasicStroke(1.0f));
                    g.setColor(BorderStyle.DARK);
                    Line2D.Double line = new Line2D.Double(jrect.getMinX() + 1.0, jrect.getMaxY() - 1.0, jrect.getMaxX() - 1.0, jrect.getMaxY() - 1.0);
                    g.draw(line);
                    line = new Line2D.Double(jrect.getMinX() + 1.0, jrect.getMinY() + 1.0, jrect.getMinX() + 1.0, jrect.getMaxY() - 1.0);
                    g.draw(line);
                    g.setColor(BorderStyle.DARKEST);
                    line = new Line2D.Double(jrect.getMinX() + 2.0, jrect.getMaxY() - 2.0, jrect.getMaxX() - 2.0, jrect.getMaxY() - 2.0);
                    g.draw(line);
                    line = new Line2D.Double(jrect.getMinX() + 2.0, jrect.getMinY() + 2.0, jrect.getMinX() + 2.0, jrect.getMaxY() - 2.0);
                    g.draw(line);
                    g.setColor(BorderStyle.LIGHTEST);
                    line = new Line2D.Double(jrect.getMinX() + 3.0, jrect.getMinY() + 2.0, jrect.getMaxX() - 2.0, jrect.getMinY() + 2.0);
                    g.draw(line);
                    line = new Line2D.Double(jrect.getMaxX() - 2.0, jrect.getMinY() + 2.0, jrect.getMaxX() - 2.0, jrect.getMaxY() - 3.0);
                    g.draw(line);
                    g.setColor(BorderStyle.LIGHT);
                    line = new Line2D.Double(jrect.getMinX() + 2.0, jrect.getMinY() + 1.0, jrect.getMaxX() - 1.0, jrect.getMinY() + 1.0);
                    g.draw(line);
                    line = new Line2D.Double(jrect.getMaxX() - 1.0, jrect.getMinY() + 1.0, jrect.getMaxX() - 1.0, jrect.getMaxY() - 2.0);
                    g.draw(line);
                } else if (bs.isStyleUnderline()) {
                    g.setStroke(new BasicStroke(width));
                    Line2D.Double line = new Line2D.Double(jrect.getMinX(), jrect.getMinY(), jrect.getMaxX(), jrect.getMinY());
                    g.draw(line);
                }
            }
        } else {
            List borderVector = (List)this.getObject(BORDER_KEY);
            if (borderVector != null) {
                if (borderColor != null) {
                    float horizRadius = 0.0f;
                    float vertRadius = 0.0f;
                    float width = 1.0f;
                    float[] dashArray = null;
                    if (borderVector.size() >= 1) {
                        horizRadius = ((Number)borderVector.get(0)).floatValue();
                    }
                    if (borderVector.size() >= 2) {
                        vertRadius = ((Number)borderVector.get(1)).floatValue();
                    }
                    if (borderVector.size() >= 3) {
                        width = ((Number)borderVector.get(2)).floatValue();
                    }
                    if (borderVector.size() >= 4) {
                        Object dashObj = borderVector.get(3);
                        if (dashObj instanceof Number) {
                            width = 0.0f;
                        } else if (dashObj instanceof List) {
                            List dashVector = (List)borderVector.get(3);
                            int sz = dashVector.size();
                            dashArray = new float[sz];
                            for (int i = 0; i < sz; ++i) {
                                Number num = (Number)dashVector.get(i);
                                dashArray[i] = num.floatValue();
                            }
                        }
                    }
                    if (width > 0.0f) {
                        Rectangle2D.Float jrect = this.deriveBorderDrawingRectangle(width);
                        RoundRectangle2D.Double roundRect = new RoundRectangle2D.Double(jrect.getX(), jrect.getY(), jrect.getWidth(), jrect.getHeight(), horizRadius, vertRadius);
                        BasicStroke stroke = new BasicStroke(width, 0, 0, 10.0f, dashArray, 0.0f);
                        g.setStroke(stroke);
                        g.draw(roundRect);
                    }
                }
            } else if (borderColor != null && SUBTYPE_LINK.equals(this.subtype)) {
                float width = 1.0f;
                Rectangle2D.Float jrect = this.deriveBorderDrawingRectangle(width);
                g.setStroke(new BasicStroke(width));
                g.draw(jrect);
            }
        }
    }

    protected void renderBorderTabSelected(Graphics2D g) {
        float width = 1.0f;
        Rectangle2D.Float jrect = this.deriveBorderDrawingRectangle(width);
        g.setColor(Color.black);
        float[] dashArray = new float[]{2.0f};
        BasicStroke stroke = new BasicStroke(width, 0, 0, 10.0f, dashArray, 0.0f);
        g.setStroke(stroke);
        g.draw(jrect);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = new Color(color.getRGB());
        float[] compArray = new float[3];
        this.color.getColorComponents(compArray);
        ArrayList<Float> colorValues = new ArrayList<Float>(compArray.length);
        for (float comp : compArray) {
            colorValues.add(Float.valueOf(comp));
        }
        this.entries.put(COLOR_KEY, colorValues);
    }

    protected Rectangle2D.Float deriveDrawingRectangle() {
        Rectangle2D.Float origRect = this.getUserSpaceRectangle();
        Rectangle2D.Float jrect = new Rectangle2D.Float(origRect.x, origRect.y, origRect.width, origRect.height);
        jrect.x = 0.0f;
        jrect.y = 0.0f;
        return jrect;
    }

    private Rectangle2D.Float deriveBorderDrawingRectangle(float borderWidth) {
        Rectangle2D.Float jrect = this.deriveDrawingRectangle();
        float halfBorderWidth = borderWidth / 2.0f;
        double minX = jrect.getMinX() + (double)halfBorderWidth;
        double minY = jrect.getMinY() + (double)halfBorderWidth;
        double maxX = jrect.getMaxX() - (double)halfBorderWidth;
        double maxY = jrect.getMaxY() - (double)halfBorderWidth;
        jrect.setFrameFromDiagonal(minX, minY, maxX, maxY);
        return jrect;
    }

    public boolean allowScreenOrPrintRenderingOrInteraction() {
        if (this.getFlagHidden()) {
            return false;
        }
        return !this.getFlagInvisible() || !this.isSupportedAnnotationType();
    }

    protected boolean isSupportedAnnotationType() {
        return true;
    }

    public boolean getFlagInvisible() {
        return (this.getInt(FLAG_KEY) & 1) != 0;
    }

    public boolean getFlagHidden() {
        return (this.getInt(FLAG_KEY) & 2) != 0;
    }

    public boolean getFlagPrint() {
        return (this.getInt(FLAG_KEY) & 4) != 0;
    }

    public boolean getFlagNoZoom() {
        return (this.getInt(FLAG_KEY) & 8) != 0;
    }

    public boolean getFlagNoRotate() {
        return (this.getInt(FLAG_KEY) & 0x10) != 0;
    }

    public boolean getFlagNoView() {
        return (this.getInt(FLAG_KEY) & 0x20) != 0;
    }

    public boolean getFlagReadOnly() {
        return (this.getInt(FLAG_KEY) & 0x40) != 0;
    }

    public boolean getFlagToggleNoView() {
        return (this.getInt(FLAG_KEY) & 0x100) != 0;
    }

    public boolean getFlagLockedContents() {
        return (this.getInt(FLAG_KEY) & 0x200) != 0;
    }

    public boolean getFlagLocked() {
        return (this.getInt(FLAG_KEY) & 0x80) != 0;
    }

    public void setFlag(int flagKey, boolean enable) {
        boolean isEnabled;
        int flag = this.getInt(FLAG_KEY);
        boolean bl = isEnabled = (flag & flagKey) != 0;
        if (!enable && isEnabled) {
            this.entries.put(FLAG_KEY, flag ^= flagKey);
        } else if (enable && !isEnabled) {
            this.entries.put(FLAG_KEY, flag |= flagKey);
        }
    }

    public void setModifiedDate(String modifiedDate) {
        this.setString(M_KEY, modifiedDate);
        this.modifiedDate = new PDate(this.securityManager, modifiedDate);
    }

    public boolean hasAppearanceStream() {
        return this.library.getObject(this.entries, APPEARANCE_STREAM_KEY) != null;
    }

    public Stream getAppearanceStream() {
        Object AP = this.getObject(APPEARANCE_STREAM_KEY);
        if (AP instanceof HashMap) {
            Object AS;
            Object N = this.library.getObject((HashMap)AP, APPEARANCE_STREAM_NORMAL_KEY);
            if (N instanceof HashMap && (AS = this.getObject(APPEARANCE_STATE_KEY)) != null && AS instanceof Name) {
                N = this.library.getObject((HashMap)N, (Name)AS);
            }
            if (N instanceof Stream) {
                return (Stream)N;
            }
        }
        return null;
    }

    public Form getOrGenerateAppearanceForm() {
        StateManager stateManager = this.library.getStateManager();
        Form form = null;
        if (this.hasAppearanceStream()) {
            Stream stream = this.getAppearanceStream();
            if (stream instanceof Form) {
                form = (Form)stream;
            } else if (stream != null) {
                form = new Form(this.library, (HashMap)stream.getEntries(), null);
                form.setPObjectReference(stream.getPObjectReference());
                form.setRawBytes(stream.getDecodedStreamBytes());
                form.init();
            }
        } else {
            HashMap<Name, Name> formEntries = new HashMap<Name, Name>();
            formEntries.put(Form.TYPE_KEY, Form.TYPE_VALUE);
            formEntries.put(Form.SUBTYPE_KEY, Form.SUB_TYPE_VALUE);
            form = new Form(this.library, (HashMap)formEntries, null);
            form.setPObjectReference(stateManager.getNewReferencNumber());
            this.library.addObject(form, form.getPObjectReference());
        }
        return form;
    }

    public Form updateAppearanceStream(Shapes shapes, Rectangle2D bbox, AffineTransform matrix, byte[] rawBytes) {
        Form form;
        StateManager stateManager = this.library.getStateManager();
        if (this.hasAppearanceStream() && this.getAppearanceStream() instanceof Form) {
            form = (Form)this.getAppearanceStream();
        } else {
            HashMap<Name, Name> formEntries = new HashMap<Name, Name>();
            formEntries.put(Form.TYPE_KEY, Form.TYPE_VALUE);
            formEntries.put(Form.SUBTYPE_KEY, Form.SUB_TYPE_VALUE);
            form = new Form(this.library, (HashMap)formEntries, null);
            form.setPObjectReference(stateManager.getNewReferencNumber());
            this.library.addObject(form, form.getPObjectReference());
        }
        if (form != null && shapes != null && rawBytes != null) {
            Rectangle2D.Float formBbox = new Rectangle2D.Float((float)bbox.getX(), (float)bbox.getY(), (float)bbox.getWidth(), (float)bbox.getHeight());
            form.setAppearance(shapes, matrix, formBbox);
            stateManager.addChange(new PObject(form, form.getPObjectReference()));
            form.setRawBytes(rawBytes);
            HashMap<Name, Reference> appearanceRefs = new HashMap<Name, Reference>();
            appearanceRefs.put(APPEARANCE_STREAM_NORMAL_KEY, form.getPObjectReference());
            this.entries.put(APPEARANCE_STREAM_KEY, appearanceRefs);
            if (compressAppearanceStream) {
                form.getEntries().put(Stream.FILTER_KEY, new Name("FlateDecode"));
            } else {
                form.getEntries().remove(Stream.FILTER_KEY);
            }
        }
        return form;
    }

    public String getContents() {
        this.content = this.getString(CONTENTS_KEY);
        return this.content;
    }

    public void setContents(String content) {
        this.content = this.setString(CONTENTS_KEY, content);
    }

    protected String getString(Name key) {
        Object value = this.library.getObject(this.entries, key);
        if (value instanceof StringObject) {
            StringObject text = (StringObject)value;
            return Utils.convertStringObject(this.library, text);
        }
        if (value instanceof String) {
            return (String)value;
        }
        return "";
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ANNOTATION= {");
        Set keys = this.entries.keySet();
        for (Object key : keys) {
            Object value = this.entries.get(key);
            sb.append(key.toString());
            sb.append('=');
            if (value == null) {
                sb.append("null");
            } else if (value instanceof StringObject) {
                sb.append(((StringObject)value).getDecryptedLiteralString(this.library.getSecurityManager()));
            } else {
                sb.append(value.toString());
            }
            sb.append(',');
        }
        sb.append('}');
        if (this.getPObjectReference() != null) {
            sb.append("  ");
            sb.append(this.getPObjectReference());
        }
        for (int i = sb.length() - 1; i >= 0; --i) {
            if (sb.charAt(i) >= ' ' && sb.charAt(i) < '\u007f') continue;
            sb.deleteCharAt(i);
        }
        return sb.toString();
    }

    public void syncBBoxToUserSpaceRectangle(Rectangle2D bbox) {
        Appearance appearance = this.appearances.get(this.currentAppearance);
        AppearanceState appearanceState = appearance.getSelectedAppearanceState();
        Rectangle2D tBbox = appearanceState.getMatrix().createTransformedShape(bbox).getBounds2D();
        this.setUserSpaceRectangle(new Rectangle2D.Float((float)tBbox.getX(), (float)tBbox.getY(), (float)tBbox.getWidth(), (float)tBbox.getHeight()));
    }

    public abstract void resetAppearanceStream(double var1, double var3, AffineTransform var5);

    public void resetAppearanceStream(AffineTransform pageSpace) {
        this.resetAppearanceStream(0.0, 0.0, pageSpace);
    }

    public Shapes getShapes() {
        AppearanceState appearanceState;
        Appearance appearance = this.appearances.get(this.currentAppearance);
        if (appearance != null && (appearanceState = appearance.getSelectedAppearanceState()) != null) {
            return appearanceState.getShapes();
        }
        return null;
    }

    public HashMap<Name, Appearance> getAppearances() {
        return this.appearances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        Annotation annotation = this;
        synchronized (annotation) {
            if (listener == null) {
                return;
            }
            if (this.changeSupport == null) {
                this.changeSupport = new PropertyChangeSupport(this);
            }
            this.changeSupport.addPropertyChangeListener(listener);
        }
    }
}

