/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.hana.model;

import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.gis.DBGeometryDimension;
import org.jkiss.dbeaver.model.gis.GisAttribute;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class HANATableColumn
extends GenericTableColumn
implements DBPNamedObject2,
GisAttribute {
    private static final int FLAT_EARTH_SRID_START = 1000000000;
    private static final int FLAT_EARTH_SRID_END = 2000000000;
    private GeometryInfo geometryInfo;

    public HANATableColumn(GenericTable table) {
        super((GenericTableBase)table);
    }

    public HANATableColumn(GenericTableBase table, String columnName, String typeName, int valueType, int sourceType, int ordinalPosition, long columnSize, long charLength, Integer scale, Integer precision, int radix, boolean notNull, String remarks, String defaultValue, boolean autoIncrement, boolean autoGenerated) throws DBException {
        super(table, columnName, typeName, valueType, sourceType, ordinalPosition, columnSize, charLength, scale, precision, radix, notNull, remarks, defaultValue, autoIncrement, autoGenerated);
    }

    public int getAttributeGeometrySRID(DBRProgressMonitor monitor) throws DBCException {
        if (this.geometryInfo == null) {
            this.readGeometryInfo(monitor);
        }
        if (this.geometryInfo != null) {
            return this.geometryInfo.srid;
        }
        return -1;
    }

    @NotNull
    public DBGeometryDimension getAttributeGeometryDimension(DBRProgressMonitor monitor) throws DBCException {
        if (this.geometryInfo == null) {
            this.readGeometryInfo(monitor);
        }
        if (this.geometryInfo != null) {
            switch (this.geometryInfo.dimension) {
                case 3: {
                    return DBGeometryDimension.XYZ;
                }
                case 4: {
                    return DBGeometryDimension.XYZM;
                }
            }
            return DBGeometryDimension.XY;
        }
        return DBGeometryDimension.XY;
    }

    @Nullable
    public String getAttributeGeometryType(DBRProgressMonitor monitor) throws DBCException {
        if (this.geometryInfo == null) {
            this.readGeometryInfo(monitor);
        }
        if (this.geometryInfo != null) {
            return this.geometryInfo.type;
        }
        return null;
    }

    private void readGeometryInfo(DBRProgressMonitor monitor) throws DBCException {
        if (this.geometryInfo != null) {
            return;
        }
        GeometryInfo gi = new GeometryInfo();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load table inheritance info");){
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT SRS_ID, DATA_TYPE_NAME, COORD_DIMENSION FROM SYS.ST_GEOMETRY_COLUMNS WHERE SCHEMA_NAME=? AND TABLE_NAME=? AND COLUMN_NAME=?");){
                    dbStat.setString(1, ((GenericTableBase)this.getTable()).getSchema().getName());
                    dbStat.setString(2, ((GenericTableBase)this.getTable()).getName());
                    dbStat.setString(3, this.getName());
                    Throwable throwable3 = null;
                    Object var10_16 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        if (dbResult.next()) {
                            gi.srid = dbResult.getInt(1);
                            if (1000000000 <= gi.srid && gi.srid < 2000000000) {
                                gi.srid -= 1000000000;
                            }
                            gi.type = dbResult.getString(2);
                            gi.dimension = dbResult.getInt(3);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBCException("Error reading geometry info", (Throwable)e);
        }
        this.geometryInfo = gi;
    }

    private static class GeometryInfo {
        private String type;
        private int srid = -1;
        private int dimension = -1;

        private GeometryInfo() {
        }
    }
}

