/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.hana.model;

import java.sql.SQLException;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.hana.model.HANASchema;
import org.jkiss.dbeaver.ext.hana.model.HANATableColumn;
import org.jkiss.dbeaver.model.DBPObjectStatistics;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.ByteNumberFormat;

public class HANATable
extends GenericTable
implements DBPObjectStatistics {
    private long tableSize = -1L;

    public HANATable(GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        super(container, tableName, tableType, dbResult);
    }

    @Nullable
    public List<? extends HANATableColumn> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return super.getAttributes(monitor);
    }

    public HANATableColumn getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return (HANATableColumn)super.getAttribute(monitor, attributeName);
    }

    public boolean hasStatistics() {
        return this.tableSize != -1L;
    }

    public long getStatObjectSize() {
        return this.tableSize;
    }

    void fetchStatistics(JDBCResultSet dbResult) throws SQLException {
        this.tableSize = dbResult.getLong("DISK_SIZE");
    }

    @Property(category="Statistics", formatter=ByteNumberFormat.class)
    public Long getTableSize(DBRProgressMonitor monitor) throws DBException {
        if (this.tableSize == -1L) {
            ((HANASchema)this.getSchema()).collectObjectStatistics(monitor, false, false);
        }
        return this.tableSize;
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.tableSize != -1L) {
            this.tableSize = -1L;
            ((HANASchema)this.getSchema()).resetStatistics();
        }
        return super.refreshObject(monitor);
    }

    @Nullable
    public DBPPropertySource getStatProperties() {
        return null;
    }
}

