/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Base64;
import org.eclipse.osgi.util.NLS;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPAuthInfo;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ByteNumberFormat;
import org.jkiss.utils.CommonUtils;

public class WebUtils {
    private static final Log log = Log.getLog(WebUtils.class);
    private static final int MAX_RETRY_COUNT = 10;

    @NotNull
    public static URLConnection openConnection(String urlString, String referrer) throws IOException {
        return WebUtils.openConnection(urlString, null, referrer);
    }

    @NotNull
    public static URLConnection openConnection(String urlString, DBPAuthInfo authInfo, String referrer) throws IOException {
        return WebUtils.openURLConnection(urlString, authInfo, referrer, 1);
    }

    @NotNull
    private static URLConnection openURLConnection(String urlString, DBPAuthInfo authInfo, String referrer, int retryNumber) throws IOException {
        int responseCode;
        HttpURLConnection httpConnection;
        if (retryNumber > 10) {
            throw new IOException("Too many redirects (" + retryNumber + ")");
        }
        if (retryNumber > 1) {
            log.debug("Retry number " + retryNumber);
        }
        log.debug("Open [" + urlString + "]");
        DBPPreferenceStore prefs = DBWorkbench.getPlatform().getPreferenceStore();
        String proxyHost = prefs.getString("ui.proxy.host");
        Proxy proxy = null;
        if (!CommonUtils.isEmpty((String)proxyHost)) {
            int proxyPort = prefs.getInt("ui.proxy.port");
            if (proxyPort <= 0) {
                log.warn("Invalid proxy port: " + proxyPort);
            }
            proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
        }
        URL url = new URL(urlString);
        URLConnection connection = proxy == null ? url.openConnection() : url.openConnection(proxy);
        connection.setReadTimeout(10000);
        connection.setConnectTimeout(10000);
        if (connection instanceof HttpURLConnection) {
            httpConnection = (HttpURLConnection)connection;
            httpConnection.setRequestMethod("GET");
            httpConnection.setInstanceFollowRedirects(true);
            HttpURLConnection.setFollowRedirects(true);
            connection.setRequestProperty("User-Agent", GeneralUtils.getProductTitle());
            if (referrer != null) {
                connection.setRequestProperty("X-Referrer", referrer);
            }
            if (authInfo != null && !CommonUtils.isEmpty((String)authInfo.getUserName())) {
                String encoded = Base64.getEncoder().encodeToString((String.valueOf(authInfo.getUserName()) + ":" + CommonUtils.notEmpty((String)authInfo.getUserPassword())).getBytes(GeneralUtils.UTF8_CHARSET));
                connection.setRequestProperty("Authorization", "Basic " + encoded);
            }
        }
        connection.connect();
        if (connection instanceof HttpURLConnection && (responseCode = (httpConnection = (HttpURLConnection)connection).getResponseCode()) != 200) {
            if (responseCode == 302 || responseCode == 301 || responseCode == 303) {
                String newUrl = connection.getHeaderField("Location");
                return WebUtils.openURLConnection(newUrl, authInfo, referrer, retryNumber + 1);
            }
            throw new IOException("Can't open '" + urlString + "': " + httpConnection.getResponseMessage());
        }
        return connection;
    }

    public static long downloadRemoteFile(@NotNull DBRProgressMonitor monitor, String taskName, String externalURL, Path localFile, DBPAuthInfo authInfo) throws IOException, InterruptedException {
        Throwable throwable = null;
        Object var6_7 = null;
        try (OutputStream outputStream = Files.newOutputStream(localFile, new OpenOption[0]);){
            return WebUtils.downloadRemoteFile(monitor, taskName, externalURL, outputStream, authInfo);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long downloadRemoteFile(@NotNull DBRProgressMonitor monitor, String taskName, String externalURL, OutputStream outputStream, DBPAuthInfo authInfo) throws IOException, InterruptedException {
        URLConnection connection = WebUtils.openConnection(externalURL, authInfo, null);
        int contentLength = connection.getContentLength();
        byte[] buffer = new byte[8192];
        ByteNumberFormat numberFormat = new ByteNumberFormat(ByteNumberFormat.BinaryPrefix.ISO);
        monitor.beginTask(String.valueOf(taskName) + " - " + externalURL, contentLength);
        try {
            Throwable throwable = null;
            Object var10_11 = null;
            try {
                long l;
                int count;
                InputStream inputStream = connection.getInputStream();
                try {
                    long startTime = System.currentTimeMillis();
                    long updateTime = 0L;
                    long totalRead = 0L;
                    while (true) {
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        long currentTime = System.currentTimeMillis();
                        if (currentTime - updateTime > 1000L) {
                            if (contentLength >= 0) {
                                long elapsedTime = currentTime - startTime;
                                long totalDownloadTime = (long)((double)(elapsedTime * (long)contentLength) / (double)totalRead);
                                long remainingDownloadTime = totalDownloadTime - elapsedTime;
                                updateTime = currentTime;
                                monitor.subTask(NLS.bind((String)ModelMessages.dialog_web_download_text_known, (Object[])new Object[]{numberFormat.format(totalRead), numberFormat.format(contentLength), String.format("%.2f%%", (double)totalRead / (double)contentLength * 100.0), remainingDownloadTime > 0L ? RuntimeUtils.formatExecutionTime(remainingDownloadTime) : "-"}));
                            } else {
                                monitor.subTask(NLS.bind((String)ModelMessages.dialog_web_download_text_unknown, (Object)numberFormat.format(totalRead)));
                            }
                        }
                        if ((count = inputStream.read(buffer)) > 0) break block16;
                        l = totalRead;
                        if (inputStream == null) return l;
                        break;
                    }
                }
                catch (Throwable throwable2) {
                    if (inputStream == null) throw throwable2;
                    inputStream.close();
                    throw throwable2;
                }
                {
                    block16: {
                        inputStream.close();
                        return l;
                    }
                    outputStream.write(buffer, 0, count);
                    monitor.worked(count);
                    totalRead += (long)count;
                    continue;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        finally {
            monitor.done();
        }
    }
}

