/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.runtime.features;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.features.DBRFeature;
import org.jkiss.utils.CommonUtils;

public class DBRFeatureRegistry {
    private static final Log log = Log.getLog(DBRFeatureRegistry.class);
    private final Map<String, DBRFeature> allFeatures = new HashMap<String, DBRFeature>();
    private final Map<String, DBRFeature> commandFeatures = new HashMap<String, DBRFeature>();
    private static DBRFeatureRegistry instance = null;

    public static synchronized DBRFeatureRegistry getInstance() {
        if (instance == null) {
            instance = new DBRFeatureRegistry();
        }
        return instance;
    }

    private DBRFeatureRegistry() {
    }

    public synchronized void registerFeatures(Class<?> theClass) {
        Field[] fieldArray = theClass.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if ((field.getModifiers() & 8) != 0 && field.getType() == DBRFeature.class) {
                try {
                    DBRFeature feature = (DBRFeature)field.get(null);
                    if (feature != null) {
                        String id = String.valueOf(theClass.getSimpleName()) + "." + field.getName();
                        feature.setId(id);
                        this.allFeatures.put(id, feature);
                        if (!CommonUtils.isEmpty((String)feature.getCommandId())) {
                            this.commandFeatures.put(feature.getCommandId(), feature);
                        }
                    }
                }
                catch (Exception e) {
                    log.error(e);
                }
            }
            ++n2;
        }
    }

    public List<DBRFeature> getAllFeatures() {
        return new ArrayList<DBRFeature>(this.allFeatures.values());
    }

    public DBRFeature findCommandFeature(String commandId) {
        return this.commandFeatures.get(commandId);
    }

    public static void useFeature(DBRFeature feature, Map<String, Object> parameters) {
        QMUtils.getDefaultHandler().handleFeatureUsage(feature, parameters);
    }
}

