/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.sql.SQLConstants;
import org.jkiss.dbeaver.model.sql.SQLDataTypeConverter;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLStateType;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;

public class JDBCSQLDialect
extends BasicSQLDialect
implements SQLDataTypeConverter {
    private static final Log log = Log.getLog(JDBCSQLDialect.class);
    private static final String[] LONG_TEXT_TYPES = new String[]{"longtext", "clob", "text", "string", "nclob"};
    private String name;
    private String id;
    private String[][] identifierQuoteString = new String[][]{{"\"", "\""}};
    private SQLStateType sqlStateType;
    private String searchStringEscape;
    private String catalogSeparator = String.valueOf('.');
    private boolean isCatalogAtStart;
    private int catalogUsage = Integer.MAX_VALUE;
    protected int schemaUsage = Integer.MAX_VALUE;
    protected String validCharacters = "";
    private boolean supportsUnquotedMixedCase;
    private boolean supportsQuotedMixedCase;
    @NotNull
    private DBPIdentifierCase unquotedIdentCase = DBPIdentifierCase.MIXED;
    @NotNull
    private DBPIdentifierCase quotedIdentCase = DBPIdentifierCase.MIXED;
    private boolean supportsSubqueries = false;
    private transient boolean typesLoaded = false;

    public JDBCSQLDialect(String name, String id) {
        this.name = name;
        this.id = id;
    }

    public void initDriverSettings(JDBCSession session, JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        String singleQuoteStr;
        try {
            singleQuoteStr = metaData.getIdentifierQuoteString();
        }
        catch (Throwable e) {
            log.debug("Error getting identifierQuoteString: " + e.getMessage());
            singleQuoteStr = "\"";
        }
        if (singleQuoteStr != null && (singleQuoteStr = singleQuoteStr.trim()).isEmpty()) {
            singleQuoteStr = null;
        }
        this.identifierQuoteString = singleQuoteStr == null ? new String[0][] : new String[][]{{singleQuoteStr, singleQuoteStr}};
        try {
            switch (metaData.getSQLStateType()) {
                case 1: {
                    this.sqlStateType = SQLStateType.XOPEN;
                    break;
                }
                case 2: {
                    this.sqlStateType = SQLStateType.SQL99;
                    break;
                }
                default: {
                    this.sqlStateType = SQLStateType.UNKNOWN;
                    break;
                }
            }
        }
        catch (Throwable e) {
            log.debug("Error getting sqlStateType: " + e.getMessage());
            this.sqlStateType = SQLStateType.UNKNOWN;
        }
        try {
            this.supportsSubqueries = metaData.supportsCorrelatedSubqueries() || metaData.supportsSubqueriesInComparisons() || metaData.supportsSubqueriesInExists() || metaData.supportsSubqueriesInIns() || metaData.supportsSubqueriesInQuantifieds();
        }
        catch (Throwable e) {
            log.debug("Error getting supportsSubqueries: " + e.getMessage());
        }
        try {
            this.supportsUnquotedMixedCase = metaData.supportsMixedCaseIdentifiers();
        }
        catch (Throwable e) {
            log.debug("Error getting supportsUnquotedMixedCase:" + e.getMessage());
            this.supportsUnquotedMixedCase = false;
        }
        try {
            this.supportsQuotedMixedCase = metaData.supportsMixedCaseQuotedIdentifiers();
        }
        catch (Throwable e) {
            log.debug("Error getting supportsQuotedMixedCase: " + e.getMessage());
            this.supportsQuotedMixedCase = false;
        }
        try {
            this.unquotedIdentCase = metaData.storesUpperCaseIdentifiers() ? DBPIdentifierCase.UPPER : (metaData.storesLowerCaseIdentifiers() ? DBPIdentifierCase.LOWER : DBPIdentifierCase.MIXED);
        }
        catch (Throwable e) {
            log.debug("Error getting unquotedIdentCase:" + e.getMessage());
            this.unquotedIdentCase = DBPIdentifierCase.MIXED;
        }
        try {
            this.quotedIdentCase = metaData.storesUpperCaseQuotedIdentifiers() ? DBPIdentifierCase.UPPER : (metaData.storesLowerCaseQuotedIdentifiers() ? DBPIdentifierCase.LOWER : DBPIdentifierCase.MIXED);
        }
        catch (Throwable e) {
            log.debug("Error getting quotedIdentCase:" + e.getMessage());
            this.quotedIdentCase = DBPIdentifierCase.MIXED;
        }
        try {
            this.searchStringEscape = metaData.getSearchStringEscape();
        }
        catch (Throwable e) {
            log.debug("Error getting searchStringEscape:" + e.getMessage());
        }
        if (this.searchStringEscape == null) {
            this.searchStringEscape = "";
        }
        try {
            this.catalogSeparator = metaData.getCatalogSeparator();
            if (CommonUtils.isEmpty((String)this.catalogSeparator)) {
                this.catalogSeparator = String.valueOf('.');
            }
        }
        catch (Throwable e) {
            log.debug("Error getting catalogSeparator:" + e.getMessage());
            this.catalogSeparator = String.valueOf('.');
        }
        try {
            this.catalogUsage = (metaData.supportsCatalogsInDataManipulation() ? 1 : 0) | (metaData.supportsCatalogsInTableDefinitions() ? 2 : 0) | (metaData.supportsCatalogsInProcedureCalls() ? 4 : 0) | (metaData.supportsCatalogsInIndexDefinitions() ? 8 : 0) | (metaData.supportsCatalogsInPrivilegeDefinitions() ? 8 : 0);
        }
        catch (Throwable e) {
            log.debug("Error getting catalogUsage:" + e.getMessage());
            this.catalogUsage = 0;
        }
        try {
            this.schemaUsage = (metaData.supportsSchemasInDataManipulation() ? 1 : 0) | (metaData.supportsSchemasInTableDefinitions() ? 2 : 0) | (metaData.supportsSchemasInProcedureCalls() ? 4 : 0) | (metaData.supportsSchemasInIndexDefinitions() ? 8 : 0) | (metaData.supportsSchemasInPrivilegeDefinitions() ? 8 : 0);
        }
        catch (Throwable e) {
            log.debug("Error getting schemaUsage:" + e.getMessage());
            this.schemaUsage = 3;
        }
        try {
            this.validCharacters = metaData.getExtraNameCharacters();
            this.validCharacters = this.validCharacters == null ? "" : this.validCharacters.trim();
        }
        catch (Throwable e) {
            log.debug("Error getting validCharacters:" + e.getMessage());
            this.validCharacters = "";
        }
        try {
            this.isCatalogAtStart = metaData.isCatalogAtStart();
        }
        catch (Throwable e) {
            log.debug("Error getting isCatalogAtStart:" + e.getMessage());
            this.isCatalogAtStart = true;
        }
        this.loadDriverKeywords(session, dataSource, metaData);
    }

    @Override
    @NotNull
    public String getDialectName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDialectId() {
        return this.id;
    }

    @Override
    @Nullable
    public String[][] getIdentifierQuoteStrings() {
        return this.identifierQuoteString;
    }

    protected void setIdentifierQuoteString(String[][] identifierQuoteString) {
        this.identifierQuoteString = identifierQuoteString;
    }

    @Override
    @NotNull
    public String[] getExecuteKeywords() {
        return new String[0];
    }

    @Override
    @NotNull
    public String getSearchStringEscape() {
        return this.searchStringEscape;
    }

    @Override
    public int getCatalogUsage() {
        return this.catalogUsage;
    }

    @Override
    public int getSchemaUsage() {
        return this.schemaUsage;
    }

    @Override
    @NotNull
    public String getCatalogSeparator() {
        return this.catalogSeparator;
    }

    @Override
    public char getStructSeparator() {
        return '.';
    }

    @Override
    public boolean isCatalogAtStart() {
        return this.isCatalogAtStart;
    }

    @Override
    @NotNull
    public SQLStateType getSQLStateType() {
        return this.sqlStateType;
    }

    @Override
    public boolean validIdentifierPart(char c, boolean quoted) {
        return Character.isLetter(c) || Character.isDigit(c) || c == '_' || quoted && this.validCharacters.indexOf(c) != -1;
    }

    @Override
    public boolean supportsUnquotedMixedCase() {
        return this.supportsUnquotedMixedCase;
    }

    public void setSupportsUnquotedMixedCase(boolean supportsUnquotedMixedCase) {
        this.supportsUnquotedMixedCase = supportsUnquotedMixedCase;
    }

    @Override
    public boolean supportsQuotedMixedCase() {
        return this.supportsQuotedMixedCase;
    }

    protected void setSupportsQuotedMixedCase(boolean supportsQuotedMixedCase) {
        this.supportsQuotedMixedCase = supportsQuotedMixedCase;
    }

    @Override
    @NotNull
    public DBPIdentifierCase storesUnquotedCase() {
        return this.unquotedIdentCase;
    }

    protected void setUnquotedIdentCase(@NotNull DBPIdentifierCase unquotedIdentCase) {
        this.unquotedIdentCase = unquotedIdentCase;
    }

    @Override
    @NotNull
    public DBPIdentifierCase storesQuotedCase() {
        return this.quotedIdentCase;
    }

    @Override
    public boolean supportsSubqueries() {
        return this.supportsSubqueries;
    }

    public void setSupportsSubqueries(boolean supportsSubqueries) {
        this.supportsSubqueries = supportsSubqueries;
    }

    public boolean supportsUpsertStatement() {
        return false;
    }

    @Override
    @NotNull
    public TreeSet<String> getDataTypes(@Nullable DBPDataSource dataSource) {
        if (!this.typesLoaded && dataSource instanceof JDBCDataSource) {
            this.types.clear();
            this.loadDataTypesFromDatabase((JDBCDataSource)dataSource);
            this.typesLoaded = true;
        }
        return this.types;
    }

    protected void loadDataTypesFromDatabase(JDBCDataSource dataSource) {
        Collection<? extends DBSDataType> supportedDataTypes = dataSource.getLocalDataTypes();
        if (supportedDataTypes != null) {
            for (DBSDataType dBSDataType : supportedDataTypes) {
                if (dBSDataType.getDataKind().isComplex()) continue;
                this.types.add(dBSDataType.getName().toUpperCase(Locale.ENGLISH));
            }
        }
        if (this.types.isEmpty()) {
            Collections.addAll(this.types, SQLConstants.DEFAULT_TYPES);
        }
        this.addKeywords(this.types, DBPKeywordType.TYPE);
    }

    private void loadDriverKeywords(JDBCSession session, JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        try {
            List<String> sqlKeywords = JDBCSQLDialect.makeStringList(metaData.getSQLKeywords());
            if (!CommonUtils.isEmpty(sqlKeywords)) {
                for (String keyword : sqlKeywords) {
                    this.addSQLKeyword(keyword.toUpperCase());
                }
            }
        }
        catch (SQLException e) {
            log.debug("Error reading SQL keywords: " + e.getMessage());
        }
        try {
            HashSet<String> allFunctions = new HashSet<String>();
            this.loadFunctions(session, metaData, allFunctions);
            Iterator fIter = allFunctions.iterator();
            while (fIter.hasNext()) {
                if (this.getKeywordType((String)fIter.next()) != DBPKeywordType.KEYWORD) continue;
                fIter.remove();
            }
            this.addFunctions(allFunctions);
        }
        catch (Throwable e) {
            log.debug("Error reading SQL functions: " + e.getMessage());
        }
    }

    protected void loadFunctions(JDBCSession session, JDBCDatabaseMetaData metaData, Set<String> allFunctions) throws DBException, SQLException {
        for (String func : JDBCSQLDialect.makeStringList(metaData.getNumericFunctions())) {
            allFunctions.add(func.toUpperCase());
        }
        for (String func : JDBCSQLDialect.makeStringList(metaData.getStringFunctions())) {
            allFunctions.add(func.toUpperCase());
        }
        for (String func : JDBCSQLDialect.makeStringList(metaData.getSystemFunctions())) {
            allFunctions.add(func.toUpperCase());
        }
        for (String func : JDBCSQLDialect.makeStringList(metaData.getTimeDateFunctions())) {
            allFunctions.add(func.toUpperCase());
        }
    }

    private static List<String> makeStringList(String source) {
        ArrayList<String> result = new ArrayList<String>();
        if (source != null && source.length() > 0) {
            StringTokenizer st = new StringTokenizer(source, ";,");
            while (st.hasMoreTokens()) {
                result.add(st.nextToken().trim());
            }
        }
        return result;
    }

    @Override
    public String convertExternalDataType(@NotNull SQLDialect sourceDialect, @NotNull DBSTypedObject sourceTypedObject, @Nullable DBPDataTypeProvider targetTypeProvider) {
        long maxLength;
        String externalTypeName;
        if (targetTypeProvider != null && "varchar".equals(externalTypeName = sourceTypedObject.getTypeName().toLowerCase(Locale.ENGLISH)) && (maxLength = sourceTypedObject.getMaxLength()) <= 0L) {
            String[] stringArray = LONG_TEXT_TYPES;
            int n = LONG_TEXT_TYPES.length;
            int n2 = 0;
            while (n2 < n) {
                String textType = stringArray[n2];
                DBSDataType textDataType = targetTypeProvider.getLocalDataType(textType);
                if (textDataType != null) {
                    return textDataType.getName();
                }
                ++n2;
            }
        }
        return null;
    }
}

