/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model;

public enum DBPDataKind {
    BOOLEAN(false),
    NUMERIC(false),
    STRING(false),
    DATETIME(false),
    BINARY(false),
    CONTENT(false),
    STRUCT(true),
    DOCUMENT(true),
    ARRAY(true),
    OBJECT(true),
    REFERENCE(true),
    ROWID(false),
    ANY(true),
    UNKNOWN(false);

    private final boolean complex;

    private DBPDataKind(boolean complex) {
        this.complex = complex;
    }

    public boolean isComplex() {
        return this.complex;
    }

    public int getCommonality() {
        switch (this) {
            case BINARY: 
            case CONTENT: {
                return 3;
            }
            case STRING: {
                return 2;
            }
            case BOOLEAN: 
            case NUMERIC: 
            case DATETIME: 
            case STRUCT: 
            case ARRAY: 
            case OBJECT: 
            case REFERENCE: 
            case ROWID: {
                return 1;
            }
        }
        return 0;
    }

    public static boolean canConsume(DBPDataKind sourceKind, DBPDataKind targetKind) {
        if (targetKind == CONTENT || targetKind == BINARY) {
            return sourceKind == STRING || sourceKind == BINARY || sourceKind == CONTENT;
        }
        if (targetKind == STRING) {
            return sourceKind == STRING;
        }
        return sourceKind == targetKind;
    }
}

