/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ModelPreferences;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;

public class LogOutputStream
extends OutputStream {
    public static final long DEFAULT_MAX_LOG_SIZE = 0xA00000L;
    public static final int DEFAULT_MAX_LOG_FILES_COUNT = 3;
    public static final String LOGS_MAX_FILE_SIZE = "logs.files.output.maxSize";
    public static final String LOGS_MAX_FILES_COUNT = "logs.files.output.maxCount";
    private final File currentLogFile;
    private final File logFileLocation;
    private volatile FileOutputStream currentLogFileOutput = null;
    private volatile long currentLogSize;
    private volatile long maxLogSize;
    private volatile int maxLogFiles;
    private final String logFileName;
    private final String logFileNameExtension;
    private final Predicate<String> logFileNamePattern;

    public LogOutputStream(@NotNull File debugLogFile) throws IOException {
        if (debugLogFile.exists() && !debugLogFile.isFile()) {
            throw new IOException("Failed to initialize debug log output due to the target not being a file: " + debugLogFile.getAbsolutePath());
        }
        DBPPreferenceStore prefStore = ModelPreferences.getPreferences();
        this.currentLogFile = debugLogFile;
        this.logFileLocation = debugLogFile.getParentFile();
        this.maxLogSize = prefStore.getLong(LOGS_MAX_FILE_SIZE);
        this.maxLogFiles = prefStore.getInt(LOGS_MAX_FILES_COUNT);
        String fileName = debugLogFile.getName();
        int fnameExtStart = fileName.lastIndexOf(46);
        if (fnameExtStart >= 0) {
            this.logFileName = fileName.substring(0, fnameExtStart);
            this.logFileNameExtension = fileName.substring(fnameExtStart);
        } else {
            this.logFileName = fileName;
            this.logFileNameExtension = "";
        }
        String logFileNameRegexStr = "^" + Pattern.quote(this.logFileName) + "\\-[0-9]+" + Pattern.quote(this.logFileNameExtension) + "$";
        this.logFileNamePattern = Pattern.compile(logFileNameRegexStr).asMatchPredicate();
        if (debugLogFile.exists()) {
            this.currentLogSize = this.currentLogFile.length();
            this.rotateCurrentLogFile(true);
        } else {
            this.currentLogSize = 0L;
            if (this.logFileLocation.mkdirs()) {
                throw new IOException("Failed to initialize debug log output location: " + debugLogFile.getAbsolutePath());
            }
        }
        prefStore.addPropertyChangeListener(ev -> {
            if (LOGS_MAX_FILE_SIZE.equals(ev.getProperty())) {
                this.maxLogSize = prefStore.getLong(LOGS_MAX_FILE_SIZE);
            }
            if (LOGS_MAX_FILES_COUNT.equals(ev.getProperty())) {
                this.maxLogFiles = prefStore.getInt(LOGS_MAX_FILES_COUNT);
            }
        });
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.getLogFileWriter().write(b);
        ++this.currentLogSize;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.getLogFileWriter().write(b, off, len);
        this.currentLogSize += (long)len;
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.currentLogFileOutput != null) {
            this.currentLogFileOutput.flush();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.currentLogFileOutput != null) {
            this.currentLogFileOutput.close();
            this.currentLogFileOutput = null;
        }
    }

    private OutputStream getLogFileWriter() throws IOException {
        if (this.currentLogFileOutput == null || this.rotateCurrentLogFile(false)) {
            this.currentLogFileOutput = new FileOutputStream(this.currentLogFile, true);
        }
        return this.currentLogFileOutput;
    }

    private boolean rotateCurrentLogFile(boolean force) throws IOException {
        if ((this.currentLogFileOutput != null || this.currentLogFile.exists()) && (this.currentLogSize > this.maxLogSize || force)) {
            this.close();
            File newFile = new File(this.logFileLocation, String.valueOf(this.logFileName) + "-" + System.currentTimeMillis() + this.logFileNameExtension);
            if (!this.currentLogFile.renameTo(newFile)) {
                return false;
            }
            this.currentLogSize = 0L;
            File[] logFiles = this.logFileLocation.listFiles((dir, name) -> this.logFileNamePattern.test(name));
            if (logFiles == null) {
                return false;
            }
            Arrays.sort(logFiles, Comparator.comparing(File::getName));
            int i = 0;
            int count = logFiles.length;
            while (i < logFiles.length && count > this.maxLogFiles) {
                logFiles[i].delete();
                ++i;
                --count;
            }
            return true;
        }
        return false;
    }
}

