/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.themes.ITheme;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class UIStyles {
    private static final Log log = Log.getLog(UIStyles.class);
    static IPreferenceStore EDITORS_PREFERENCE_STORE;

    public static synchronized IPreferenceStore getEditorsPreferenceStore() {
        if (EDITORS_PREFERENCE_STORE == null) {
            EDITORS_PREFERENCE_STORE = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.ui.editors");
        }
        return EDITORS_PREFERENCE_STORE;
    }

    public static boolean isDarkTheme() {
        return UIUtils.isDark(UIStyles.getDefaultTextBackground().getRGB());
    }

    public static Color getDefaultWidgetBackground() {
        ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        Color color = theme.getColorRegistry().get("org.eclipse.ui.workbench.INACTIVE_TAB_BG_START");
        if (color == null) {
            color = Display.getCurrent().getSystemColor(22);
        }
        return color;
    }

    public static Color getDefaultTextBackground() {
        return UIStyles.getDefaultTextColor("AbstractTextEditor.Color.Background", 25);
    }

    public static Color getDefaultTextForeground() {
        return UIStyles.getDefaultTextColor("AbstractTextEditor.Color.Foreground", 24);
    }

    public static Color getDefaultTextSelectionBackground() {
        return UIStyles.getDefaultTextColor("AbstractTextEditor.Color.SelectionBackground", 26);
    }

    public static Color getDefaultTextSelectionForeground() {
        return UIStyles.getDefaultTextColor("AbstractTextEditor.Color.SelectionForeground", 27);
    }

    public static Color getDefaultTextColor(String id, int defSWT) {
        IPreferenceStore preferenceStore = UIStyles.getEditorsPreferenceStore();
        String fgRGB = preferenceStore == null ? null : preferenceStore.getString(id);
        return CommonUtils.isEmpty((String)fgRGB) ? Display.getDefault().getSystemColor(defSWT) : UIUtils.getSharedColor(fgRGB);
    }
}

