/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2dl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2dl.AnchorListener;
import org.eclipse.draw2dl.ArrowLocator;
import org.eclipse.draw2dl.Connection;
import org.eclipse.draw2dl.ConnectionAnchor;
import org.eclipse.draw2dl.ConnectionRouter;
import org.eclipse.draw2dl.DelegatingLayout;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.Polyline;
import org.eclipse.draw2dl.RotatableDecoration;
import org.eclipse.draw2dl.RoutingListener;
import org.eclipse.draw2dl.geometry.Point;
import org.eclipse.draw2dl.geometry.Rectangle;

public class PolylineConnection
extends Polyline
implements Connection,
AnchorListener {
    private ConnectionAnchor startAnchor;
    private ConnectionAnchor endAnchor;
    private ConnectionRouter connectionRouter = ConnectionRouter.NULL;
    private RotatableDecoration startArrow;
    private RotatableDecoration endArrow;

    public PolylineConnection() {
        this.setLayoutManager(new DelegatingLayout());
        this.addPoint(new Point(0, 0));
        this.addPoint(new Point(100, 100));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.hookSourceAnchor();
        this.hookTargetAnchor();
    }

    public void addRoutingListener(RoutingListener listener) {
        if (this.connectionRouter instanceof RoutingNotifier) {
            RoutingNotifier notifier = (RoutingNotifier)this.connectionRouter;
            notifier.listeners.add(listener);
        } else {
            this.connectionRouter = new RoutingNotifier(this.connectionRouter, listener);
        }
    }

    @Override
    public void anchorMoved(ConnectionAnchor anchor) {
        this.revalidate();
    }

    @Override
    public Rectangle getBounds() {
        if (this.bounds == null) {
            super.getBounds();
            int i = 0;
            while (i < this.getChildren().size()) {
                IFigure child = this.getChildren().get(i);
                this.bounds.union(child.getBounds());
                ++i;
            }
        }
        return this.bounds;
    }

    @Override
    public ConnectionRouter getConnectionRouter() {
        if (this.connectionRouter instanceof RoutingNotifier) {
            return ((RoutingNotifier)this.connectionRouter).realRouter;
        }
        return this.connectionRouter;
    }

    @Override
    public Object getRoutingConstraint() {
        if (this.getConnectionRouter() != null) {
            return this.getConnectionRouter().getConstraint(this);
        }
        return null;
    }

    @Override
    public ConnectionAnchor getSourceAnchor() {
        return this.startAnchor;
    }

    protected RotatableDecoration getSourceDecoration() {
        return this.startArrow;
    }

    @Override
    public ConnectionAnchor getTargetAnchor() {
        return this.endAnchor;
    }

    protected RotatableDecoration getTargetDecoration() {
        return this.endArrow;
    }

    private void hookSourceAnchor() {
        if (this.getSourceAnchor() != null) {
            this.getSourceAnchor().addAnchorListener(this);
        }
    }

    private void hookTargetAnchor() {
        if (this.getTargetAnchor() != null) {
            this.getTargetAnchor().addAnchorListener(this);
        }
    }

    @Override
    public void layout() {
        if (this.getSourceAnchor() != null && this.getTargetAnchor() != null) {
            this.connectionRouter.route(this);
        }
        Rectangle oldBounds = this.bounds;
        super.layout();
        this.bounds = null;
        if (!this.getBounds().contains(oldBounds)) {
            this.getParent().translateToParent(oldBounds);
            this.getUpdateManager().addDirtyRegion(this.getParent(), oldBounds);
        }
        this.repaint();
        this.fireFigureMoved();
    }

    @Override
    public void removeNotify() {
        this.unhookSourceAnchor();
        this.unhookTargetAnchor();
        this.connectionRouter.remove(this);
        super.removeNotify();
    }

    public void removeRoutingListener(RoutingListener listener) {
        if (this.connectionRouter instanceof RoutingNotifier) {
            RoutingNotifier notifier = (RoutingNotifier)this.connectionRouter;
            notifier.listeners.remove(listener);
            if (notifier.listeners.isEmpty()) {
                this.connectionRouter = notifier.realRouter;
            }
        }
    }

    @Override
    public void revalidate() {
        super.revalidate();
        this.connectionRouter.invalidate(this);
    }

    @Override
    public void setConnectionRouter(ConnectionRouter cr) {
        ConnectionRouter oldRouter;
        if (cr == null) {
            cr = ConnectionRouter.NULL;
        }
        if ((oldRouter = this.getConnectionRouter()) != cr) {
            this.connectionRouter.remove(this);
            if (this.connectionRouter instanceof RoutingNotifier) {
                ((RoutingNotifier)this.connectionRouter).realRouter = cr;
            } else {
                this.connectionRouter = cr;
            }
            this.firePropertyChange("connectionRouter", oldRouter, cr);
            this.revalidate();
        }
    }

    @Override
    public void setRoutingConstraint(Object cons) {
        if (this.connectionRouter != null) {
            this.connectionRouter.setConstraint(this, cons);
        }
        this.revalidate();
    }

    @Override
    public void setSourceAnchor(ConnectionAnchor anchor) {
        if (anchor == this.startAnchor) {
            return;
        }
        this.unhookSourceAnchor();
        this.startAnchor = anchor;
        if (this.getParent() != null) {
            this.hookSourceAnchor();
        }
        this.revalidate();
    }

    public void setSourceDecoration(RotatableDecoration dec) {
        if (this.startArrow == dec) {
            return;
        }
        if (this.startArrow != null) {
            this.remove(this.startArrow);
        }
        this.startArrow = dec;
        if (this.startArrow != null) {
            this.add((IFigure)this.startArrow, new ArrowLocator(this, 2));
        }
    }

    @Override
    public void setTargetAnchor(ConnectionAnchor anchor) {
        if (anchor == this.endAnchor) {
            return;
        }
        this.unhookTargetAnchor();
        this.endAnchor = anchor;
        if (this.getParent() != null) {
            this.hookTargetAnchor();
        }
        this.revalidate();
    }

    public void setTargetDecoration(RotatableDecoration dec) {
        if (this.endArrow == dec) {
            return;
        }
        if (this.endArrow != null) {
            this.remove(this.endArrow);
        }
        this.endArrow = dec;
        if (this.endArrow != null) {
            this.add((IFigure)this.endArrow, new ArrowLocator(this, 3));
        }
    }

    private void unhookSourceAnchor() {
        if (this.getSourceAnchor() != null) {
            this.getSourceAnchor().removeAnchorListener(this);
        }
    }

    private void unhookTargetAnchor() {
        if (this.getTargetAnchor() != null) {
            this.getTargetAnchor().removeAnchorListener(this);
        }
    }

    final class RoutingNotifier
    implements ConnectionRouter {
        ConnectionRouter realRouter;
        List listeners = new ArrayList(1);

        RoutingNotifier(ConnectionRouter router, RoutingListener listener) {
            this.realRouter = router;
            this.listeners.add(listener);
        }

        @Override
        public Object getConstraint(Connection connection) {
            return this.realRouter.getConstraint(connection);
        }

        @Override
        public void invalidate(Connection connection) {
            int i = 0;
            while (i < this.listeners.size()) {
                ((RoutingListener)this.listeners.get(i)).invalidate(connection);
                ++i;
            }
            this.realRouter.invalidate(connection);
        }

        @Override
        public void route(Connection connection) {
            boolean consumed = false;
            int i = 0;
            while (i < this.listeners.size()) {
                consumed |= ((RoutingListener)this.listeners.get(i)).route(connection);
                ++i;
            }
            if (!consumed) {
                this.realRouter.route(connection);
            }
            i = 0;
            while (i < this.listeners.size()) {
                ((RoutingListener)this.listeners.get(i)).postRoute(connection);
                ++i;
            }
        }

        @Override
        public void remove(Connection connection) {
            int i = 0;
            while (i < this.listeners.size()) {
                ((RoutingListener)this.listeners.get(i)).remove(connection);
                ++i;
            }
            this.realRouter.remove(connection);
        }

        @Override
        public void setConstraint(Connection connection, Object constraint) {
            int i = 0;
            while (i < this.listeners.size()) {
                ((RoutingListener)this.listeners.get(i)).setConstraint(connection, constraint);
                ++i;
            }
            this.realRouter.setConstraint(connection, constraint);
        }
    }
}

