/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3.ui.palette;

import org.eclipse.gef3.ContextMenuProvider;
import org.eclipse.gef3.EditPart;
import org.eclipse.gef3.ui.actions.GEFActionConstants;
import org.eclipse.gef3.ui.palette.ChangeIconSizeAction;
import org.eclipse.gef3.ui.palette.CustomizeAction;
import org.eclipse.gef3.ui.palette.LayoutAction;
import org.eclipse.gef3.ui.palette.PaletteViewer;
import org.eclipse.gef3.ui.palette.PinDrawerAction;
import org.eclipse.gef3.ui.palette.SettingsAction;
import org.eclipse.gef3.ui.palette.editparts.IPinnableEditPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;

public class PaletteContextMenuProvider
extends ContextMenuProvider {
    public PaletteContextMenuProvider(PaletteViewer palette) {
        super(palette);
    }

    protected PaletteViewer getPaletteViewer() {
        return (PaletteViewer)this.getViewer();
    }

    @Override
    public void buildContextMenu(IMenuManager menu) {
        GEFActionConstants.addStandardActionGroups(menu);
        EditPart selectedPart = (EditPart)this.getPaletteViewer().getSelectedEditParts().get(0);
        IPinnableEditPart pinnablePart = (IPinnableEditPart)selectedPart.getAdapter(IPinnableEditPart.class);
        if (pinnablePart != null && pinnablePart.canBePinned()) {
            menu.appendToGroup("additions", (IAction)new PinDrawerAction(pinnablePart));
        }
        menu.appendToGroup("org.eclipse.gef3.group.view", (IAction)new LayoutAction(this.getPaletteViewer().getPaletteViewerPreferences()));
        menu.appendToGroup("org.eclipse.gef3.group.view", (IAction)new ChangeIconSizeAction(this.getPaletteViewer().getPaletteViewerPreferences()));
        if (this.getPaletteViewer().getCustomizer() != null) {
            menu.appendToGroup("org.eclipse.gef3.group.rest", (IAction)new CustomizeAction(this.getPaletteViewer()));
        }
        menu.appendToGroup("org.eclipse.gef3.group.rest", (IAction)new SettingsAction(this.getPaletteViewer()));
    }
}

