/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3.requests;

import org.eclipse.draw2dl.geometry.Dimension;
import org.eclipse.draw2dl.geometry.Point;
import org.eclipse.gef3.Request;
import org.eclipse.gef3.requests.CreationFactory;
import org.eclipse.gef3.requests.DropRequest;

public class CreateRequest
extends Request
implements DropRequest {
    private Object newObject;
    private Dimension size;
    private Point location;
    private int flags = 0;
    private static final int SNAP_TO = 1;
    private CreationFactory creationFactory;

    public CreateRequest() {
        this.setType("create child");
    }

    public CreateRequest(Object type) {
        this.setType(type);
    }

    protected CreationFactory getFactory() {
        return this.creationFactory;
    }

    @Override
    public Point getLocation() {
        return this.location;
    }

    public Object getNewObject() {
        if (this.newObject == null) {
            if (this.getFactory() == null) {
                throw new IllegalArgumentException("CreateRequest has unspecified CreationFactory");
            }
            this.newObject = this.getFactory().getNewObject();
        }
        return this.newObject;
    }

    public Object getNewObjectType() {
        if (this.getFactory() == null) {
            throw new IllegalArgumentException("CreateRequest has unspecified CreationFactory");
        }
        return this.getFactory().getObjectType();
    }

    public Dimension getSize() {
        return this.size;
    }

    public boolean isSnapToEnabled() {
        return (this.flags & 1) != 0;
    }

    public void setFactory(CreationFactory factory) {
        this.creationFactory = factory;
    }

    public void setLocation(Point location) {
        this.location = location;
    }

    public void setSize(Dimension size) {
        this.size = size;
    }

    public void setSnapToEnabled(boolean value) {
        this.flags = value ? this.flags | 1 : this.flags & 0xFFFFFFFE;
    }
}

