/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone;

import java.io.FileInputStream;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.app.standalone.CommandLineParameterHandler;
import org.jkiss.dbeaver.ui.app.standalone.DBeaverApplication;
import org.jkiss.dbeaver.ui.app.standalone.rpc.IInstanceController;
import org.jkiss.dbeaver.ui.app.standalone.rpc.InstanceClient;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.SystemVariablesResolver;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Bundle;

public class DBeaverCommandLine {
    private static final Log log;
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.commandLine";
    public static final String PARAM_HELP = "help";
    public static final String PARAM_FILE = "f";
    public static final String PARAM_CONFIG = "vars";
    public static final String PARAM_STOP = "stop";
    public static final String PARAM_THREAD_DUMP = "dump";
    public static final String PARAM_CONNECT = "con";
    public static final String PARAM_CLOSE_TABS = "closeTabs";
    public static final String PARAM_DISCONNECT_ALL = "disconnectAll";
    public static final String PARAM_REUSE_WORKSPACE = "reuseWorkspace";
    public static final String PARAM_NEW_INSTANCE = "newInstance";
    public static final String PARAM_BRING_TO_FRONT = "bringToFront";
    public static final String PARAM_QUIET = "q";
    public static final Options ALL_OPTIONS;
    private static final Map<String, ParameterDescriptor> customParameters;

    static {
        IConfigurationElement[] extElements;
        log = Log.getLog(DBeaverCommandLine.class);
        ALL_OPTIONS = new Options().addOption(PARAM_HELP, false, "Help").addOption(PARAM_CONFIG, "variablesFile", true, "Uses a specified configuration file for variable resolving").addOption(PARAM_FILE, "file", true, "Open a file").addOption(PARAM_STOP, "quit", false, "Stop DBeaver running instance").addOption(PARAM_THREAD_DUMP, "thread-dump", false, "Print instance thread dump").addOption(PARAM_CONNECT, "connect", true, "Connects to a specified database").addOption(PARAM_DISCONNECT_ALL, PARAM_DISCONNECT_ALL, false, "Disconnect from all databases").addOption(PARAM_CLOSE_TABS, PARAM_CLOSE_TABS, false, "Close all open editors").addOption(PARAM_REUSE_WORKSPACE, PARAM_REUSE_WORKSPACE, false, "Force workspace reuse (do not show warnings)").addOption(PARAM_NEW_INSTANCE, PARAM_NEW_INSTANCE, false, "Force creating new application instance (do not try to activate already running)").addOption(PARAM_BRING_TO_FRONT, PARAM_BRING_TO_FRONT, false, "Bring DBeaver window on top of other applications").addOption(PARAM_QUIET, PARAM_QUIET, false, "Run quietly (do not print logs)").addOption("product", true, "Product id").addOption("nl", true, "National locale").addOption("data", true, "Data directory").addOption("nosplash", false, "No splash screen").addOption("showlocation", false, "Show location").addOption("registryMultiLanguage", false, "Multi-language mode");
        customParameters = new LinkedHashMap<String, ParameterDescriptor>();
        IExtensionRegistry er = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extElements = er.getConfigurationElementsFor(EXTENSION_ID);
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if ("parameter".equals(ext.getName())) {
                try {
                    ParameterDescriptor parameter = new ParameterDescriptor(ext);
                    customParameters.put(parameter.name, parameter);
                }
                catch (Exception e) {
                    log.error((Object)"Can't load contributed parameter", (Throwable)e);
                }
            }
            ++n2;
        }
        for (ParameterDescriptor param : customParameters.values()) {
            ALL_OPTIONS.addOption(param.name, param.longName, param.hasArg, param.description);
        }
    }

    public static List<CommandLineParameterHandler> getRemoteParameterHandlers(@NotNull CommandLine commandLine) {
        ArrayList<CommandLineParameterHandler> handlers = new ArrayList<CommandLineParameterHandler>();
        for (ParameterDescriptor param : customParameters.values()) {
            if (!commandLine.hasOption(param.name) || param.handler instanceof Remote) continue;
            handlers.add(param.handler);
        }
        return handlers;
    }

    static boolean executeCommandLineCommands(@Nullable CommandLine commandLine, @Nullable IInstanceController controller, boolean uiActivated) throws Exception {
        Object[] connectParams;
        String file;
        if (commandLine == null || ArrayUtils.isEmpty((Object[])commandLine.getArgs()) && ArrayUtils.isEmpty((Object[])commandLine.getOptions())) {
            return false;
        }
        if (commandLine.hasOption(PARAM_REUSE_WORKSPACE) && DBeaverApplication.instance != null) {
            DBeaverApplication.instance.setReuseWorkspace(true);
        }
        if (!CommonUtils.isEmpty((String)(file = commandLine.getOptionValue(PARAM_CONFIG)))) {
            try {
                Throwable throwable = null;
                Object var5_9 = null;
                try (FileInputStream stream = new FileInputStream(file);){
                    Properties properties = new Properties();
                    properties.load(stream);
                    SystemVariablesResolver.setConfiguration((Properties)properties);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.error((Object)"Error parsing command line ", (Throwable)e);
                return false;
            }
        }
        if (controller == null) {
            log.debug((Object)"Can't process commands because no running instance is present");
            return false;
        }
        boolean exitAfterExecute = false;
        if (!uiActivated) {
            if (commandLine.hasOption(PARAM_STOP)) {
                try {
                    controller.quit();
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                return true;
            }
            if (commandLine.hasOption(PARAM_THREAD_DUMP)) {
                String threadDump = controller.getThreadDump();
                System.out.println(threadDump);
                return true;
            }
        }
        Object[] files = commandLine.getOptionValues(PARAM_FILE);
        Object[] fileArgs = commandLine.getArgs();
        if (!ArrayUtils.isEmpty((Object[])files) || !ArrayUtils.isEmpty((Object[])fileArgs)) {
            ArrayList fileNames = new ArrayList();
            if (!ArrayUtils.isEmpty((Object[])files)) {
                Collections.addAll(fileNames, files);
            }
            if (!ArrayUtils.isEmpty((Object[])fileArgs)) {
                Collections.addAll(fileNames, fileArgs);
            }
            controller.openExternalFiles(fileNames.toArray(new String[0]));
            exitAfterExecute = true;
        }
        if (!ArrayUtils.isEmpty((Object[])(connectParams = commandLine.getOptionValues(PARAM_CONNECT)))) {
            Object[] objectArray = connectParams;
            int n = connectParams.length;
            int n2 = 0;
            while (n2 < n) {
                Object cp = objectArray[n2];
                controller.openDatabaseConnection((String)cp);
                ++n2;
            }
            exitAfterExecute = true;
        }
        if (commandLine.hasOption(PARAM_CLOSE_TABS)) {
            controller.closeAllEditors();
            exitAfterExecute = true;
        }
        if (commandLine.hasOption(PARAM_DISCONNECT_ALL)) {
            controller.executeWorkbenchCommand("org.jkiss.dbeaver.core.disconnectAll");
            exitAfterExecute = true;
        }
        if (commandLine.hasOption(PARAM_BRING_TO_FRONT)) {
            controller.bringToFront();
            exitAfterExecute = true;
        }
        return exitAfterExecute;
    }

    static CommandLine getCommandLine() {
        try {
            return new DefaultParser().parse(ALL_OPTIONS, Platform.getApplicationArgs(), false);
        }
        catch (Exception e) {
            log.warn((Object)("Error parsing command line: " + e.getMessage()));
            return null;
        }
    }

    static boolean handleCommandLine(CommandLine commandLine, String instanceLoc) {
        if (commandLine == null || ArrayUtils.isEmpty((Object[])commandLine.getArgs()) && ArrayUtils.isEmpty((Object[])commandLine.getOptions())) {
            return false;
        }
        if (commandLine.hasOption(PARAM_HELP)) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.setWidth(120);
            helpFormatter.setOptionComparator((o1, o2) -> 0);
            helpFormatter.printHelp("dbeaver", GeneralUtils.getProductTitle(), ALL_OPTIONS, "(C) 2020-2022 DBeaver Corp", true);
            return true;
        }
        for (ParameterDescriptor param : customParameters.values()) {
            if (!param.exclusiveMode || !commandLine.hasOption(param.name) && !commandLine.hasOption(param.longName)) continue;
            if (DBeaverApplication.instance == null) break;
            DBeaverApplication.instance.setExclusiveMode(true);
            break;
        }
        if (commandLine.hasOption(PARAM_NEW_INSTANCE)) {
            return false;
        }
        IInstanceController controller = InstanceClient.createClient(instanceLoc);
        try {
            return DBeaverCommandLine.executeCommandLineCommands(commandLine, controller, false);
        }
        catch (RemoteException e) {
            log.error((Object)"Error calling remote server", (Throwable)e);
        }
        catch (Throwable e) {
            log.error((Object)"Error while calling remote server", e);
        }
        return false;
    }

    public static boolean handleCustomParameters(CommandLine commandLine) {
        if (commandLine == null) {
            return false;
        }
        boolean exit = false;
        Option[] optionArray = commandLine.getOptions();
        int n = optionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Option cliOption = optionArray[n2];
            ParameterDescriptor param = customParameters.get(cliOption.getOpt());
            if (param == null) {
                param = customParameters.get(cliOption.getLongOpt());
            }
            if (param != null) {
                try {
                    if (param.hasArg) {
                        String[] stringArray = commandLine.getOptionValues(param.name);
                        int n3 = stringArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String optValue = stringArray[n4];
                            param.handler.handleParameter(commandLine, param.name, optValue);
                            ++n4;
                        }
                    } else {
                        param.handler.handleParameter(commandLine, param.name, null);
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Error evaluating parameter '" + param.name + "'"), (Throwable)e);
                }
                if (param.exitAfterExecute) {
                    exit = true;
                }
            }
            ++n2;
        }
        return exit;
    }

    private static class ParameterDescriptor {
        String name;
        String longName;
        String description;
        boolean hasArg;
        boolean exitAfterExecute;
        boolean exclusiveMode;
        CommandLineParameterHandler handler;

        public ParameterDescriptor(IConfigurationElement config) throws Exception {
            this.name = config.getAttribute("name");
            this.longName = config.getAttribute("longName");
            this.description = config.getAttribute("description");
            this.hasArg = CommonUtils.toBoolean((Object)config.getAttribute("hasArg"));
            this.exitAfterExecute = CommonUtils.toBoolean((Object)config.getAttribute("exitAfterExecute"));
            this.exclusiveMode = CommonUtils.toBoolean((Object)config.getAttribute("exclusiveMode"));
            Bundle cBundle = Platform.getBundle((String)config.getContributor().getName());
            Class implClass = cBundle.loadClass(config.getAttribute("handler"));
            this.handler = (CommandLineParameterHandler)implClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
    }
}

