/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IRefreshablePart;
import org.jkiss.dbeaver.ui.UIConfirmation;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditor;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.navigator.INavigatorModelView;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectOpen;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class NavigatorHandlerRefresh
extends AbstractHandler {
    private static final Log log = Log.getLog(NavigatorHandlerRefresh.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart workbenchPart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (this.refreshInNavigator(event, workbenchPart)) {
            return null;
        }
        if (workbenchPart instanceof IRefreshablePart) {
            DBSObject databaseObject;
            IEditorInput editorInput;
            if (workbenchPart instanceof IDatabaseEditor && (editorInput = ((IDatabaseEditor)workbenchPart).getEditorInput()) instanceof IDatabaseEditorInput && ((databaseObject = ((IDatabaseEditorInput)editorInput).getDatabaseObject()) == null || !databaseObject.isPersisted())) {
                return null;
            }
            if (((IRefreshablePart)workbenchPart).refreshPart((Object)this, true) == IRefreshablePart.RefreshResult.CANCELED) {
                return null;
            }
        }
        return null;
    }

    private boolean refreshInNavigator(ExecutionEvent event, IWorkbenchPart workbenchPart) {
        INavigatorModelView navigatorView = (INavigatorModelView)GeneralUtils.adapt((Object)workbenchPart, INavigatorModelView.class);
        if (navigatorView == null) {
            return false;
        }
        ArrayList<DBNNode> refreshObjects = new ArrayList<DBNNode>();
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        DBNNode rootNode = navigatorView.getRootNode();
        if (rootNode == null && workbenchPart instanceof IEditorPart && ((IEditorPart)workbenchPart).getEditorInput() instanceof IDatabaseEditorInput) {
            rootNode = ((IDatabaseEditorInput)((IEditorPart)workbenchPart).getEditorInput()).getNavigatorNode();
        }
        if (rootNode != null && rootNode.getParentNode() instanceof DBNDatabaseNode) {
            refreshObjects.add(rootNode);
        } else if (selection instanceof IStructuredSelection) {
            IStructuredSelection structSelection = (IStructuredSelection)selection;
            for (Object object : structSelection) {
                if (!(object instanceof DBNNode)) continue;
                refreshObjects.add((DBNNode)object);
            }
        }
        if (!refreshObjects.isEmpty()) {
            IEditorReference[] iEditorReferenceArray = UIUtils.getActiveWorkbenchWindow().getActivePage().getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference er = iEditorReferenceArray[n2];
                IEditorPart editorPart = er.getEditor(false);
                if (editorPart instanceof IRefreshablePart && editorPart.getEditorInput() instanceof DatabaseEditorInput && editorPart.isDirty()) {
                    DBNDatabaseNode editorNode = ((DatabaseEditorInput)editorPart.getEditorInput()).getNavigatorNode();
                    Iterator iter = refreshObjects.iterator();
                    while (iter.hasNext()) {
                        DBNNode nextNode = (DBNNode)iter.next();
                        if (nextNode != editorNode && !editorNode.isChildOf(nextNode) && !nextNode.isChildOf((DBNNode)editorNode)) continue;
                        if (((IRefreshablePart)editorPart).refreshPart((Object)this, true) == IRefreshablePart.RefreshResult.CANCELED) {
                            return true;
                        }
                        iter.remove();
                    }
                }
                ++n2;
            }
        }
        if (!refreshObjects.isEmpty()) {
            return NavigatorHandlerRefresh.refreshNavigator(refreshObjects);
        }
        return false;
    }

    public static boolean refreshNavigator(final Collection<? extends DBNNode> refreshObjects) {
        AbstractJob refreshJob = new AbstractJob("Refresh navigator object(s)"){

            protected IStatus run(DBRProgressMonitor monitor) {
                monitor.beginTask("Refresh objects", refreshObjects.size());
                HashSet<DBNNode> refreshedSet = new HashSet<DBNNode>();
                for (DBNNode node : refreshObjects) {
                    if (node.isDisposed() || node.isLocked()) continue;
                    if (monitor.isCanceled()) break;
                    if (!refreshedSet.isEmpty()) {
                        boolean skip = false;
                        for (DBNNode refreshed : refreshedSet) {
                            if (node != refreshed && !node.isChildOf(refreshed)) continue;
                            skip = true;
                            break;
                        }
                        if (skip) continue;
                    }
                    if (node instanceof DBNDatabaseFolder && !(node.getParentNode() instanceof DBNDatabaseFolder) && node.getParentNode() instanceof DBNDatabaseNode) {
                        node = node.getParentNode();
                    }
                    this.setName("Refresh '" + node.getNodeName() + "'...");
                    try {
                        DBNNode refreshed = node.refreshNode(monitor, DBNEvent.FORCE_REFRESH);
                        if (refreshed != null) {
                            refreshedSet.add(refreshed);
                        }
                    }
                    catch (Throwable ex) {
                        if (node instanceof DBNDataSource) {
                            try {
                                log.info((Object)"Unable to refresh datasource, disconnecting");
                                ((DBNDataSource)node).getDataSourceContainer().disconnect(monitor);
                            }
                            catch (DBException dBException) {
                                log.warn((Object)"Unable to disconnect from datasource");
                            }
                        }
                        DBWorkbench.getPlatformUI().showError("Refresh", "Error refreshing node", ex);
                    }
                    monitor.worked(1);
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        refreshJob.setUser(true);
        refreshJob.schedule();
        return true;
    }

    private static boolean showConfirmation(final DBNNode node) {
        return (Boolean)new UIConfirmation(){

            protected Boolean runTask() {
                IEditorPart nodeEditor = NavigatorHandlerObjectOpen.findEntityEditor(UIUtils.getActiveWorkbenchWindow(), node);
                if (nodeEditor != null && nodeEditor.isDirty()) {
                    if (ConfirmationDialog.confirmAction(null, (String)"entity_revert", (int)3, (Object[])new Object[]{nodeEditor.getTitle()}) == 2) {
                        return true;
                    }
                    return false;
                }
                return true;
            }
        }.execute();
    }
}

