/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.data;

import java.io.IOException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ISmartTransactionManager;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.editors.IRevertableEditor;
import org.jkiss.dbeaver.ui.editors.data.AbstractDataEditor;
import org.jkiss.utils.CommonUtils;

public class DatabaseDataEditor
extends AbstractDataEditor<DBSDataContainer>
implements ISmartTransactionManager,
IRevertableEditor {
    public static final String ATTR_SUSPEND_QUERY = "suspendQuery";
    public static final String ATTR_DATA_FILTER = "dataFilter";

    @Override
    @Nullable
    public DBSDataContainer getDataContainer() {
        return (DBSDataContainer)this.getEditorInput().getDatabaseObject();
    }

    @Override
    protected DBDDataFilter getEditorDataFilter() {
        return (DBDDataFilter)this.getEditorInput().getAttribute(ATTR_DATA_FILTER);
    }

    @Override
    protected boolean isSuspendDataQuery() {
        return CommonUtils.toBoolean((Object)this.getEditorInput().getAttribute(ATTR_SUSPEND_QUERY));
    }

    @Override
    protected String getDataQueryMessage() {
        return "Query data from '" + this.getEditorInput().getDatabaseObject().getName() + "'...";
    }

    @Override
    public boolean isReadyToRun() {
        return this.getDatabaseObject() != null && ((DBSDataContainer)this.getDatabaseObject()).isPersisted();
    }

    public boolean isSmartAutoCommit() {
        return this.getActivePreferenceStore().getBoolean("transaction.smart.commit");
    }

    public void setSmartAutoCommit(boolean smartAutoCommit) {
        this.getActivePreferenceStore().setValue("transaction.smart.commit", smartAutoCommit);
        try {
            this.getActivePreferenceStore().save();
        }
        catch (IOException e) {
            DBWorkbench.getPlatformUI().showError("Samrt commit", "Error saving smart auto-commit option", (Throwable)e);
        }
    }

    @NotNull
    private DBPPreferenceStore getActivePreferenceStore() {
        DBPDataSource dataSource = ((DBSDataContainer)this.getDatabaseObject()).getDataSource();
        if (dataSource == null) {
            return DBWorkbench.getPlatform().getPreferenceStore();
        }
        return dataSource.getContainer().getPreferenceStore();
    }

    public void doRevertToSaved() {
        ResultSetViewer viewer = this.getResultSetController();
        if (viewer != null) {
            viewer.rejectChanges();
        }
    }
}

