/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.parser.tokens.predicates;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.sql.parser.SQLTokenPredicate;
import org.jkiss.dbeaver.model.sql.parser.SQLTokenPredicateSet;
import org.jkiss.dbeaver.model.sql.parser.TokenEntry;
import org.jkiss.dbeaver.model.sql.parser.TrieNode;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.ExactTokenEntryComparator;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.TokenEntryMatchingComparator;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.TokenPredicatesCondition;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.Trie;

public class TokenPredicateSet
implements SQLTokenPredicateSet {
    private final List<TokenPredicatesCondition> conditions = new ArrayList<TokenPredicatesCondition>();
    private final Trie<TokenEntry, SQLTokenPredicate> conditionsByPrefix = new Trie(ExactTokenEntryComparator.INSTANCE, TokenEntryMatchingComparator.INSTANCE);
    private final Trie<TokenEntry, SQLTokenPredicate> conditionsBySuffix = new Trie(ExactTokenEntryComparator.INSTANCE, TokenEntryMatchingComparator.INSTANCE);
    private int maxHeadLength = 0;
    private int maxTailLength = 0;

    @NotNull
    public TrieNode<TokenEntry, SQLTokenPredicate> getPrefixTreeRoot() {
        return this.conditionsByPrefix.getRoot();
    }

    public int getMaxPrefixLength() {
        return this.maxHeadLength;
    }

    public int getMaxSuffixLength() {
        return this.maxTailLength;
    }

    public void add(@NotNull TokenPredicatesCondition cond) {
        this.conditions.add(cond);
        cond.getPrefixes().forEach(h -> this.conditionsByPrefix.add(h.iterator(), (SQLTokenPredicate)cond));
        cond.getSuffixes().forEach(t -> this.conditionsBySuffix.add(new ArrayDeque(t).descendingIterator(), (SQLTokenPredicate)cond));
        this.maxHeadLength = Math.max(this.maxHeadLength, cond.maxPrefixLength);
        this.maxTailLength = Math.max(this.maxTailLength, cond.maxSuffixLength);
    }

    @NotNull
    public static TokenPredicateSet of(TokenPredicatesCondition ... conditions) {
        TokenPredicateSet set = new TokenPredicateSet();
        TokenPredicatesCondition[] tokenPredicatesConditionArray = conditions;
        int n = conditions.length;
        int n2 = 0;
        while (n2 < n) {
            TokenPredicatesCondition cond = tokenPredicatesConditionArray[n2];
            set.add(cond);
            ++n2;
        }
        return set;
    }

    @NotNull
    public Set<SQLTokenPredicate> matchSuffix(@NotNull Deque<TokenEntry> suffix) {
        return this.conditionsBySuffix.collectValuesOnPath(suffix.descendingIterator());
    }

    public boolean anyMatches(@NotNull Deque<TokenEntry> prefix, @NotNull Deque<TokenEntry> suffix) {
        Set<SQLTokenPredicate> matchedConds = this.conditionsBySuffix.collectValuesOnPath(suffix.descendingIterator());
        if (matchedConds.isEmpty()) {
            return false;
        }
        Set<SQLTokenPredicate> matchedHeadConds = this.conditionsByPrefix.collectValuesOnPath(prefix.iterator());
        matchedConds.retainAll(matchedHeadConds);
        return matchedConds.size() > 0;
    }
}

