/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.vertica.model;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Collection;
import java.util.Locale;
import org.eclipse.osgi.util.NLS;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.vertica.internal.VerticaMessages;
import org.jkiss.dbeaver.ext.vertica.model.VerticaChangeUserPasswordManager;
import org.jkiss.dbeaver.ext.vertica.model.VerticaNode;
import org.jkiss.dbeaver.ext.vertica.model.VerticaSQLDialect;
import org.jkiss.dbeaver.ext.vertica.model.VerticaStructureAssistant;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.access.DBAUserPasswordManager;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class VerticaDataSource
extends GenericDataSource {
    private static final Log log = Log.getLog(VerticaDataSource.class);
    private static final String VERTICA_GENERAL_WARNING_CODE = "01000";
    private static final String VERTICA_EXPIRED_PASSWORD_CODE = "100069";
    private Boolean childObjectColumnAvailable;
    private boolean isPasswordExpireWarningShown;
    private NodeCache nodeCache = new NodeCache();

    public VerticaDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container, GenericMetaModel metaModel) throws DBException {
        super(monitor, container, metaModel, (SQLDialect)new VerticaSQLDialect());
    }

    protected boolean isPopulateClientAppName() {
        return false;
    }

    public boolean isOmitCatalog() {
        return true;
    }

    @NotNull
    public DBPDataKind resolveDataKind(@NotNull String typeName, int valueType) {
        int divPos = typeName.indexOf(40);
        if (divPos != -1) {
            typeName = typeName.substring(0, divPos);
        }
        switch (typeName = typeName.trim().toLowerCase(Locale.ENGLISH)) {
            case "binary": 
            case "varbinary": 
            case "raw": 
            case "bytea": 
            case "long varbinary": {
                return DBPDataKind.BINARY;
            }
            case "boolean": {
                return DBPDataKind.BOOLEAN;
            }
            case "char": 
            case "varchar": 
            case "long varchar": {
                return DBPDataKind.STRING;
            }
            case "interval day": 
            case "time with timezone": 
            case "timetz": 
            case "smalldatetime": 
            case "timestamp with timezone": 
            case "date": 
            case "time": 
            case "timestamp": 
            case "interval": 
            case "timestamptz": 
            case "datetime": {
                return DBPDataKind.DATETIME;
            }
            case "numeric": 
            case "bigint": 
            case "tinyint": 
            case "float8": 
            case "number": 
            case "double precision": 
            case "smallint": 
            case "int": 
            case "int8": 
            case "real": 
            case "float": 
            case "money": 
            case "decimal": 
            case "integer": {
                return DBPDataKind.NUMERIC;
            }
        }
        return DBPDataKind.OBJECT;
    }

    protected Connection openConnection(@NotNull DBRProgressMonitor monitor, @Nullable JDBCExecutionContext context, @NotNull String purpose) throws DBCException {
        Connection connection = super.openConnection(monitor, context, purpose);
        try {
            SQLWarning warning = connection.getWarnings();
            while (warning != null && !this.isPasswordExpireWarningShown) {
                if (this.checkForPasswordWillExpireWarning(warning)) {
                    this.isPasswordExpireWarningShown = true;
                }
                warning = warning.getNextWarning();
            }
        }
        catch (SQLException e) {
            log.debug((Object)"Can't get connection warnings", (Throwable)e);
        }
        return connection;
    }

    private boolean checkForPasswordWillExpireWarning(@NotNull SQLWarning warning) {
        if (CommonUtils.isNotEmpty((String)warning.getSQLState()) && VERTICA_GENERAL_WARNING_CODE.equals(warning.getSQLState()) && CommonUtils.isNotEmpty((String)warning.getMessage()) && warning.getMessage().contains("(100069)")) {
            DBWorkbench.getPlatformUI().showWarningMessageBox(VerticaMessages.vertica_password_will_expire_warn_name, NLS.bind((String)VerticaMessages.vertica_password_will_expire_warn_description, (Object)warning.getMessage()));
            return true;
        }
        return false;
    }

    @Association
    public Collection<VerticaNode> getClusterNodes(DBRProgressMonitor monitor) throws DBException {
        return this.nodeCache.getAllObjects(monitor, (DBSObject)this);
    }

    public VerticaNode getClusterNode(DBRProgressMonitor monitor, String name) throws DBException {
        return (VerticaNode)this.nodeCache.getObject(monitor, (DBSObject)this, name);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBAUserPasswordManager.class) {
            return adapter.cast(new VerticaChangeUserPasswordManager(this));
        }
        if (adapter == DBSStructureAssistant.class) {
            return adapter.cast((Object)new VerticaStructureAssistant(this));
        }
        return (T)super.getAdapter(adapter);
    }

    public boolean isChildCommentColumnAvailable(@NotNull DBRProgressMonitor monitor) {
        if (this.childObjectColumnAvailable == null) {
            try {
                Throwable throwable = null;
                Object var3_4 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Check child comment column existence");){
                    Throwable throwable2 = null;
                    Object var6_9 = null;
                    try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT child_object FROM v_catalog.comments WHERE 1<>1");){
                        dbStat.setFetchSize(1);
                        dbStat.execute();
                        this.childObjectColumnAvailable = true;
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                this.childObjectColumnAvailable = false;
            }
        }
        return this.childObjectColumnAvailable;
    }

    class NodeCache
    extends JDBCObjectCache<VerticaDataSource, VerticaNode> {
        NodeCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull VerticaDataSource mySQLTable) throws SQLException {
            return session.prepareStatement("SELECT * FROM v_catalog.nodes ORDER BY nodE_name");
        }

        protected VerticaNode fetchObject(@NotNull JDBCSession session, @NotNull VerticaDataSource dataSource, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new VerticaNode(dataSource, dbResult);
        }
    }
}

