/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.fs;

import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.fs.DBFFileSystemDescriptor;
import org.jkiss.dbeaver.model.fs.DBFFileSystemProvider;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;

public class FileSystemProviderDescriptor
extends AbstractDescriptor
implements DBFFileSystemDescriptor {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.fileSystem";
    private final String id;
    private final String label;
    private final String description;
    private final DBPImage icon;
    private final AbstractDescriptor.ObjectType implClass;
    private DBFFileSystemProvider instance;

    public FileSystemProviderDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.label = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.icon = this.iconToImage(config.getAttribute("icon"));
        this.implClass = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public DBPImage getIcon() {
        return this.icon;
    }

    @NotNull
    public synchronized DBFFileSystemProvider getInstance() {
        if (this.instance == null) {
            try {
                this.instance = (DBFFileSystemProvider)this.implClass.createInstance(DBFFileSystemProvider.class);
            }
            catch (DBException e) {
                throw new IllegalStateException("Error instantiating file system provider " + this.id, e);
            }
        }
        return this.instance;
    }

    public String toString() {
        return this.getLabel();
    }
}

