/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.directedit;

import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.Label;
import org.eclipse.gef3.EditPolicy;
import org.eclipse.gef3.GraphicalEditPart;
import org.eclipse.gef3.Request;
import org.eclipse.gef3.commands.Command;
import org.eclipse.gef3.commands.CommandStack;
import org.eclipse.gef3.tools.CellEditorLocator;
import org.eclipse.gef3.tools.DirectEditManager;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.erd.ui.figures.NoteFigure;

public class ExtendedDirectEditManager
extends DirectEditManager {
    private VerifyListener verifyListener;
    private final IFigure figure;
    private String originalValue;
    private boolean committing = false;
    private final ICellEditorValidator validator;

    public ExtendedDirectEditManager(GraphicalEditPart source, Class<?> editorType, CellEditorLocator locator, IFigure figure, ICellEditorValidator validator) {
        super(source, editorType, locator);
        this.figure = figure;
        this.originalValue = ExtendedDirectEditManager.getFigureText(figure);
        this.validator = validator;
    }

    protected IFigure getCellEditorFrame() {
        IFigure cellEditorFrame = super.getCellEditorFrame();
        cellEditorFrame.getBorder();
        return cellEditorFrame;
    }

    private static String getFigureText(IFigure figure) {
        if (figure instanceof Label) {
            return ((Label)figure).getText();
        }
        if (figure instanceof NoteFigure) {
            return ((NoteFigure)figure).getText();
        }
        return "???";
    }

    protected void initCellEditor() {
        Text text = (Text)this.getCellEditor().getControl();
        this.verifyListener = new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                Text text = (Text)ExtendedDirectEditManager.this.getCellEditor().getControl();
                String oldText = text.getText();
                String leftText = oldText.substring(0, event.start);
                String rightText = oldText.substring(event.end);
                GC gc = new GC((Drawable)text);
                Point size = gc.textExtent(String.valueOf(leftText) + event.text + rightText);
                gc.dispose();
                if (size.x != 0) {
                    size = text.computeSize(size.x, -1);
                } else {
                    size.x = size.y;
                }
                ExtendedDirectEditManager.this.getCellEditor().getControl().setSize(size.x, size.y);
            }
        };
        text.addVerifyListener(this.verifyListener);
        this.originalValue = ExtendedDirectEditManager.getFigureText(this.figure);
        this.getCellEditor().setValue((Object)this.originalValue);
        this.getCellEditor().setValidator(this.validator);
        text.selectAll();
    }

    protected void commit() {
        if (this.committing) {
            return;
        }
        this.committing = true;
        try {
            if (this.isDirty()) {
                CommandStack stack = this.getEditPart().getViewer().getEditDomain().getCommandStack();
                EditPolicy editPolicy = this.getEditPart().getEditPolicy((Object)"DirectEditPolicy");
                Command command = editPolicy != null ? editPolicy.getCommand((Request)this.getDirectEditRequest()) : this.getEditPart().getCommand((Request)this.getDirectEditRequest());
                if (command != null && command.canExecute()) {
                    stack.execute(command);
                }
            }
        }
        finally {
            this.bringDown();
            this.committing = false;
        }
    }

    protected void unhookListeners() {
        super.unhookListeners();
        Text text = (Text)this.getCellEditor().getControl();
        text.removeVerifyListener(this.verifyListener);
        this.verifyListener = null;
    }
}

