/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.command;

import java.util.List;
import org.eclipse.gef3.commands.Command;
import org.jkiss.dbeaver.erd.model.ERDAssociation;
import org.jkiss.dbeaver.erd.model.ERDElement;

public class AssociationReconnectTargetCommand
extends Command {
    protected ERDElement sourceEntity;
    protected ERDElement targetEntity;
    protected ERDAssociation relationship;
    protected ERDElement oldTargetEntity;

    public boolean canExecute() {
        boolean returnVal = true;
        ERDElement foreignKeyEntity = this.relationship.getSourceEntity();
        if (foreignKeyEntity.equals(this.targetEntity)) {
            returnVal = false;
        } else {
            List relationships = this.targetEntity.getReferences();
            for (ERDAssociation relationship : relationships) {
                if (!relationship.getSourceEntity().equals(this.sourceEntity) || !relationship.getTargetEntity().equals(this.targetEntity)) continue;
                returnVal = false;
                break;
            }
        }
        return returnVal;
    }

    public void execute() {
        if (this.targetEntity != null) {
            this.oldTargetEntity.removeReferenceAssociation(this.relationship, true);
            this.relationship.setTargetEntity(this.targetEntity);
            this.targetEntity.addReferenceAssociation(this.relationship, true);
        }
    }

    public void setTargetEntity(ERDElement targetEntity) {
        this.targetEntity = targetEntity;
    }

    public void setRelationship(ERDAssociation relationship) {
        this.relationship = relationship;
        this.oldTargetEntity = relationship.getTargetEntity();
        this.sourceEntity = relationship.getSourceEntity();
    }

    public void undo() {
        this.targetEntity.removeReferenceAssociation(this.relationship, true);
        this.relationship.setTargetEntity(this.oldTargetEntity);
        this.oldTargetEntity.addReferenceAssociation(this.relationship, true);
    }
}

