/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.util.HashMap;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataType;
import org.jkiss.dbeaver.ext.oracle.model.OracleJavaClass;
import org.jkiss.dbeaver.ext.oracle.model.OraclePackage;
import org.jkiss.dbeaver.ext.oracle.model.OracleProcedureStandalone;
import org.jkiss.dbeaver.ext.oracle.model.OracleQueue;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleSequence;
import org.jkiss.dbeaver.ext.oracle.model.OracleSynonym;
import org.jkiss.dbeaver.ext.oracle.model.OracleTable;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableBase;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableConstraint;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableForeignKey;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableIndex;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableTrigger;
import org.jkiss.dbeaver.ext.oracle.model.OracleTrigger;
import org.jkiss.dbeaver.ext.oracle.model.OracleView;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectType;

public enum OracleObjectType implements DBSObjectType
{
    CLUSTER("CLUSTER", null, DBSObject.class, null),
    CONSTRAINT("CONSTRAINT", (DBPImage)DBIcon.TREE_CONSTRAINT, OracleTableConstraint.class, null),
    CONSUMER_GROUP("CONSUMER GROUP", null, DBSObject.class, null),
    CONTEXT("CONTEXT", null, DBSObject.class, null),
    DIRECTORY("DIRECTORY", null, DBSObject.class, null),
    EVALUATION_CONTEXT("EVALUATION CONTEXT", null, DBSObject.class, null),
    FOREIGN_KEY("FOREIGN KEY", (DBPImage)DBIcon.TREE_FOREIGN_KEY, OracleTableForeignKey.class, null),
    FUNCTION("FUNCTION", (DBPImage)DBIcon.TREE_PROCEDURE, OracleProcedureStandalone.class, new ObjectFinder(){

        @Override
        public OracleProcedureStandalone findObject(DBRProgressMonitor monitor, OracleSchema schema, String objectName) throws DBException {
            return (OracleProcedureStandalone)schema.proceduresCache.getObject(monitor, schema, objectName);
        }
    }),
    INDEX("INDEX", (DBPImage)DBIcon.TREE_INDEX, OracleTableIndex.class, new ObjectFinder(){

        public OracleTableIndex findObject(DBRProgressMonitor monitor, OracleSchema schema, String objectName) throws DBException {
            return (OracleTableIndex)schema.indexCache.getObject(monitor, schema, objectName);
        }
    }),
    INDEX_PARTITION("INDEX PARTITION", null, DBSObject.class, null),
    INDEXTYPE("INDEXTYPE", null, DBSObject.class, null),
    JAVA_CLASS("JAVA CLASS", (DBPImage)DBIcon.TREE_JAVA_CLASS, OracleJavaClass.class, new ObjectFinder(){

        @Override
        public OracleJavaClass findObject(DBRProgressMonitor monitor, OracleSchema schema, String objectName) throws DBException {
            return (OracleJavaClass)schema.javaCache.getObject(monitor, schema, objectName);
        }
    }),
    JAVA_DATA("JAVA DATA", null, DBSObject.class, null),
    JAVA_RESOURCE("JAVA RESOURCE", null, DBSObject.class, null),
    JOB("JOB", null, DBSObject.class, null),
    JOB_CLASS("JOB CLASS", null, DBSObject.class, null),
    LIBRARY("LIBRARY", null, DBSObject.class, null),
    LOB("CONTENT", null, DBSObject.class, null),
    MATERIALIZED_VIEW("MATERIALIZED VIEW", (DBPImage)DBIcon.TREE_VIEW, DBSObject.class, null),
    OPERATOR("OPERATOR", null, DBSObject.class, null),
    PACKAGE("PACKAGE", (DBPImage)DBIcon.TREE_PACKAGE, OraclePackage.class, new ObjectFinder(){

        @Override
        public OraclePackage findObject(DBRProgressMonitor monitor, OracleSchema schema, String objectName) throws DBException {
            return (OraclePackage)schema.packageCache.getObject(monitor, schema, objectName);
        }
    }),
    PACKAGE_BODY("PACKAGE BODY", (DBPImage)DBIcon.TREE_PACKAGE, OraclePackage.class, new ObjectFinder(){

        @Override
        public OraclePackage findObject(DBRProgressMonitor monitor, OracleSchema schema, String objectName) throws DBException {
            return (OraclePackage)schema.packageCache.getObject(monitor, schema, objectName);
        }
    }),
    PROCEDURE("PROCEDURE", (DBPImage)DBIcon.TREE_PROCEDURE, OracleProcedureStandalone.class, new ObjectFinder(){

        @Override
        public OracleProcedureStandalone findObject(DBRProgressMonitor monitor, OracleSchema schema, String objectName) throws DBException {
            return (OracleProcedureStandalone)schema.proceduresCache.getObject(monitor, schema, objectName);
        }
    }),
    PROGRAM("PROGRAM", null, DBSObject.class, null),
    QUEUE("QUEUE", null, OracleQueue.class, new ObjectFinder(){

        @Override
        public OracleQueue findObject(DBRProgressMonitor monitor, OracleSchema schema, String objectName) throws DBException {
            return (OracleQueue)schema.queueCache.getObject(monitor, schema, objectName);
        }
    }),
    RULE("RULE", null, DBSObject.class, null),
    RULE_SET("RULE SET", null, DBSObject.class, null),
    SCHEDULE("SCHEDULE", null, DBSObject.class, null),
    SEQUENCE("SEQUENCE", (DBPImage)DBIcon.TREE_SEQUENCE, OracleSequence.class, new ObjectFinder(){

        @Override
        public OracleSequence findObject(DBRProgressMonitor monitor, OracleSchema schema, String objectName) throws DBException {
            return (OracleSequence)schema.sequenceCache.getObject(monitor, schema, objectName);
        }
    }),
    SYNONYM("SYNONYM", (DBPImage)DBIcon.TREE_SYNONYM, OracleSynonym.class, new ObjectFinder(){

        @Override
        public OracleSynonym findObject(DBRProgressMonitor monitor, OracleSchema schema, String objectName) throws DBException {
            return (OracleSynonym)schema.synonymCache.getObject(monitor, schema, objectName);
        }
    }),
    TABLE("TABLE", (DBPImage)DBIcon.TREE_TABLE, OracleTable.class, new ObjectFinder(){

        @Override
        public OracleTableBase findObject(DBRProgressMonitor monitor, OracleSchema schema, String objectName) throws DBException {
            return (OracleTableBase)schema.tableCache.getObject(monitor, schema, objectName);
        }
    }),
    TABLE_PARTITION("TABLE PARTITION", null, DBSObject.class, null),
    TRIGGER("TRIGGER", (DBPImage)DBIcon.TREE_TRIGGER, OracleTrigger.class, new ObjectFinder(){

        @Override
        public OracleTrigger findObject(DBRProgressMonitor monitor, OracleSchema schema, String objectName) throws DBException {
            OracleTableTrigger trigger = (OracleTableTrigger)schema.tableTriggerCache.getObject(monitor, schema, objectName);
            if (trigger != null) {
                return trigger;
            }
            return (OracleTrigger)schema.triggerCache.getObject(monitor, schema, objectName);
        }
    }),
    TYPE("TYPE", (DBPImage)DBIcon.TREE_DATA_TYPE, OracleDataType.class, new ObjectFinder(){

        @Override
        public OracleDataType findObject(DBRProgressMonitor monitor, OracleSchema schema, String objectName) throws DBException {
            return (OracleDataType)schema.dataTypeCache.getObject(monitor, schema, objectName);
        }
    }),
    TYPE_BODY("TYPE BODY", (DBPImage)DBIcon.TREE_DATA_TYPE, OracleDataType.class, new ObjectFinder(){

        @Override
        public OracleDataType findObject(DBRProgressMonitor monitor, OracleSchema schema, String objectName) throws DBException {
            return (OracleDataType)schema.dataTypeCache.getObject(monitor, schema, objectName);
        }
    }),
    VIEW("VIEW", (DBPImage)DBIcon.TREE_VIEW, OracleView.class, new ObjectFinder(){

        @Override
        public OracleView findObject(DBRProgressMonitor monitor, OracleSchema schema, String objectName) throws DBException {
            return (OracleView)schema.tableCache.getObject(monitor, schema, objectName, OracleView.class);
        }
    }),
    WINDOW("WINDOW", null, DBSObject.class, null),
    WINDOW_GROUP("WINDOW GROUP", null, DBSObject.class, null),
    XML_SCHEMA("XML SCHEMA", null, DBSObject.class, null);

    private static final Log log;
    private static Map<String, OracleObjectType> typeMap;
    private final String objectType;
    private final DBPImage image;
    private final Class<? extends DBSObject> typeClass;
    private final ObjectFinder finder;

    static {
        log = Log.getLog(OracleObjectType.class);
        typeMap = new HashMap<String, OracleObjectType>();
        OracleObjectType[] oracleObjectTypeArray = OracleObjectType.values();
        int n = oracleObjectTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            OracleObjectType type = oracleObjectTypeArray[n2];
            typeMap.put(type.getTypeName(), type);
            ++n2;
        }
    }

    public static OracleObjectType getByType(String typeName) {
        return typeMap.get(typeName);
    }

    private <OBJECT_TYPE extends DBSObject> OracleObjectType(String objectType, DBPImage image, Class<OBJECT_TYPE> typeClass, ObjectFinder finder) {
        this.objectType = objectType;
        this.image = image;
        this.typeClass = typeClass;
        this.finder = finder;
    }

    public boolean isBrowsable() {
        return this.finder != null;
    }

    public String getTypeName() {
        return this.objectType;
    }

    public String getDescription() {
        return null;
    }

    public DBPImage getImage() {
        return this.image;
    }

    public Class<? extends DBSObject> getTypeClass() {
        return this.typeClass;
    }

    public DBSObject findObject(DBRProgressMonitor monitor, OracleSchema schema, String objectName) throws DBException {
        if (this.finder != null) {
            return this.finder.findObject(monitor, schema, objectName);
        }
        return null;
    }

    public static Object resolveObject(DBRProgressMonitor monitor, OracleDataSource dataSource, String dbLink, String objectTypeName, String objectOwner, String objectName) throws DBException {
        if (dbLink != null) {
            return objectName;
        }
        OracleObjectType objectType = OracleObjectType.getByType(objectTypeName);
        if (objectType == null) {
            log.debug((Object)("Unrecognized Oracle object type: " + objectTypeName));
            return objectName;
        }
        if (!objectType.isBrowsable()) {
            log.debug((Object)("Unsupported Oracle object type: " + objectTypeName));
            return objectName;
        }
        OracleSchema schema = dataSource.getSchema(monitor, objectOwner);
        if (schema == null) {
            log.debug((Object)("Schema '" + objectOwner + "' not found"));
            return objectName;
        }
        DBSObject object = objectType.findObject(monitor, schema, objectName);
        if (object == null) {
            log.debug((Object)(String.valueOf(objectTypeName) + " '" + objectName + "' not found in '" + schema.getName() + "'"));
            return objectName;
        }
        return object;
    }

    public String toString() {
        return this.objectType;
    }

    private static interface ObjectFinder {
        public DBSObject findObject(DBRProgressMonitor var1, OracleSchema var2, String var3) throws DBException;
    }
}

