/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistActionAtomic;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public class PostgreSchemaManager
extends SQLObjectEditor<PostgreSchema, PostgreDatabase>
implements DBEObjectRenamer<PostgreSchema> {
    public long getMakerOptions(DBPDataSource dataSource) {
        return 1L;
    }

    @Nullable
    public DBSObjectCache<PostgreDatabase, PostgreSchema> getObjectsCache(PostgreSchema object) {
        return object.getDatabase().schemaCache;
    }

    protected PostgreSchema createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        PostgreDatabase database = (PostgreDatabase)container;
        return database.createSchemaImpl(database, "NewSchema", (PostgreRole)null);
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        PostgreSchema schema = (PostgreSchema)command.getObject();
        StringBuilder script = new StringBuilder("CREATE SCHEMA " + DBUtils.getQuotedIdentifier((DBSObject)schema));
        try {
            PostgreRole owner = schema.getOwner(monitor);
            if (owner != null) {
                script.append("\nAUTHORIZATION ").append(DBUtils.getQuotedIdentifier((DBSObject)owner));
            }
        }
        catch (DBException e) {
            log.error((Object)e);
        }
        actions.add((DBEPersistAction)new CreateSchemaAction(schema, script));
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop schema", "DROP SCHEMA " + DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)command.getObject())) + " CASCADE"));
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename schema", "ALTER SCHEMA " + DBUtils.getQuotedIdentifier((DBPDataSource)((PostgreSchema)command.getObject()).getDataSource(), (String)command.getOldName()) + " RENAME TO " + DBUtils.getQuotedIdentifier((DBPDataSource)((PostgreSchema)command.getObject()).getDataSource(), (String)command.getNewName())));
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull PostgreSchema schema, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, schema, options, newName);
    }

    protected void addObjectExtraActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.NestedObjectCommand<PostgreSchema, SQLObjectEditor.PropertyHandler> command, Map<String, Object> options) {
        PostgreSchema schema = (PostgreSchema)command.getObject();
        String comment = schema.getDescription();
        if (comment != null) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Comment schema", "COMMENT ON SCHEMA " + DBUtils.getQuotedIdentifier((DBSObject)schema) + " IS " + SQLUtils.quoteString((DBSObject)schema, (String)comment)));
        }
    }

    private static class CreateSchemaAction
    extends SQLDatabasePersistActionAtomic {
        private final PostgreSchema schema;

        public CreateSchemaAction(PostgreSchema schema, StringBuilder sql) {
            super("Create schema", sql.toString());
            this.schema = schema;
        }

        public void afterExecute(DBCSession session, Throwable error) throws DBCException {
            super.afterExecute(session, error);
            if (error == null) {
                this.schema.readSchemaInfo(session.getProgressMonitor());
            }
        }
    }
}

