/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceViewDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.network.NetworkHandlerDescriptor;
import org.jkiss.dbeaver.registry.network.NetworkHandlerRegistry;
import org.jkiss.dbeaver.ui.ICompositeDialogPageContainer;
import org.jkiss.dbeaver.ui.IDataSourceConnectionEditor;
import org.jkiss.dbeaver.ui.IDataSourceConnectionEditorSite;
import org.jkiss.dbeaver.ui.IDataSourceConnectionTester;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageNetworkHandler;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionWizard;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionWizardPage;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverEditDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

class ConnectionPageSettings
extends ActiveWizardPage<ConnectionWizard>
implements IDataSourceConnectionEditorSite,
IDialogPageProvider,
ICompositeDialogPageContainer,
IDataSourceConnectionTester {
    private static final Log log = Log.getLog(DriverDescriptor.class);
    public static final String PAGE_NAME = ConnectionPageSettings.class.getSimpleName();
    @NotNull
    private final ConnectionWizard wizard;
    @NotNull
    private final DataSourceViewDescriptor viewDescriptor;
    @Nullable
    private IDataSourceConnectionEditor connectionEditor;
    @Nullable
    private DataSourceDescriptor dataSource;
    private final Set<DataSourceDescriptor> activated = new HashSet<DataSourceDescriptor>();
    private IDialogPage[] subPages;
    private IDialogPage[] extraPages;
    private TabFolder tabFolder;

    ConnectionPageSettings(@NotNull ConnectionWizard wizard, @NotNull DataSourceViewDescriptor viewDescriptor) {
        super(String.valueOf(PAGE_NAME) + "." + viewDescriptor.getId());
        this.wizard = wizard;
        this.viewDescriptor = viewDescriptor;
        this.setTitle(wizard.isNew() ? viewDescriptor.getLabel() : CoreMessages.dialog_setting_connection_wizard_title);
        this.setDescription(CoreMessages.dialog_connection_description);
    }

    ConnectionPageSettings(@NotNull ConnectionWizard wizard, @NotNull DataSourceViewDescriptor viewDescriptor, @Nullable DataSourceDescriptor dataSource) {
        this(wizard, viewDescriptor);
        this.dataSource = dataSource;
    }

    IDataSourceConnectionEditor getConnectionEditor() {
        return this.connectionEditor;
    }

    public void activatePage() {
        if (this.connectionEditor == null) {
            this.createProviderPage(this.getControl().getParent());
        }
        Control control = this.getControl();
        control.setRedraw(false);
        try {
            this.setDescription(NLS.bind((String)CoreMessages.dialog_connection_message, (Object)this.getDriver().getFullName()));
            DataSourceDescriptor connectionInfo = this.getActiveDataSource();
            if (!this.activated.contains(connectionInfo)) {
                if (this.connectionEditor != null) {
                    this.connectionEditor.loadSettings();
                }
                if (this.subPages != null) {
                    IDialogPage[] iDialogPageArray = this.subPages;
                    int n = this.subPages.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IDialogPage page = iDialogPageArray[n2];
                        Control pageControl = page.getControl();
                        if (pageControl != null && page instanceof IDataSourceConnectionEditor) {
                            ((IDataSourceConnectionEditor)page).loadSettings();
                        }
                        ++n2;
                    }
                }
                this.activated.add(connectionInfo);
            } else if (this.connectionEditor != null) {
                this.connectionEditor.loadSettings();
            }
            this.activateCurrentItem();
        }
        finally {
            control.setRedraw(true);
        }
    }

    public void deactivatePage() {
        DataSourceDescriptor connectionInfo = this.getActiveDataSource();
        if (this.activated.contains(connectionInfo) && this.connectionEditor != null) {
            this.connectionEditor.saveSettings((DBPDataSourceContainer)connectionInfo);
        }
        super.deactivatePage();
    }

    public Image getImage() {
        Image image;
        if (this.connectionEditor != null && (image = this.connectionEditor.getImage()) != null) {
            return image;
        }
        return super.getImage();
    }

    void saveSettings(DataSourceDescriptor dataSource) {
        if (this.subPages != null) {
            IDialogPage[] iDialogPageArray = this.subPages;
            int n = this.subPages.length;
            int n2 = 0;
            while (n2 < n) {
                IDialogPage page = iDialogPageArray[n2];
                if (!ArrayUtils.contains((Object[])this.extraPages, (Object)page)) {
                    if (page.getControl() != null && page instanceof IDataSourceConnectionEditor) {
                        ((IDataSourceConnectionEditor)page).saveSettings((DBPDataSourceContainer)dataSource);
                    } else if (page instanceof ConnectionWizardPage) {
                        ((ConnectionWizardPage)page).saveSettings((DBPDataSourceContainer)dataSource);
                    }
                }
                ++n2;
            }
        }
        if (this.connectionEditor != null) {
            this.connectionEditor.saveSettings((DBPDataSourceContainer)dataSource);
        }
    }

    public void createControl(Composite parent) {
        if (this.wizard.isNew()) {
            this.setControl((Control)new Composite(parent, 2048));
        } else {
            this.createProviderPage(parent);
        }
    }

    private void createProviderPage(Composite parent) {
        if (this.connectionEditor != null && this.connectionEditor.getControl() != null) {
            return;
        }
        if (this.getControl() != null) {
            this.getControl().dispose();
        }
        try {
            if (this.connectionEditor == null) {
                this.connectionEditor = (IDataSourceConnectionEditor)this.viewDescriptor.createView(IDataSourceConnectionEditor.class);
                this.connectionEditor.setSite((IDataSourceConnectionEditorSite)this);
            }
            Object[] allSubPages = this.getDialogPages(false, true);
            ArrayList<IDataSourceConnectionEditor> allPages = new ArrayList<IDataSourceConnectionEditor>();
            allPages.add(this.connectionEditor);
            if (!ArrayUtils.isEmpty((Object[])allSubPages)) {
                Collections.addAll(allPages, allSubPages);
            }
            this.tabFolder = new TabFolder(parent, 128);
            this.tabFolder.setLayoutData((Object)new GridData(1808));
            this.setControl((Control)this.tabFolder);
            for (IDialogPage iDialogPage : allPages) {
                if (ArrayUtils.contains((Object[])this.extraPages, (Object)iDialogPage)) continue;
                TabItem item = new TabItem(this.tabFolder, 0);
                iDialogPage.createControl((Composite)this.tabFolder);
                item.setData((Object)iDialogPage);
                Control pageControl = iDialogPage.getControl();
                item.setControl(pageControl);
                item.setText(CommonUtils.isEmpty((String)iDialogPage.getTitle()) ? CoreMessages.dialog_setting_connection_general : iDialogPage.getTitle());
                item.setToolTipText(iDialogPage.getDescription());
            }
            this.tabFolder.setSelection(0);
            this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConnectionPageSettings.this.activateCurrentItem();
                }
            });
            UIUtils.setHelp((Control)this.getControl(), (String)"con-wizard-settings");
        }
        catch (Exception ex) {
            log.warn((Object)ex);
            this.setErrorMessage("Can't create settings dialog: " + ex.getMessage());
        }
        parent.layout();
    }

    private void activateCurrentItem() {
        TabItem[] selection;
        if (this.tabFolder != null && (selection = this.tabFolder.getSelection()).length == 1) {
            IDialogPage page = (IDialogPage)selection[0].getData();
            page.setVisible(true);
        }
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public boolean isPageComplete() {
        return this.wizard.getPageSettings() != this || this.connectionEditor != null && this.connectionEditor.isComplete();
    }

    public DBRRunnableContext getRunnableContext() {
        return this.wizard.getRunnableContext();
    }

    public DBPDataSourceRegistry getDataSourceRegistry() {
        return this.wizard.getDataSourceRegistry();
    }

    public boolean isNew() {
        return this.wizard.isNew();
    }

    public DBPDriver getDriver() {
        return this.wizard.getSelectedDriver();
    }

    @NotNull
    public DataSourceDescriptor getActiveDataSource() {
        if (this.dataSource != null) {
            return this.dataSource;
        }
        return this.wizard.getActiveDataSource();
    }

    public void updateButtons() {
        ((ConnectionWizard)this.getWizard()).getContainer().updateButtons();
    }

    public boolean openDriverEditor() {
        DriverEditDialog dialog = new DriverEditDialog(this.wizard.getShell(), (DBPDriver)((DriverDescriptor)this.getDriver()));
        return dialog.open() == 0;
    }

    public boolean openSettingsPage(String pageId) {
        return this.wizard.openSettingsPage(pageId);
    }

    public void testConnection() {
        ((ConnectionWizard)this.getWizard()).testConnection();
    }

    public DBPProject getProject() {
        DBPDataSourceRegistry registry = this.wizard.getDataSourceRegistry();
        return registry == null ? null : registry.getProject();
    }

    public void firePropertyChange(Object source, String property, Object oldValue, Object newValue) {
        PropertyChangeEvent pcEvent = new PropertyChangeEvent(source, property, oldValue, newValue);
        TabItem[] tabItemArray = this.tabFolder.getItems();
        int n = tabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TabItem item = tabItemArray[n2];
            IDialogPage page = (IDialogPage)item.getData();
            if (page instanceof IPropertyChangeListener) {
                ((IPropertyChangeListener)page).propertyChange(pcEvent);
            }
            ++n2;
        }
        tabItemArray = ((ConnectionWizard)this.getWizard()).getPages();
        n = tabItemArray.length;
        n2 = 0;
        while (n2 < n) {
            TabItem page = tabItemArray[n2];
            if (page instanceof IPropertyChangeListener) {
                ((IPropertyChangeListener)page).propertyChange(pcEvent);
            }
            ++n2;
        }
    }

    public void dispose() {
        if (this.connectionEditor != null) {
            this.connectionEditor.dispose();
            this.connectionEditor = null;
        }
        super.dispose();
    }

    @Nullable
    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        if (extrasOnly) {
            return this.extraPages;
        }
        if (this.subPages != null) {
            return this.subPages;
        }
        if (!forceCreate) {
            return new IDialogPage[0];
        }
        if (this.connectionEditor == null) {
            this.connectionEditor = (IDataSourceConnectionEditor)this.viewDescriptor.createView(IDataSourceConnectionEditor.class);
            this.connectionEditor.setSite((IDataSourceConnectionEditorSite)this);
        }
        if (this.connectionEditor instanceof IDialogPageProvider) {
            this.subPages = ((IDialogPageProvider)this.connectionEditor).getDialogPages(extrasOnly, true);
            if (this.isNew() || !this.getDriver().isEmbedded()) {
                for (NetworkHandlerDescriptor descriptor : NetworkHandlerRegistry.getInstance().getDescriptors((DBPDataSourceContainer)this.getActiveDataSource())) {
                    this.subPages = (IDialogPage[])ArrayUtils.add(IDialogPage.class, (Object[])this.subPages, (Object)((Object)new ConnectionPageNetworkHandler(this, descriptor)));
                }
            }
            if (this.extraPages != null) {
                this.subPages = (IDialogPage[])ArrayUtils.concatArrays((Object[])this.subPages, (Object[])this.extraPages);
            }
            try {
                IDialogPage[] dialogPages;
                IDialogPageProvider externalPagesProvider = (IDialogPageProvider)GeneralUtils.adapt((Object)this.getActiveDataSource(), IDialogPageProvider.class);
                if (externalPagesProvider != null && (dialogPages = externalPagesProvider.getDialogPages(false, true)) != null) {
                    IDialogPage[] iDialogPageArray = dialogPages;
                    int n = dialogPages.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IDialogPage page = iDialogPageArray[n2];
                        if (page != null) {
                            this.subPages = (IDialogPage[])ArrayUtils.add(IDialogPage.class, (Object[])this.subPages, (Object)page);
                        }
                        ++n2;
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            if (!ArrayUtils.isEmpty((Object[])this.subPages)) {
                IDialogPage[] iDialogPageArray = this.subPages;
                int n = this.subPages.length;
                int n3 = 0;
                while (n3 < n) {
                    IDialogPage page = iDialogPageArray[n3];
                    if (page instanceof IDataSourceConnectionEditor) {
                        ((IDataSourceConnectionEditor)page).setSite((IDataSourceConnectionEditorSite)this);
                    }
                    ++n3;
                }
            }
            return this.subPages;
        }
        return this.extraPages;
    }

    public void addSubPage(IDialogPage page) {
        this.extraPages = this.extraPages == null ? new IDialogPage[]{page} : (IDialogPage[])ArrayUtils.concatArrays((Object[])this.extraPages, (Object[])new IDialogPage[]{page});
        if (page instanceof IWizardPage) {
            ((IWizardPage)page).setWizard(this.getWizard());
        }
    }

    public void testConnection(DBCSession session) {
        if (this.connectionEditor instanceof IDataSourceConnectionTester) {
            ((IDataSourceConnectionTester)this.connectionEditor).testConnection(session);
        }
    }

    public String toString() {
        return this.getName();
    }

    public void showSubPage(IDialogPage subPage) {
        TabItem[] selection = this.tabFolder.getSelection();
        TabItem[] tabItemArray = this.tabFolder.getItems();
        int n = tabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TabItem pageTab = tabItemArray[n2];
            if (pageTab.getData() == subPage) {
                if (selection.length == 1 && selection[0].getData() != subPage && selection[0].getData() instanceof ActiveWizardPage) {
                    ((ActiveWizardPage)selection[0].getData()).deactivatePage();
                }
                if (subPage instanceof ActiveWizardPage) {
                    ((ActiveWizardPage)subPage).activatePage();
                }
                this.tabFolder.setSelection(pageTab);
                break;
            }
            ++n2;
        }
    }
}

