/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.util.Collections;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerDescriptor;
import org.jkiss.dbeaver.model.net.DBWNetworkProfile;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorDescriptor;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorRegistry;
import org.jkiss.dbeaver.registry.network.NetworkHandlerDescriptor;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IDataSourceConnectionEditorSite;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionWizardPage;
import org.jkiss.utils.CommonUtils;

public class ConnectionPageNetworkHandler
extends ConnectionWizardPage
implements IPropertyChangeListener {
    private static final Log log = Log.getLog(ConnectionPageNetworkHandler.class);
    private static final String PROP_CONFIG_PROFILE = "configProfile";
    private final IDataSourceConnectionEditorSite site;
    private final NetworkHandlerDescriptor handlerDescriptor;
    private IObjectPropertyConfigurator<DBWHandlerConfiguration> configurator;
    private ControlEnableState blockEnableState;
    private DBWHandlerConfiguration handlerConfiguration;
    private Composite handlerComposite;
    private Combo profileCombo;
    private Button useHandlerCheck;
    private DBWNetworkProfile activeProfile;

    public ConnectionPageNetworkHandler(IDataSourceConnectionEditorSite site, NetworkHandlerDescriptor descriptor) {
        super(String.valueOf(ConnectionPageNetworkHandler.class.getSimpleName()) + "." + descriptor.getId());
        this.site = site;
        this.handlerDescriptor = descriptor;
        this.setTitle(descriptor.getCodeName());
        this.setDescription(descriptor.getDescription());
    }

    public void createControl(Composite parent) {
        DBWHandlerConfiguration profileConfig;
        try {
            String implName = this.handlerDescriptor.getHandlerType().getImplName();
            UIPropertyConfiguratorDescriptor configDescriptor = UIPropertyConfiguratorRegistry.getInstance().getDescriptor(implName);
            if (configDescriptor == null) {
                return;
            }
            this.configurator = configDescriptor.createConfigurator();
        }
        catch (DBException e) {
            log.error((Object)("Can't create network configurator '" + this.handlerDescriptor.getId() + "'"), (Throwable)e);
            return;
        }
        DBPDataSourceContainer dataSource = this.site.getActiveDataSource();
        DBPConnectionConfiguration connectionConfiguration = dataSource.getConnectionConfiguration();
        this.handlerConfiguration = connectionConfiguration.getHandler(this.handlerDescriptor.getId());
        if (this.handlerConfiguration == null) {
            this.handlerConfiguration = new DBWHandlerConfiguration((DBWHandlerDescriptor)this.handlerDescriptor, dataSource);
            connectionConfiguration.updateHandler(this.handlerConfiguration);
        }
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        Composite buttonsGroup = UIUtils.createComposite((Composite)composite, (int)5);
        buttonsGroup.setLayoutData((Object)new GridData(768));
        this.useHandlerCheck = UIUtils.createCheckbox((Composite)buttonsGroup, (String)NLS.bind((String)CoreMessages.dialog_tunnel_checkbox_use_handler, (Object)this.handlerDescriptor.getLabel()), (boolean)false);
        this.useHandlerCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionPageNetworkHandler.this.handlerConfiguration.setEnabled(ConnectionPageNetworkHandler.this.useHandlerCheck.getSelection());
                ConnectionPageNetworkHandler.this.enableHandlerContent();
            }
        });
        UIUtils.createEmptyLabel((Composite)buttonsGroup, (int)1, (int)1).setLayoutData((Object)new GridData(768));
        this.profileCombo = UIUtils.createLabelCombo((Composite)buttonsGroup, (String)"Profile", (int)12);
        GridData gd = new GridData(32);
        gd.widthHint = 200;
        this.profileCombo.setLayoutData((Object)gd);
        this.profileCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionPageNetworkHandler.this.setConnectionConfigProfile(ConnectionPageNetworkHandler.this.profileCombo.getText());
            }
        });
        ToolBar editToolbar = new ToolBar(buttonsGroup, 256);
        ToolItem editItem = new ToolItem(editToolbar, 8);
        editItem.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.EDIT));
        editItem.setToolTipText("Edit profiles");
        editItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog preferenceDialog = PreferencesUtil.createPropertyDialogOn((Shell)ConnectionPageNetworkHandler.this.getShell(), (IAdaptable)ConnectionPageNetworkHandler.this.site.getProject().getEclipseProject(), (String)"org.jkiss.dbeaver.project.settings.networkProfiles", null, null);
                if (preferenceDialog != null && preferenceDialog.open() == 0) {
                    ConnectionPageNetworkHandler.this.setConnectionConfigProfile(ConnectionPageNetworkHandler.this.profileCombo.getText());
                }
            }
        });
        this.handlerComposite = UIUtils.createComposite((Composite)composite, (int)1);
        this.handlerComposite.setLayoutData((Object)new GridData(1808));
        this.configurator.createControl(this.handlerComposite, () -> ((ConnectionPageNetworkHandler)this).updatePageCompletion());
        this.configurator.loadSettings((Object)this.handlerConfiguration);
        this.useHandlerCheck.setSelection(this.handlerConfiguration.isEnabled());
        this.enableHandlerContent();
        this.updateProfileList();
        if (this.activeProfile != null && (profileConfig = this.activeProfile.getConfiguration((DBWHandlerDescriptor)this.handlerDescriptor)) != null) {
            this.configurator.loadSettings((Object)profileConfig);
        }
        this.setControl((Control)composite);
    }

    private void setConnectionConfigProfile(String profileName) {
        this.activeProfile = CommonUtils.isEmpty((String)profileName) ? null : this.site.getProject().getDataSourceRegistry().getNetworkProfile(profileName);
        DBPDataSourceContainer dataSource = this.site.getActiveDataSource();
        DBPConnectionConfiguration cfg = dataSource.getConnectionConfiguration();
        String oldProfileId = cfg.getConfigProfileName();
        this.saveSettings(this.site.getActiveDataSource());
        if (this.activeProfile != null) {
            cfg.setConfigProfile(this.activeProfile);
            this.handlerConfiguration = cfg.getHandler(this.handlerDescriptor.getId());
            if (this.handlerConfiguration == null) {
                this.handlerConfiguration = new DBWHandlerConfiguration((DBWHandlerDescriptor)this.handlerDescriptor, dataSource);
            }
        } else {
            cfg.setConfigProfile(null);
        }
        this.site.firePropertyChange((Object)this, PROP_CONFIG_PROFILE, (Object)oldProfileId, this.activeProfile == null ? null : this.activeProfile.getProfileName());
    }

    private void updateProfileList() {
        DBPConnectionConfiguration cfg = this.site.getActiveDataSource().getConnectionConfiguration();
        String profileId = cfg.getConfigProfileName();
        this.activeProfile = CommonUtils.isEmpty((String)profileId) ? null : this.site.getProject().getDataSourceRegistry().getNetworkProfile(profileId);
        this.profileCombo.removeAll();
        this.profileCombo.add("");
        for (DBWNetworkProfile profile : this.site.getProject().getDataSourceRegistry().getNetworkProfiles()) {
            this.profileCombo.add(profile.getProfileName());
            if (!CommonUtils.equalObjects((Object)profileId, (Object)profile.getProfileName())) continue;
            this.profileCombo.select(this.profileCombo.getItemCount() - 1);
        }
        this.handlerConfiguration = cfg.getHandler(this.handlerDescriptor.getId());
        if (this.handlerConfiguration == null) {
            this.handlerConfiguration = new DBWHandlerConfiguration((DBWHandlerDescriptor)this.handlerDescriptor, this.site.getActiveDataSource());
        }
        this.useHandlerCheck.setSelection(this.handlerConfiguration.isEnabled());
        this.configurator.loadSettings((Object)this.handlerConfiguration);
        this.enableHandlerContent();
    }

    protected void enableHandlerContent() {
        boolean hasProfileConfig;
        DBWHandlerConfiguration profileConfig = this.activeProfile == null ? null : this.activeProfile.getConfiguration((DBWHandlerDescriptor)this.handlerDescriptor);
        boolean bl = hasProfileConfig = profileConfig != null && profileConfig.isEnabled();
        if (this.handlerConfiguration.isEnabled() && !hasProfileConfig) {
            if (this.blockEnableState != null) {
                this.blockEnableState.restore();
                this.blockEnableState = null;
            }
        } else if (this.blockEnableState == null) {
            this.blockEnableState = ControlEnableState.disable((Control)this.handlerComposite);
        }
        this.useHandlerCheck.setEnabled(!hasProfileConfig);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    @Override
    public void saveSettings(DBPDataSourceContainer dataSource) {
        if (this.handlerConfiguration != null) {
            this.handlerConfiguration.setProperties(Collections.emptyMap());
            this.configurator.saveSettings((Object)this.handlerConfiguration);
            dataSource.getConnectionConfiguration().setConfigProfile(this.activeProfile);
            dataSource.getConnectionConfiguration().updateHandler(this.handlerConfiguration);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (PROP_CONFIG_PROFILE.equals(event.getProperty())) {
            this.updateProfileList();
        }
    }
}

