/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3.editpolicies;

import java.util.List;
import org.eclipse.draw2dl.ColorConstants;
import org.eclipse.draw2dl.FigureUtilities;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.RectangleFigure;
import org.eclipse.draw2dl.Shape;
import org.eclipse.draw2dl.geometry.Insets;
import org.eclipse.draw2dl.geometry.Point;
import org.eclipse.draw2dl.geometry.Translatable;
import org.eclipse.gef3.EditPart;
import org.eclipse.gef3.EditPartListener;
import org.eclipse.gef3.EditPolicy;
import org.eclipse.gef3.GraphicalEditPart;
import org.eclipse.gef3.Request;
import org.eclipse.gef3.commands.Command;
import org.eclipse.gef3.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef3.requests.ChangeBoundsRequest;
import org.eclipse.gef3.requests.CreateRequest;

public abstract class LayoutEditPolicy
extends GraphicalEditPolicy {
    private IFigure sizeOnDropFeedback;
    private EditPartListener listener;

    @Override
    public void activate() {
        this.setListener(this.createListener());
        this.decorateChildren();
        super.activate();
    }

    protected abstract EditPolicy createChildEditPolicy(EditPart var1);

    protected EditPartListener createListener() {
        return new EditPartListener.Stub(){

            @Override
            public void childAdded(EditPart child, int index) {
                LayoutEditPolicy.this.decorateChild(child);
            }
        };
    }

    protected IFigure createSizeOnDropFeedback(CreateRequest createRequest) {
        return null;
    }

    @Override
    public void deactivate() {
        if (this.sizeOnDropFeedback != null) {
            this.removeFeedback(this.sizeOnDropFeedback);
            this.sizeOnDropFeedback = null;
        }
        this.setListener(null);
        super.deactivate();
    }

    protected void decorateChild(EditPart child) {
        EditPolicy policy = this.createChildEditPolicy(child);
        child.installEditPolicy("PrimaryDrag Policy", policy);
    }

    protected void decorateChildren() {
        List children = this.getHost().getChildren();
        int i = 0;
        while (i < children.size()) {
            this.decorateChild((EditPart)children.get(i));
            ++i;
        }
    }

    protected void eraseLayoutTargetFeedback(Request request) {
    }

    protected void eraseSizeOnDropFeedback(Request request) {
        if (this.sizeOnDropFeedback != null) {
            this.removeFeedback(this.sizeOnDropFeedback);
            this.sizeOnDropFeedback = null;
        }
    }

    @Override
    public void eraseTargetFeedback(Request request) {
        if ("add children".equals(request.getType()) || "move".equals(request.getType()) || "resize children".equals(request.getType()) || "create child".equals(request.getType()) || "clone".equals(request.getType())) {
            this.eraseLayoutTargetFeedback(request);
        }
        if ("create child".equals(request.getType())) {
            this.eraseSizeOnDropFeedback(request);
        }
    }

    protected Command getAddCommand(Request request) {
        return null;
    }

    protected Command getCloneCommand(ChangeBoundsRequest request) {
        return null;
    }

    @Override
    public Command getCommand(Request request) {
        if ("delete dependant".equals(request.getType())) {
            return this.getDeleteDependantCommand(request);
        }
        if ("add children".equals(request.getType())) {
            return this.getAddCommand(request);
        }
        if ("orphan children".equals(request.getType())) {
            return this.getOrphanChildrenCommand(request);
        }
        if ("move children".equals(request.getType())) {
            return this.getMoveChildrenCommand(request);
        }
        if ("clone".equals(request.getType())) {
            return this.getCloneCommand((ChangeBoundsRequest)request);
        }
        if ("create child".equals(request.getType())) {
            return this.getCreateCommand((CreateRequest)request);
        }
        return null;
    }

    protected abstract Command getCreateCommand(CreateRequest var1);

    protected Insets getCreationFeedbackOffset(CreateRequest request) {
        return new Insets();
    }

    protected Command getDeleteDependantCommand(Request request) {
        return null;
    }

    protected IFigure getLayoutContainer() {
        return ((GraphicalEditPart)this.getHost()).getContentPane();
    }

    protected abstract Command getMoveChildrenCommand(Request var1);

    protected Command getOrphanChildrenCommand(Request request) {
        return null;
    }

    protected IFigure getSizeOnDropFeedback(CreateRequest createRequest) {
        if (this.sizeOnDropFeedback == null) {
            this.sizeOnDropFeedback = this.createSizeOnDropFeedback(createRequest);
        }
        return this.getSizeOnDropFeedback();
    }

    protected IFigure getSizeOnDropFeedback() {
        if (this.sizeOnDropFeedback == null) {
            this.sizeOnDropFeedback = new RectangleFigure();
            FigureUtilities.makeGhostShape((Shape)((Shape)this.sizeOnDropFeedback));
            ((Shape)this.sizeOnDropFeedback).setLineStyle(4);
            this.sizeOnDropFeedback.setForegroundColor(ColorConstants.white);
            this.addFeedback(this.sizeOnDropFeedback);
        }
        return this.sizeOnDropFeedback;
    }

    @Override
    public EditPart getTargetEditPart(Request request) {
        if ("add children".equals(request.getType()) || "move".equals(request.getType()) || "create child".equals(request.getType()) || "clone".equals(request.getType())) {
            return this.getHost();
        }
        return null;
    }

    protected void setListener(EditPartListener listener) {
        if (this.listener != null) {
            this.getHost().removeEditPartListener(this.listener);
        }
        this.listener = listener;
        if (this.listener != null) {
            this.getHost().addEditPartListener(this.listener);
        }
    }

    protected void showLayoutTargetFeedback(Request request) {
    }

    protected void showSizeOnDropFeedback(CreateRequest request) {
    }

    @Override
    public void showTargetFeedback(Request request) {
        CreateRequest createReq;
        if ("add children".equals(request.getType()) || "clone".equals(request.getType()) || "move".equals(request.getType()) || "resize children".equals(request.getType()) || "create child".equals(request.getType())) {
            this.showLayoutTargetFeedback(request);
        }
        if ("create child".equals(request.getType()) && (createReq = (CreateRequest)request).getSize() != null) {
            this.showSizeOnDropFeedback(createReq);
        }
    }

    protected void undecorateChild(EditPart child) {
        child.removeEditPolicy("PrimaryDrag Policy");
    }

    protected void undecorateChildren() {
        List children = this.getHost().getChildren();
        int i = 0;
        while (i < children.size()) {
            this.undecorateChild((EditPart)children.get(i));
            ++i;
        }
    }

    protected Point getLayoutOrigin() {
        return this.getLayoutContainer().getClientArea().getLocation();
    }

    protected void translateFromAbsoluteToLayoutRelative(Translatable t) {
        IFigure figure = this.getLayoutContainer();
        figure.translateToRelative(t);
        figure.translateFromParent(t);
        Point negatedLayoutOrigin = this.getLayoutOrigin().getNegated();
        t.performTranslate(negatedLayoutOrigin.x, negatedLayoutOrigin.y);
    }

    protected void translateFromLayoutRelativeToAbsolute(Translatable t) {
        IFigure figure = this.getLayoutContainer();
        Point layoutOrigin = this.getLayoutOrigin();
        t.performTranslate(layoutOrigin.x, layoutOrigin.y);
        figure.translateToParent(t);
        figure.translateToAbsolute(t);
    }
}

