/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone;

import java.lang.reflect.Field;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.commands.CommandImageService;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.app.standalone.about.AboutBoxAction;
import org.jkiss.dbeaver.ui.app.standalone.actions.EmergentExitAction;
import org.jkiss.dbeaver.ui.app.standalone.actions.ResetUISettingsAction;
import org.jkiss.dbeaver.ui.app.standalone.actions.ResetWorkspaceStateAction;
import org.jkiss.dbeaver.ui.app.standalone.internal.CoreApplicationMessages;
import org.jkiss.dbeaver.ui.app.standalone.update.CheckForUpdateAction;
import org.jkiss.dbeaver.ui.controls.StatusLineContributionItemEx;
import org.jkiss.dbeaver.ui.navigator.actions.ToggleViewAction;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.BeanUtils;

public class ApplicationActionBarAdvisor
extends ActionBarAdvisor {
    private static final Log log = Log.getLog(ApplicationActionBarAdvisor.class);
    public static final String M_ALT_HELP = "dbhelp";
    protected IActionDelegate aboutAction;
    protected CheckForUpdateAction checkUpdatesAction;
    protected ActionFactory.IWorkbenchAction showHelpAction;
    protected ActionFactory.IWorkbenchAction newWindowAction;
    private ActionFactory.IWorkbenchAction openWorkspaceAction;
    private static final String[] REDUNTANT_ACTIONS_SETS = new String[]{"org.eclipse.ui.WorkingSetActionSet", "org.eclipse.ui.edit.text.actionSet.annotationNavigation", "org.eclipse.mylyn.tasks.ui.navigation", "org.eclipse.ui.actionSet.openFiles"};

    public ApplicationActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
    }

    private void removeUnWantedActions() {
        IActionSetDescriptor[] actionSets;
        ActionSetRegistry asr = WorkbenchPlugin.getDefault().getActionSetRegistry();
        IActionSetDescriptor[] iActionSetDescriptorArray = actionSets = asr.getActionSets();
        int n = actionSets.length;
        int n2 = 0;
        while (n2 < n) {
            IActionSetDescriptor actionSet = iActionSetDescriptorArray[n2];
            if ("org.eclipse.search.searchActionSet".equals(actionSet.getId())) {
                this.patchSearchIcons(actionSet);
            } else if (ArrayUtils.contains((Object[])REDUNTANT_ACTIONS_SETS, (Object)actionSet.getId())) {
                log.debug((Object)("Disable Eclipse action set '" + actionSet.getId() + "'"));
                IExtension ext = actionSet.getConfigurationElement().getDeclaringExtension();
                asr.removeExtension(ext, new Object[]{actionSet});
            }
            ++n2;
        }
    }

    private void patchSearchIcons(IActionSetDescriptor actionSet) {
        IConfigurationElement[] iConfigurationElementArray = actionSet.getConfigurationElement().getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement searchActionItem = iConfigurationElementArray[n2];
            String saId = searchActionItem.getAttribute("id");
            if ("org.eclipse.search.OpenSearchDialog".equals(saId) || "org.eclipse.search.OpenSearchDialogPage".equals(saId)) {
                this.patchActionSetIcon(searchActionItem, "platform:/plugin/org.jkiss.dbeaver.ui.app.standalone/icons/eclipse/search.png");
            } else if ("org.eclipse.search.OpenFileSearchPage".equals(saId)) {
                this.patchActionSetIcon(searchActionItem, UIIcon.FIND_TEXT.getLocation());
            }
            ++n2;
        }
    }

    private void patchActionSetIcon(IConfigurationElement searchActionItem, String iconPath) {
        try {
            Object cfgElement = BeanUtils.invokeObjectDeclaredMethod((Object)searchActionItem, (String)"getConfigurationElement", (Class[])new Class[0], (Object[])new Object[0]);
            if (cfgElement != null) {
                Field pavField = cfgElement.getClass().getDeclaredField("propertiesAndValue");
                pavField.setAccessible(true);
                String[] pav = (String[])pavField.get(cfgElement);
                int i = 0;
                while (i < pav.length) {
                    if (pav[i].equals("icon")) {
                        pav[i + 1] = iconPath;
                    }
                    i += 2;
                }
            }
        }
        catch (Throwable e) {
            log.debug((Object)"Failed to patch search actions", e);
        }
    }

    protected boolean isShowAltHelp() {
        return true;
    }

    protected void makeActions(IWorkbenchWindow window) {
        this.removeUnWantedActions();
        this.register((IAction)ActionFactory.SAVE.create(window));
        this.register((IAction)ActionFactory.SAVE_AS.create(window));
        this.register((IAction)ActionFactory.SAVE_ALL.create(window));
        this.register((IAction)ActionFactory.CLOSE.create(window));
        this.register((IAction)ActionFactory.PRINT.create(window));
        this.aboutAction = new AboutBoxAction(window);
        this.showHelpAction = ActionFactory.HELP_CONTENTS.create(window);
        this.register((IAction)this.showHelpAction);
        this.checkUpdatesAction = new CheckForUpdateAction();
        this.newWindowAction = ActionFactory.OPEN_NEW_WINDOW.create(window);
        this.register((IAction)this.newWindowAction);
        this.openWorkspaceAction = IDEActionFactory.OPEN_WORKSPACE.create(window);
        this.register((IAction)this.openWorkspaceAction);
        CheckForUpdateAction.deactivateStandardHandler(window);
    }

    private void patchImages() {
        ICommandImageService service;
        IWorkbenchWindow workbenchWindow = this.getActionBarConfigurer().getWindowConfigurer().getWindow();
        if (workbenchWindow != null && (service = (ICommandImageService)workbenchWindow.getService(ICommandImageService.class)) instanceof CommandImageService) {
            CommandImageService cis = (CommandImageService)service;
            this.bindImage(cis, "org.eclipse.ui.file.save", UIIcon.SAVE);
            this.bindImage(cis, "org.eclipse.ui.file.saveAs", UIIcon.SAVE_AS);
            this.bindImage(cis, "org.eclipse.ui.file.saveAll", UIIcon.SAVE_ALL);
            this.bindImage(cis, "org.eclipse.ui.file.import", UIIcon.IMPORT);
            this.bindImage(cis, "org.eclipse.ui.file.export", UIIcon.EXPORT);
            this.bindImage(cis, "org.eclipse.ui.file.refresh", UIIcon.REFRESH);
        }
    }

    private void bindImage(CommandImageService cis, String commandId, DBIcon icon) {
        ImageDescriptor id = DBeaverIcons.getImageDescriptor((DBPImage)icon);
        cis.bind(commandId, 0, null, id);
        cis.bind(commandId, 2, null, id);
        cis.bind(commandId, 1, null, null);
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        this.patchImages();
        menuBar.updateAll(true);
        this.isShowAltHelp();
        MenuManager fileMenu = new MenuManager(CoreMessages.actions_menu_file, "file");
        MenuManager editMenu = new MenuManager(CoreMessages.actions_menu_edit, "edit");
        MenuManager navigateMenu = new MenuManager(CoreMessages.actions_menu_navigate, "navigate");
        MenuManager windowMenu = new MenuManager(CoreMessages.actions_menu_window, "window");
        MenuManager helpMenu = new MenuManager(CoreMessages.actions_menu_help, "help");
        menuBar.add((IContributionItem)fileMenu);
        menuBar.add((IContributionItem)editMenu);
        menuBar.add((IContributionItem)navigateMenu);
        menuBar.add((IContributionItem)new GroupMarker("additions"));
        menuBar.add((IContributionItem)windowMenu);
        menuBar.add((IContributionItem)helpMenu);
        IWorkbenchWindow workbenchWindow = this.getActionBarConfigurer().getWindowConfigurer().getWindow();
        MenuManager recentEditors = new MenuManager(CoreApplicationMessages.actions_menu_recent_editors);
        recentEditors.add(ContributionItemFactory.REOPEN_EDITORS.create(workbenchWindow));
        recentEditors.add((IContributionItem)new GroupMarker("mru"));
        fileMenu.add((IContributionItem)recentEditors);
        fileMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)workbenchWindow, (String)"org.eclipse.ui.edit.text.openLocalFile"));
        fileMenu.add((IContributionItem)new GroupMarker("fileStart"));
        fileMenu.add((IContributionItem)new GroupMarker("new.ext"));
        fileMenu.add((IContributionItem)new GroupMarker("additions"));
        fileMenu.add((IAction)this.openWorkspaceAction);
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IAction)new ResetUISettingsAction(workbenchWindow));
        fileMenu.add((IAction)new ResetWorkspaceStateAction(workbenchWindow));
        fileMenu.add((IAction)new EmergentExitAction(workbenchWindow));
        fileMenu.add((IContributionItem)new GroupMarker("fileEnd"));
        navigateMenu.add((IContributionItem)new GroupMarker("navStart"));
        navigateMenu.add((IContributionItem)new Separator("open.ext"));
        navigateMenu.add((IContributionItem)new Separator("show.ext"));
        navigateMenu.add((IContributionItem)new Separator("additions"));
        navigateMenu.add((IContributionItem)new GroupMarker("navEnd"));
        navigateMenu.add((IContributionItem)new GroupMarker("group.application"));
        windowMenu.add((IAction)this.newWindowAction);
        windowMenu.add((IContributionItem)new Separator());
        windowMenu.add((IAction)new ToggleViewAction("org.jkiss.dbeaver.core.databaseNavigator"));
        windowMenu.add((IAction)new ToggleViewAction("org.jkiss.dbeaver.core.projectNavigator"));
        windowMenu.add((IAction)new ToggleViewAction("org.jkiss.dbeaver.core.projectExplorer"));
        windowMenu.add((IContributionItem)new GroupMarker("primary.views"));
        MenuManager showViewMenuMgr = new MenuManager(CoreMessages.actions_menu_window_showView, "showView");
        IContributionItem showViewMenu = ContributionItemFactory.VIEWS_SHORTLIST.create(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        showViewMenuMgr.add(showViewMenu);
        windowMenu.add((IContributionItem)showViewMenuMgr);
        windowMenu.add((IContributionItem)new Separator());
        windowMenu.add((IContributionItem)new GroupMarker("perspective"));
        windowMenu.add((IContributionItem)new GroupMarker("additions"));
        windowMenu.add((IContributionItem)new Separator());
        helpMenu.add(ActionUtils.makeAction((IActionDelegate)this.aboutAction, null, null, (String)CoreMessages.actions_menu_about, null, null));
        helpMenu.add((IAction)this.showHelpAction);
        helpMenu.add((IContributionItem)new Separator());
        helpMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)workbenchWindow, (String)"org.eclipse.ui.help.installationDialog"));
        helpMenu.add((IContributionItem)new GroupMarker("additions"));
        helpMenu.add((IContributionItem)new Separator());
        helpMenu.add((IContributionItem)new GroupMarker("installation_help"));
    }

    protected void fillCoolBar(ICoolBarManager coolBar) {
        coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)new ToolBarManager(0x804000), "dbeaver-general"));
        coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)new ToolBarManager(0x820000), "dbeaver-transactions"));
        coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)new ToolBarManager(0x820000), "dbeaver-edit"));
    }

    protected void fillStatusLine(IStatusLineManager statusLine) {
        StatusLineContributionItemEx tzItem = new StatusLineContributionItemEx("Time Zone");
        TimeZone tzDefault = TimeZone.getDefault();
        tzItem.setText(tzDefault.getDisplayName(false, 0));
        tzItem.setToolTip(tzDefault.getDisplayName(false, 1));
        tzItem.setDoubleClickListener(() -> UIUtils.showMessageBox(null, (String)"Time zone", (String)("You can change time zone by adding parameter\n-Duser.timezone=<TimeZone>\nin the end of file '" + DBWorkbench.getPlatform().getApplicationConfiguration().getAbsolutePath() + "'"), (int)2));
        statusLine.add((IContributionItem)tzItem);
        StatusLineContributionItemEx localeItem = new StatusLineContributionItemEx("Locale");
        localeItem.setText(Locale.getDefault().toString());
        localeItem.setToolTip(Locale.getDefault().getDisplayName());
        localeItem.setDoubleClickListener(() -> UIUtils.showMessageBox(null, (String)"Locale", (String)("You can change locale by adding parameters\n-nl\n<language_iso_code>\nin file '" + DBWorkbench.getPlatform().getApplicationConfiguration().getAbsolutePath() + "'.\n" + "Or by passing command line parameter -nl <language_iso_code>"), (int)2));
        statusLine.add((IContributionItem)localeItem);
    }
}

