/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.impl.data.DBDValueError;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetLabelProvider;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;

public class ResultSetLabelProviderDefault
implements IResultSetLabelProvider {
    private final ResultSetViewer viewer;
    private Color foregroundNull;
    private final Map<DBPDataKind, Color> dataTypesForegrounds = new IdentityHashMap<DBPDataKind, Color>();
    private boolean colorizeDataTypes = true;
    private Color backgroundError;

    ResultSetLabelProviderDefault(ResultSetViewer viewer) {
        this.viewer = viewer;
        this.applyThemeSettings();
    }

    void applyThemeSettings() {
        this.applyThemeSettings(PlatformUI.getWorkbench().getThemeManager().getCurrentTheme());
    }

    @Override
    @Nullable
    public DBPImage getCellImage(DBDAttributeBinding attribute, ResultSetRow row) {
        return null;
    }

    @Override
    @Nullable
    public Color getCellForeground(DBDAttributeBinding attribute, ResultSetRow row) {
        Color color;
        Object value;
        if (row.colorInfo != null) {
            Color cellFG;
            if (row.colorInfo.cellFgColors != null && (cellFG = row.colorInfo.cellFgColors[attribute.getOrdinalPosition()]) != null) {
                return cellFG;
            }
            if (row.colorInfo.rowForeground != null) {
                return row.colorInfo.rowForeground;
            }
        }
        if (DBUtils.isNullValue((Object)(value = this.viewer.getModel().getCellValue(attribute, row)))) {
            return this.foregroundNull;
        }
        if (this.colorizeDataTypes && (color = this.dataTypesForegrounds.get(attribute.getDataKind())) != null) {
            return color;
        }
        return null;
    }

    @Override
    @Nullable
    public Color getCellBackground(DBDAttributeBinding attribute, ResultSetRow row) {
        Object value;
        if (row.colorInfo != null) {
            Color cellBG;
            if (row.colorInfo.cellBgColors != null && (cellBG = row.colorInfo.cellBgColors[attribute.getOrdinalPosition()]) != null) {
                return cellBG;
            }
            if (row.colorInfo.rowBackground != null) {
                return row.colorInfo.rowBackground;
            }
        }
        if ((value = this.viewer.getModel().getCellValue(attribute, row)) != null && value.getClass() == DBDValueError.class) {
            return this.backgroundError;
        }
        return null;
    }

    protected void applyThemeSettings(ITheme currentTheme) {
        this.colorizeDataTypes = this.viewer.getPreferenceStore().getBoolean("resultset.show.colorizeDataTypes");
        ColorRegistry colorRegistry = currentTheme.getColorRegistry();
        this.foregroundNull = colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.null.foreground");
        this.backgroundError = colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.cell.error.background");
        this.dataTypesForegrounds.put(DBPDataKind.BINARY, colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.binary.foreground"));
        this.dataTypesForegrounds.put(DBPDataKind.BOOLEAN, colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.boolean.foreground"));
        this.dataTypesForegrounds.put(DBPDataKind.DATETIME, colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.datetime.foreground"));
        this.dataTypesForegrounds.put(DBPDataKind.NUMERIC, colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.numeric.foreground"));
        this.dataTypesForegrounds.put(DBPDataKind.STRING, colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.string.foreground"));
    }
}

