/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2dl;

import org.eclipse.draw2dl.Border;
import org.eclipse.draw2dl.CompoundBorder;
import org.eclipse.draw2dl.Figure;
import org.eclipse.draw2dl.GroupBoxBorder;
import org.eclipse.draw2dl.LabeledBorder;
import org.eclipse.swt.graphics.Font;

public class LabeledContainer
extends Figure {
    public LabeledContainer() {
        this(new GroupBoxBorder());
    }

    public LabeledContainer(Border border) {
        this.setBorder(border);
        this.setOpaque(true);
    }

    private static LabeledBorder findLabeledBorder(Border border) {
        if (border instanceof LabeledBorder) {
            return (LabeledBorder)border;
        }
        if (border instanceof CompoundBorder) {
            CompoundBorder cb = (CompoundBorder)border;
            LabeledBorder labeled = LabeledContainer.findLabeledBorder(cb.getInnerBorder());
            if (labeled == null) {
                labeled = LabeledContainer.findLabeledBorder(cb.getOuterBorder());
            }
            return labeled;
        }
        return null;
    }

    public String getLabel() {
        return this.getLabeledBorder().getLabel();
    }

    protected LabeledBorder getLabeledBorder() {
        return LabeledContainer.findLabeledBorder(this.getBorder());
    }

    public void setLabel(String s) {
        this.getLabeledBorder().setLabel(s);
        this.revalidate();
        this.repaint();
    }

    public void setLabelFont(Font f) {
        this.getLabeledBorder().setFont(f);
        this.revalidate();
        this.repaint();
    }
}

