/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2dl;

import org.eclipse.draw2dl.AbstractLabeledBorder;
import org.eclipse.draw2dl.FigureUtilities;
import org.eclipse.draw2dl.Graphics;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.geometry.Dimension;
import org.eclipse.draw2dl.geometry.Insets;
import org.eclipse.draw2dl.geometry.Rectangle;

public class GroupBoxBorder
extends AbstractLabeledBorder {
    public GroupBoxBorder() {
    }

    public GroupBoxBorder(String s) {
        super(s);
    }

    @Override
    protected Insets calculateInsets(IFigure figure) {
        int height = this.getTextExtents((IFigure)figure).height;
        return new Insets(height);
    }

    @Override
    public Dimension getPreferredSize(IFigure fig) {
        Dimension textSize = this.getTextExtents(fig);
        return textSize.getCopy().expand(textSize.height * 2, 0);
    }

    @Override
    public void paint(IFigure figure, Graphics g, Insets insets) {
        tempRect.setBounds(GroupBoxBorder.getPaintRectangle(figure, insets));
        Rectangle r = tempRect;
        if (r.isEmpty()) {
            return;
        }
        Rectangle textLoc = new Rectangle(r.getTopLeft(), this.getTextExtents(figure));
        r.crop(new Insets(this.getTextExtents((IFigure)figure).height / 2));
        FigureUtilities.paintEtchedBorder(g, r);
        textLoc.x += this.getInsets((IFigure)figure).left;
        g.setFont(this.getFont(figure));
        g.setForegroundColor(this.getTextColor());
        g.clipRect(textLoc);
        g.fillText(this.getLabel(), textLoc.getTopLeft());
    }
}

